/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.ProxySelector;
import java.net.URL;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.SSLSocketFactory;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import org.jdesktop.swinghelper.debug.CheckThreadViolationRepaintManager;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.PreferencesAction;
import org.openstreetmap.josm.actions.RestartAction;
import org.openstreetmap.josm.data.AutosaveTask;
import org.openstreetmap.josm.data.CustomConfigurator;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainFrame;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.ProgramArguments;
import org.openstreetmap.josm.gui.SplashScreen;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.preferences.server.OAuthAccessTokenHolder;
import org.openstreetmap.josm.gui.preferences.server.ProxyPreference;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.CertificateAmendment;
import org.openstreetmap.josm.io.DefaultProxySelector;
import org.openstreetmap.josm.io.MessageNotifier;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.io.auth.CredentialsManager;
import org.openstreetmap.josm.io.auth.DefaultAuthenticator;
import org.openstreetmap.josm.io.protocols.data.Handler;
import org.openstreetmap.josm.io.remotecontrol.RemoteControl;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.tools.FontsManager;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.OsmUrlToBounds;
import org.openstreetmap.josm.tools.PlatformHookWindows;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.WindowGeometry;
import org.openstreetmap.josm.tools.bugreport.BugReport;
import org.openstreetmap.josm.tools.bugreport.BugReportExceptionHandler;

public class MainApplication
extends Main {
    private static final List<String> COMMAND_LINE_ARGS = new ArrayList<String>();
    private MainFrame mainFrame;

    public MainApplication() {
        this(null);
    }

    public MainApplication(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
    }

    @Override
    protected void initializeMainWindow() {
        mainPanel.reAddListeners();
        if (this.mainFrame != null) {
            this.mainFrame.initialize();
            this.menu = this.mainFrame.getMenu();
        } else {
            this.menu = new MainMenu();
        }
    }

    @Override
    protected void shutdown() {
        if (this.mainFrame != null) {
            this.mainFrame.storeState();
        }
        super.shutdown();
    }

    public static List<String> getCommandLineArgs() {
        return Collections.unmodifiableList(COMMAND_LINE_ARGS);
    }

    public static void showHelp() {
        System.out.println(MainApplication.getHelp());
    }

    static String getHelp() {
        return I18n.tr("Java OpenStreetMap Editor", new Object[0]) + " [" + Version.getInstance().getAgentString() + "]\n\n" + I18n.tr("usage", new Object[0]) + ":\n\tjava -jar josm.jar <options>...\n\n" + I18n.tr("options", new Object[0]) + ":\n\t--help|-h                                 " + I18n.tr("Show this help", new Object[0]) + '\n' + "\t--geometry=widthxheight(+|-)x(+|-)y       " + I18n.tr("Standard unix geometry argument", new Object[0]) + '\n' + "\t[--download=]minlat,minlon,maxlat,maxlon  " + I18n.tr("Download the bounding box", new Object[0]) + '\n' + "\t[--download=]<URL>                        " + I18n.tr("Download the location at the URL (with lat=x&lon=y&zoom=z)", new Object[0]) + '\n' + "\t[--download=]<filename>                   " + I18n.tr("Open a file (any file type that can be opened with File/Open)", new Object[0]) + '\n' + "\t--downloadgps=minlat,minlon,maxlat,maxlon " + I18n.tr("Download the bounding box as raw GPS", new Object[0]) + '\n' + "\t--downloadgps=<URL>                       " + I18n.tr("Download the location at the URL (with lat=x&lon=y&zoom=z) as raw GPS", new Object[0]) + '\n' + "\t--selection=<searchstring>                " + I18n.tr("Select with the given search", new Object[0]) + '\n' + "\t--[no-]maximize                           " + I18n.tr("Launch in maximized mode", new Object[0]) + '\n' + "\t--reset-preferences                       " + I18n.tr("Reset the preferences to default", new Object[0]) + "\n\n\t--load-preferences=<url-to-xml>           " + I18n.tr("Changes preferences according to the XML file", new Object[0]) + "\n\n\t--set=<key>=<value>                       " + I18n.tr("Set preference key to value", new Object[0]) + "\n\n\t--language=<language>                     " + I18n.tr("Set the language", new Object[0]) + "\n\n\t--version                                 " + I18n.tr("Displays the JOSM version and exits", new Object[0]) + "\n\n\t--debug                                   " + I18n.tr("Print debugging messages to console", new Object[0]) + "\n\n\t--skip-plugins                            " + I18n.tr("Skip loading plugins", new Object[0]) + "\n\n\t--offline=<osm_api|josm_website|all>      " + I18n.tr("Disable access to the given resource(s), separated by comma", new Object[0]) + "\n\n" + I18n.tr("options provided as Java system properties", new Object[0]) + ":\n" + MainApplication.align("\t-Djosm.dir.name=JOSM") + I18n.tr("Change the JOSM directory name", new Object[0]) + "\n\n" + MainApplication.align("\t-Djosm.pref=" + I18n.tr("/PATH/TO/JOSM/PREF    ", new Object[0])) + I18n.tr("Set the preferences directory", new Object[0]) + "\n" + MainApplication.align("\t") + I18n.tr("Default: {0}", platform.getDefaultPrefDirectory()) + "\n\n" + MainApplication.align("\t-Djosm.userdata=" + I18n.tr("/PATH/TO/JOSM/USERDATA", new Object[0])) + I18n.tr("Set the user data directory", new Object[0]) + "\n" + MainApplication.align("\t") + I18n.tr("Default: {0}", platform.getDefaultUserDataDirectory()) + "\n\n" + MainApplication.align("\t-Djosm.cache=" + I18n.tr("/PATH/TO/JOSM/CACHE   ", new Object[0])) + I18n.tr("Set the cache directory", new Object[0]) + "\n" + MainApplication.align("\t") + I18n.tr("Default: {0}", platform.getDefaultCacheDirectory()) + "\n\n" + MainApplication.align("\t-Djosm.home=" + I18n.tr("/PATH/TO/JOSM/HOMEDIR ", new Object[0])) + I18n.tr("Set the preferences+data+cache directory (cache directory will be josm.home/cache)", new Object[0]) + "\n\n" + I18n.tr("-Djosm.home has lower precedence, i.e. the specific setting overrides the general one", new Object[0]) + "\n\n" + I18n.tr("note: For some tasks, JOSM needs a lot of memory. It can be necessary to add the following\n      Java option to specify the maximum size of allocated memory in megabytes", new Object[0]) + ":\n\t-Xmx...m\n\n" + I18n.tr("examples", new Object[0]) + ":\n\tjava -jar josm.jar track1.gpx track2.gpx london.osm\n\tjava -jar josm.jar " + OsmUrlToBounds.getURL(43.2, 11.1, 13) + '\n' + "\tjava -jar josm.jar london.osm --selection=http://www.ostertag.name/osm/OSM_errors_node-duplicate.xml\n\tjava -jar josm.jar 43.2,11.1,43.4,11.4\n\tjava -Djosm.pref=$XDG_CONFIG_HOME -Djosm.userdata=$XDG_DATA_HOME -Djosm.cache=$XDG_CACHE_HOME -jar josm.jar\n\tjava -Djosm.dir.name=josm_dev -jar josm.jar\n\tjava -Djosm.home=/home/user/.josm_dev -jar josm.jar\n\tjava -Xmx1024m -jar josm.jar\n\n" + I18n.tr("Parameters --download, --downloadgps, and --selection are processed in this order.", new Object[0]) + '\n' + I18n.tr("Make sure you load some data if you use --selection.", new Object[0]) + '\n';
    }

    private static String align(String string) {
        return string + Stream.generate(() -> " ").limit(Math.max(0, 43 - string.length())).collect(Collectors.joining(""));
    }

    public static void main(String[] stringArray) {
        Object object;
        Object iOException;
        Object object4;
        I18n.init();
        ProgramArguments programArguments = null;
        try {
            programArguments = new ProgramArguments(stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException.getMessage());
            System.exit(1);
            return;
        }
        Level level = programArguments.getLogLevel();
        Logging.setLogLevel(level);
        if (!programArguments.showVersion() && !programArguments.showHelp()) {
            Main.info(I18n.tr("Log level is at {0} ({1}, {2})", level.getLocalizedName(), level.getName(), level.intValue()));
        }
        Optional<String> optional = programArguments.getSingle(ProgramArguments.Option.LANGUAGE);
        I18n.set(optional.orElse(null));
        Policy.setPolicy(new Policy(){
            private PermissionCollection pc = new Permissions();
            {
                this.pc.add(new AllPermission());
            }

            @Override
            public PermissionCollection getPermissions(CodeSource codeSource) {
                return this.pc;
            }
        });
        Thread.setDefaultUncaughtExceptionHandler(new BugReportExceptionHandler());
        Main.determinePlatformHook();
        Main.platform.preStartupHook();
        if (programArguments.showVersion()) {
            System.out.println(Version.getInstance().getAgentString());
            return;
        }
        if (programArguments.showHelp()) {
            MainApplication.showHelp();
            return;
        }
        COMMAND_LINE_ARGS.addAll(Arrays.asList(stringArray));
        boolean bl = programArguments.hasOption(ProgramArguments.Option.SKIP_PLUGINS);
        if (bl) {
            Main.info(I18n.tr("Plugin loading skipped", new Object[0]));
        }
        if (Logging.isLoggingEnabled(Logging.LEVEL_TRACE)) {
            Utils.updateSystemProperty("debug", "true");
            Main.info(I18n.tr("Enabled detailed debug level (trace)", new Object[0]));
        }
        Main.pref.init(programArguments.hasOption(ProgramArguments.Option.RESET_PREFERENCES));
        programArguments.getPreferencesToSet().forEach(Main.pref::put);
        if (!optional.isPresent()) {
            I18n.set(Main.pref.get("language", null));
        }
        Main.pref.updateSystemProperties();
        MainApplication.checkIPv6();
        MainApplication.processOffline(programArguments);
        Main.platform.afterPrefStartupHook();
        FontsManager.initialize();
        I18n.setupLanguageFonts();
        Handler.install();
        WindowGeometry windowGeometry = WindowGeometry.mainWindow("gui.geometry", programArguments.getSingle(ProgramArguments.Option.GEOMETRY).orElse(null), !programArguments.hasOption(ProgramArguments.Option.NO_MAXIMIZE) && Main.pref.getBoolean("gui.maximized", false));
        MainFrame mainFrame = new MainFrame(contentPanePrivate, windowGeometry);
        Main.parent = mainFrame;
        if (programArguments.hasOption(ProgramArguments.Option.LOAD_PREFERENCES)) {
            object4 = new CustomConfigurator.XMLCommandProcessor(Main.pref);
            for (String object32 : programArguments.get(ProgramArguments.Option.LOAD_PREFERENCES)) {
                MainApplication.info("Reading preferences from " + object32);
                try {
                    iOException = MainApplication.openStream(new URL(object32));
                    object = null;
                    try {
                        ((CustomConfigurator.XMLCommandProcessor)object4).openAndReadXML((InputStream)iOException);
                    }
                    catch (Throwable bl2) {
                        object = bl2;
                        throw bl2;
                    }
                    finally {
                        if (iOException == null) continue;
                        if (object != null) {
                            try {
                                ((InputStream)iOException).close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                            continue;
                        }
                        ((InputStream)iOException).close();
                    }
                }
                catch (IOException iOException2) {
                    throw BugReport.intercept(iOException2).put("file", object32);
                }
            }
        }
        try {
            CertificateAmendment.addMissingCertificates();
        }
        catch (IOException | GeneralSecurityException exception) {
            Main.warn(exception);
            Main.warn(MainApplication.getErrorMessage(Utils.getRootCause(exception)));
        }
        Authenticator.setDefault(DefaultAuthenticator.getInstance());
        object4 = new DefaultProxySelector(ProxySelector.getDefault());
        ProxySelector.setDefault((ProxySelector)object4);
        OAuthAccessTokenHolder.getInstance().init(Main.pref, CredentialsManager.getInstance());
        SplashScreen splashScreen = GuiHelper.runInEDTAndWaitAndReturn(SplashScreen::new);
        final SplashScreen.SplashProgressMonitor splashProgressMonitor = splashScreen.getProgressMonitor();
        splashProgressMonitor.beginTask(I18n.tr("Initializing", new Object[0]));
        GuiHelper.runInEDT(() -> splashScreen.setVisible(Main.pref.getBoolean("draw.splashscreen", true)));
        Main.setInitStatusListener(new Main.InitStatusListener(){

            @Override
            public Object updateStatus(String string) {
                splashProgressMonitor.beginTask(string);
                return string;
            }

            @Override
            public void finish(Object object) {
                if (object instanceof String) {
                    splashProgressMonitor.finishTask((String)object);
                }
            }
        });
        iOException = null;
        if (!bl) {
            iOException = MainApplication.updateAndLoadEarlyPlugins(splashScreen, splashProgressMonitor);
        }
        splashProgressMonitor.indeterminateSubTask(I18n.tr("Setting defaults", new Object[0]));
        MainApplication.preConstructorInit();
        splashProgressMonitor.indeterminateSubTask(I18n.tr("Creating main GUI", new Object[0]));
        object = new MainApplication(mainFrame);
        ((Main)object).initialize();
        if (!bl) {
            MainApplication.loadLatePlugins(splashScreen, splashProgressMonitor, (Collection<PluginInformation>)iOException);
        }
        GuiHelper.runInEDTAndWait(() -> {
            splashScreen.setVisible(false);
            splashScreen.dispose();
            mainFrame.setVisible(true);
        });
        boolean bl2 = Main.pref.getBoolean("gui.maximized", false);
        if (!programArguments.hasOption(ProgramArguments.Option.NO_MAXIMIZE) && bl2 || programArguments.hasOption(ProgramArguments.Option.MAXIMIZE)) {
            mainFrame.setMaximized(true);
        }
        if (((Main)object).menu.fullscreenToggleAction != null) {
            ((Main)object).menu.fullscreenToggleAction.initial();
        }
        SwingUtilities.invokeLater(new GuiFinalizationWorker(programArguments, (DefaultProxySelector)object4));
        if (Main.isPlatformWindows()) {
            try {
                PlatformHookWindows.removeInsecureCertificates();
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException exception) {
                MainApplication.error(exception);
            }
        }
        if (RemoteControl.PROP_REMOTECONTROL_ENABLED.get().booleanValue()) {
            RemoteControl.start();
        }
        if (MessageNotifier.PROP_NOTIFIER_ENABLED.get().booleanValue()) {
            MessageNotifier.start();
        }
        if (Main.pref.getBoolean("debug.edt-checker.enable", Version.getInstance().isLocalBuild())) {
            MainApplication.info("Enabled EDT checker, wrongful access to gui from non EDT thread will be printed to console");
            RepaintManager.setCurrentManager(new CheckThreadViolationRepaintManager());
        }
    }

    private static InputStream openStream(URL uRL) throws IOException {
        if ("file".equals(uRL.getProtocol())) {
            return uRL.openStream();
        }
        return HttpClient.create(uRL).connect().getContent();
    }

    static Collection<PluginInformation> updateAndLoadEarlyPlugins(SplashScreen splashScreen, SplashScreen.SplashProgressMonitor splashProgressMonitor) {
        Collection<PluginInformation> collection = PluginHandler.buildListOfPluginsToLoad(splashScreen, splashProgressMonitor.createSubTaskMonitor(1, false));
        if (!collection.isEmpty() && PluginHandler.checkAndConfirmPluginUpdate(splashScreen)) {
            splashProgressMonitor.subTask(I18n.tr("Updating plugins", new Object[0]));
            collection = PluginHandler.updatePlugins(splashScreen, null, splashProgressMonitor.createSubTaskMonitor(1, false), false);
        }
        splashProgressMonitor.indeterminateSubTask(I18n.tr("Installing updated plugins", new Object[0]));
        PluginHandler.installDownloadedPlugins(true);
        splashProgressMonitor.indeterminateSubTask(I18n.tr("Loading early plugins", new Object[0]));
        PluginHandler.loadEarlyPlugins(splashScreen, collection, splashProgressMonitor.createSubTaskMonitor(1, false));
        return collection;
    }

    static void loadLatePlugins(SplashScreen splashScreen, SplashScreen.SplashProgressMonitor splashProgressMonitor, Collection<PluginInformation> collection) {
        splashProgressMonitor.indeterminateSubTask(I18n.tr("Loading plugins", new Object[0]));
        PluginHandler.loadLatePlugins(splashScreen, collection, splashProgressMonitor.createSubTaskMonitor(1, false));
        toolbar.refreshToolbarControl();
    }

    private static void processOffline(ProgramArguments programArguments) {
        for (String string : programArguments.get(ProgramArguments.Option.OFFLINE)) {
            for (String string2 : string.split(",")) {
                try {
                    Main.setOffline(OnlineResource.valueOf(string2.toUpperCase(Locale.ENGLISH)));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Main.error((Throwable)illegalArgumentException, I18n.tr("''{0}'' is not a valid value for argument ''{1}''. Possible values are {2}, possibly delimited by commas.", string2.toUpperCase(Locale.ENGLISH), ProgramArguments.Option.OFFLINE.getName(), Arrays.toString((Object[])OnlineResource.values())));
                    System.exit(1);
                    return;
                }
            }
        }
        Set<OnlineResource> set = Main.getOfflineResources();
        if (!set.isEmpty()) {
            Main.warn(I18n.trn("JOSM is running in offline mode. This resource will not be available: {0}", "JOSM is running in offline mode. These resources will not be available: {0}", set.size(), set.size() == 1 ? set.iterator().next() : Arrays.toString(set.toArray())));
        }
    }

    private static void checkIPv6() {
        if ("auto".equals(Main.pref.get("prefer.ipv6", "auto"))) {
            new Thread(() -> {
                boolean bl = false;
                boolean bl2 = Main.pref.getBoolean("validated.ipv6", false);
                try {
                    if (bl2) {
                        Utils.updateSystemProperty("java.net.preferIPv6Addresses", "true");
                    }
                    for (InetAddress inetAddress : InetAddress.getAllByName("josm.openstreetmap.de")) {
                        if (!(inetAddress instanceof Inet6Address)) continue;
                        if (inetAddress.isReachable(1000)) {
                            SSLSocketFactory.getDefault().createSocket(inetAddress, 443).close();
                            Utils.updateSystemProperty("java.net.preferIPv6Addresses", "true");
                            if (!bl2) {
                                Main.info(I18n.tr("Detected useable IPv6 network, prefering IPv6 over IPv4 after next restart.", new Object[0]));
                            } else {
                                Main.info(I18n.tr("Detected useable IPv6 network, prefering IPv6 over IPv4.", new Object[0]));
                            }
                            bl = true;
                        }
                        break;
                    }
                }
                catch (IOException | SecurityException exception) {
                    if (Main.isDebugEnabled()) {
                        Main.debug("Exception while checking IPv6 connectivity: " + exception);
                    }
                    Main.trace(exception);
                }
                if (bl2 && !bl) {
                    Main.info(I18n.tr("Detected no useable IPv6 network, prefering IPv4 over IPv6 after next restart.", new Object[0]));
                    Main.pref.put("validated.ipv6", bl);
                    new RestartAction().actionPerformed(null);
                }
                Main.pref.put("validated.ipv6", bl);
            }, "IPv6-checker").start();
        }
    }

    private static class GuiFinalizationWorker
    implements Runnable {
        private final ProgramArguments args;
        private final DefaultProxySelector proxySelector;

        GuiFinalizationWorker(ProgramArguments programArguments, DefaultProxySelector defaultProxySelector) {
            this.args = programArguments;
            this.proxySelector = defaultProxySelector;
        }

        @Override
        public void run() {
            if (!this.handleProxyErrors()) {
                GuiFinalizationWorker.handleNetworkErrors();
            }
            GuiFinalizationWorker.handleAutosave();
            MainApplication.postConstructorProcessCmdLine(this.args);
            DownloadDialog.autostartIfNeeded();
        }

        private static void handleAutosave() {
            if (AutosaveTask.PROP_AUTOSAVE_ENABLED.get().booleanValue()) {
                AutosaveTask autosaveTask = new AutosaveTask();
                List<File> list = autosaveTask.getUnsavedLayersFiles();
                if (!list.isEmpty()) {
                    ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Unsaved osm data", new Object[0]), I18n.tr("Restore", new Object[0]), I18n.tr("Cancel", new Object[0]), I18n.tr("Discard", new Object[0]));
                    extendedDialog.setContent(I18n.trn("JOSM found {0} unsaved osm data layer. ", "JOSM found {0} unsaved osm data layers. ", list.size(), list.size()) + I18n.tr("It looks like JOSM crashed last time. Would you like to restore the data?", new Object[0]));
                    extendedDialog.setButtonIcons("ok", "cancel", "dialogs/delete");
                    int n = extendedDialog.showDialog().getValue();
                    if (n == 1) {
                        autosaveTask.recoverUnsavedLayers();
                    } else if (n == 3) {
                        autosaveTask.discardUnsavedLayers();
                    }
                }
                autosaveTask.schedule();
            }
        }

        private static boolean handleNetworkOrProxyErrors(boolean bl, String string, String string2) {
            if (bl) {
                ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, string, I18n.tr("Change proxy settings", new Object[0]), I18n.tr("Cancel", new Object[0]));
                extendedDialog.setButtonIcons("dialogs/settings", "cancel").setCancelButton(2);
                extendedDialog.setMinimumSize(new Dimension(460, 260));
                extendedDialog.setIcon(2);
                extendedDialog.setContent(string2);
                if (extendedDialog.showDialog().getValue() == 1) {
                    PreferencesAction.forPreferenceSubTab(null, null, ProxyPreference.class).run();
                }
            }
            return bl;
        }

        private boolean handleProxyErrors() {
            return GuiFinalizationWorker.handleNetworkOrProxyErrors(this.proxySelector.hasErrors(), I18n.tr("Proxy errors occurred", new Object[0]), I18n.tr("JOSM tried to access the following resources:<br>{0}but <b>failed</b> to do so, because of the following proxy errors:<br>{1}Would you like to change your proxy settings now?", Utils.joinAsHtmlUnorderedList(this.proxySelector.getErrorResources()), Utils.joinAsHtmlUnorderedList(this.proxySelector.getErrorMessages())));
        }

        private static boolean handleNetworkErrors() {
            boolean bl;
            Map<String, Throwable> map = Main.getNetworkErrors();
            boolean bl2 = bl = !map.isEmpty();
            if (bl) {
                TreeSet<String> treeSet = new TreeSet<String>();
                for (Throwable throwable : map.values()) {
                    treeSet.add(throwable.toString());
                }
                return GuiFinalizationWorker.handleNetworkOrProxyErrors(bl, I18n.tr("Network errors occurred", new Object[0]), I18n.tr("JOSM tried to access the following resources:<br>{0}but <b>failed</b> to do so, because of the following network errors:<br>{1}It may be due to a missing proxy configuration.<br>Would you like to change your proxy settings now?", Utils.joinAsHtmlUnorderedList(map.keySet()), Utils.joinAsHtmlUnorderedList(treeSet)));
            }
            return false;
        }
    }
}

