/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Objects;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public final class CertificateAmendment {
    private static final CertAmend[] CERT_AMEND = new CertAmend[]{new CertAmend("resource://data/security/DST_Root_CA_X3.pem", "0687260331a72403d909f105e69bcf0d32e1bd2493ffc6d9206d11bcd6770739")};
    private static final CertAmend[] PLATFORM_CERT_AMEND = new CertAmend[]{new CertAmend("Staat der Nederlanden Root CA - G2", "668c83947da63b724bece1743c31a0e6aed0db8ec5b31be377bb784f91b6716f"), new CertAmend("Government of Netherlands G3", "3c4fb0b95ab8b30032f432b86f535fe172c185d0fd39865837cf36187fa6f428")};

    private CertificateAmendment() {
    }

    public static void addMissingCertificates() throws IOException, GeneralSecurityException {
        Object object;
        if (!Main.pref.getBoolean("tls.add-missing-certificates", true)) {
            return;
        }
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        Path path = Paths.get(System.getProperty("java.home"), "lib", "security", "cacerts");
        Object object2 = Files.newInputStream(path, new OpenOption[0]);
        Object object3 = null;
        try {
            keyStore.load((InputStream)object2, "changeit".toCharArray());
        }
        catch (Throwable throwable) {
            object3 = throwable;
            throw throwable;
        }
        finally {
            if (object2 != null) {
                if (object3 != null) {
                    try {
                        ((InputStream)object2).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object3).addSuppressed(throwable);
                    }
                } else {
                    ((InputStream)object2).close();
                }
            }
        }
        object2 = MessageDigest.getInstance("SHA-256");
        object3 = CertificateFactory.getInstance("X.509");
        boolean bl = false;
        for (CertAmend object4 : CERT_AMEND) {
            object = new CachedFile(object4.id);
            Throwable throwable = null;
            try {
                X509Certificate throwable2 = (X509Certificate)((CertificateFactory)object3).generateCertificate(new ByteArrayInputStream(((CachedFile)object).getByteContent()));
                if (!CertificateAmendment.checkAndAddCertificate((MessageDigest)object2, throwable2, object4, keyStore)) continue;
                bl = true;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            ((CachedFile)object).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((CachedFile)object).close();
                    }
                }
            }
        }
        try {
            for (CertAmend certAmend : PLATFORM_CERT_AMEND) {
                object = Main.platform.getX509Certificate(certAmend);
                if (!CertificateAmendment.checkAndAddCertificate((MessageDigest)object2, (X509Certificate)object, certAmend, keyStore)) continue;
                bl = true;
            }
        }
        catch (IOException | IllegalStateException | KeyStoreException | NoSuchAlgorithmException | CertificateException exception) {
            Main.error(exception);
        }
        if (bl) {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            sSLContext.init(null, trustManagerFactory.getTrustManagers(), null);
            SSLContext.setDefault(sSLContext);
        }
    }

    private static boolean checkAndAddCertificate(MessageDigest messageDigest, X509Certificate x509Certificate, CertAmend certAmend, KeyStore keyStore) throws CertificateEncodingException, KeyStoreException, InvalidAlgorithmParameterException {
        if (x509Certificate != null) {
            String string = Utils.toHexString(messageDigest.digest(x509Certificate.getEncoded()));
            if (!certAmend.sha256.equals(string)) {
                throw new IllegalStateException(I18n.tr("Error adding certificate {0} - certificate fingerprint mismatch. Expected {1}, was {2}", certAmend.id, certAmend.sha256, string));
            }
            if (CertificateAmendment.certificateIsMissing(keyStore, x509Certificate)) {
                if (Main.isDebugEnabled()) {
                    Main.debug(I18n.tr("Adding certificate for TLS connections: {0}", x509Certificate.getSubjectX500Principal().getName()));
                }
                String string2 = "josm:" + new File(certAmend.id).getName();
                keyStore.setCertificateEntry(string2, x509Certificate);
                return true;
            }
        }
        return false;
    }

    private static boolean certificateIsMissing(KeyStore keyStore, X509Certificate x509Certificate) throws KeyStoreException, InvalidAlgorithmParameterException {
        PKIXParameters pKIXParameters = new PKIXParameters(keyStore);
        String string = x509Certificate.getSubjectX500Principal().getName();
        for (TrustAnchor trustAnchor : pKIXParameters.getTrustAnchors()) {
            X509Certificate x509Certificate2 = trustAnchor.getTrustedCert();
            if (!Objects.equals(string, x509Certificate2.getSubjectX500Principal().getName())) continue;
            return false;
        }
        return true;
    }

    public static class CertAmend {
        private final String id;
        private final String sha256;

        CertAmend(String string, String string2) {
            this.id = string;
            this.sha256 = string2;
        }

        public final String getId() {
            return this.id;
        }

        public final String getSha256() {
            return this.sha256;
        }
    }
}

