/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.annotations;

import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptorImpl;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.constants.AnnotationValue;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a&\u0010\u0002\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u0006\u001a\n\u0010\t\u001a\u00020\u0003*\u00020\u0004\u001a\u001b\u0010\n\u001a\u00020\u000b*\b\u0012\u0004\u0012\u00020\u000b0\f2\u0006\u0010\r\u001a\u00020\u0006H\u0082\u0002\u001a\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0010H\u0002\u001a\n\u0010\u0011\u001a\u00020\u000f*\u00020\u0012\u001a\n\u0010\u0013\u001a\u00020\u000f*\u00020\u0012\u001a\f\u0010\u0014\u001a\u00020\u000f*\u00020\u0010H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"INLINE_ONLY_ANNOTATION_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "createDeprecatedAnnotation", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "message", "", "replaceWith", "level", "createUnsafeVarianceAnnotation", "get", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "", "parameterName", "hasInlineOnlyAnnotation", "", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "isInlineOnly", "Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;", "isInlineOnlyOrReifiable", "isReifiable", "kotlin-compiler"})
public final class AnnotationUtilKt {
    private static final FqName INLINE_ONLY_ANNOTATION_FQ_NAME = new FqName("kotlin.internal.InlineOnly");

    @NotNull
    public static final AnnotationDescriptor createDeprecatedAnnotation(@NotNull KotlinBuiltIns $receiver, @NotNull String message, @NotNull String replaceWith, @NotNull String level) {
        AnnotationDescriptorImpl annotationDescriptorImpl;
        EnumValue enumValue;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(message, "message");
        Intrinsics.checkParameterIsNotNull(replaceWith, "replaceWith");
        Intrinsics.checkParameterIsNotNull(level, "level");
        ClassDescriptor deprecatedAnnotation = $receiver.getDeprecatedAnnotation();
        ClassConstructorDescriptor classConstructorDescriptor = deprecatedAnnotation.getUnsubstitutedPrimaryConstructor();
        if (classConstructorDescriptor == null) {
            Intrinsics.throwNpe();
        }
        List<ValueParameterDescriptor> parameters2 = classConstructorDescriptor.getValueParameters();
        ClassDescriptor replaceWithClass = $receiver.getBuiltInClassByName(Name.identifier("ReplaceWith"));
        ClassConstructorDescriptor classConstructorDescriptor2 = replaceWithClass.getUnsubstitutedPrimaryConstructor();
        if (classConstructorDescriptor2 == null) {
            Intrinsics.throwNpe();
        }
        List<ValueParameterDescriptor> replaceWithParameters = classConstructorDescriptor2.getValueParameters();
        KotlinType kotlinType = deprecatedAnnotation.getDefaultType();
        Pair[] pairArray = new Pair[3];
        pairArray[0] = TuplesKt.to(AnnotationUtilKt.get((Collection<? extends ValueParameterDescriptor>)parameters2, "message"), new StringValue(message, $receiver));
        ValueParameterDescriptor valueParameterDescriptor = AnnotationUtilKt.get((Collection<? extends ValueParameterDescriptor>)parameters2, "replaceWith");
        KotlinType kotlinType2 = replaceWithClass.getDefaultType();
        Pair[] pairArray2 = new Pair[2];
        pairArray2[0] = TuplesKt.to(AnnotationUtilKt.get((Collection<? extends ValueParameterDescriptor>)replaceWithParameters, "expression"), new StringValue(replaceWith, $receiver));
        ValueParameterDescriptor valueParameterDescriptor2 = AnnotationUtilKt.get((Collection<? extends ValueParameterDescriptor>)replaceWithParameters, "imports");
        List list2 = CollectionsKt.emptyList();
        SimpleType simpleType2 = $receiver.getArrayType(Variance.INVARIANT, $receiver.getStringType());
        Intrinsics.checkExpressionValueIsNotNull(simpleType2, "getArrayType(Variance.INVARIANT, stringType)");
        pairArray2[1] = TuplesKt.to(valueParameterDescriptor2, new ArrayValue(list2, simpleType2, $receiver));
        pairArray[1] = TuplesKt.to(valueParameterDescriptor, new AnnotationValue(new AnnotationDescriptorImpl(kotlinType2, MapsKt.mapOf(pairArray2), SourceElement.NO_SOURCE)));
        ValueParameterDescriptor valueParameterDescriptor3 = AnnotationUtilKt.get((Collection<? extends ValueParameterDescriptor>)parameters2, "level");
        ClassDescriptor classDescriptor = $receiver.getDeprecationLevelEnumEntry(level);
        if (classDescriptor == null) {
            String string = "Deprecation level " + level + " not found";
            EnumValue enumValue2 = enumValue;
            EnumValue enumValue3 = enumValue;
            ValueParameterDescriptor valueParameterDescriptor4 = valueParameterDescriptor3;
            int n = 2;
            Pair[] pairArray3 = pairArray;
            Pair[] pairArray4 = pairArray;
            KotlinType kotlinType3 = kotlinType;
            AnnotationDescriptorImpl annotationDescriptorImpl2 = annotationDescriptorImpl;
            AnnotationDescriptorImpl annotationDescriptorImpl3 = annotationDescriptorImpl;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        enumValue = new EnumValue(classDescriptor);
        pairArray[2] = TuplesKt.to(valueParameterDescriptor3, enumValue);
        annotationDescriptorImpl = new AnnotationDescriptorImpl(kotlinType, MapsKt.mapOf(pairArray), SourceElement.NO_SOURCE);
        return annotationDescriptorImpl;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ AnnotationDescriptor createDeprecatedAnnotation$default(KotlinBuiltIns kotlinBuiltIns, String string, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "";
        }
        if ((n & 4) != 0) {
            string3 = "WARNING";
        }
        return AnnotationUtilKt.createDeprecatedAnnotation(kotlinBuiltIns, string, string2, string3);
    }

    @NotNull
    public static final AnnotationDescriptor createUnsafeVarianceAnnotation(@NotNull KotlinBuiltIns $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ClassDescriptor unsafeVarianceAnnotation = $receiver.getBuiltInClassByFqName(KotlinBuiltIns.FQ_NAMES.unsafeVariance);
        return new AnnotationDescriptorImpl(unsafeVarianceAnnotation.getDefaultType(), MapsKt.<ValueParameterDescriptor, ConstantValue<?>>emptyMap(), SourceElement.NO_SOURCE);
    }

    /*
     * WARNING - void declaration
     */
    private static final ValueParameterDescriptor get(@NotNull Collection<? extends ValueParameterDescriptor> $receiver, String parameterName) {
        void var3_3;
        Iterable $receiver$iv = $receiver;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $receiver$iv) {
            ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
            if (!Intrinsics.areEqual(it.getName().asString(), parameterName)) continue;
            if (found$iv) {
                throw (Throwable)new IllegalArgumentException("Collection contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return (ValueParameterDescriptor)var3_3;
    }

    public static final boolean isInlineOnlyOrReifiable(@NotNull MemberDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver instanceof CallableMemberDescriptor && (AnnotationUtilKt.isReifiable((CallableMemberDescriptor)$receiver) || AnnotationUtilKt.isReifiable(DescriptorUtils.getDirectMember((CallableMemberDescriptor)$receiver)) || AnnotationUtilKt.isInlineOnly($receiver));
    }

    public static final boolean isInlineOnly(@NotNull MemberDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if (!($receiver instanceof FunctionDescriptor) || !AnnotationUtilKt.hasInlineOnlyAnnotation((CallableMemberDescriptor)$receiver) && !AnnotationUtilKt.hasInlineOnlyAnnotation(DescriptorUtils.getDirectMember((CallableMemberDescriptor)$receiver))) {
            return false;
        }
        boolean bl = ((FunctionDescriptor)$receiver).isInline();
        if (_Assertions.ENABLED && !bl) {
            String string = "Function is not inline: " + $receiver;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return true;
    }

    private static final boolean isReifiable(@NotNull CallableMemberDescriptor $receiver) {
        boolean bl;
        block1: {
            Iterable $receiver$iv = $receiver.getTypeParameters();
            for (Object element$iv : $receiver$iv) {
                TypeParameterDescriptor it = (TypeParameterDescriptor)element$iv;
                if (!it.isReified()) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private static final boolean hasInlineOnlyAnnotation(@NotNull CallableMemberDescriptor $receiver) {
        return $receiver.getAnnotations().hasAnnotation(INLINE_ONLY_ANNOTATION_FQ_NAME);
    }
}

