/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsCatch;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsTry;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.expression.CatchTranslator;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFinallySection;
import org.jetbrains.kotlin.psi.KtTryExpression;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\u0002\u001a\u0004\u0018\u00010\rH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/js/translate/expression/TryTranslator;", "Lorg/jetbrains/kotlin/js/translate/general/AbstractTranslator;", "expression", "Lorg/jetbrains/kotlin/psi/KtTryExpression;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "(Lorg/jetbrains/kotlin/psi/KtTryExpression;Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;)V", "getExpression", "()Lorg/jetbrains/kotlin/psi/KtTryExpression;", "translate", "Lorg/jetbrains/kotlin/js/backend/ast/JsTry;", "translateAsBlock", "Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "kotlin-compiler"})
public final class TryTranslator
extends AbstractTranslator {
    @NotNull
    private final KtTryExpression expression;

    @NotNull
    public final JsTry translate() {
        JsBlock tryBlock = this.translateAsBlock(this.expression.getTryBlock());
        List<KtCatchClause> list2 = this.expression.getCatchClauses();
        Intrinsics.checkExpressionValueIsNotNull(list2, "expression.catchClauses");
        TranslationContext translationContext = this.context();
        Intrinsics.checkExpressionValueIsNotNull(translationContext, "context()");
        CatchTranslator catchTranslator = new CatchTranslator(list2, translationContext);
        JsCatch catchBlock = catchTranslator.translate();
        KtFinallySection ktFinallySection = this.expression.getFinallyBlock();
        KtBlockExpression finallyExpression = ktFinallySection != null ? ktFinallySection.getFinalExpression() : null;
        JsBlock finallyBlock = this.translateAsBlock(finallyExpression);
        return new JsTry(tryBlock, catchBlock, finallyBlock);
    }

    private final JsBlock translateAsBlock(KtExpression expression) {
        if (expression == null) {
            return null;
        }
        JsStatement statement = Translation.translateAsStatementAndMergeInBlockIfNeeded(expression, this.context());
        return JsAstUtils.convertToBlock(statement);
    }

    @NotNull
    public final KtTryExpression getExpression() {
        return this.expression;
    }

    public TryTranslator(@NotNull KtTryExpression expression, @NotNull TranslationContext context) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        super(context);
        this.expression = expression;
    }
}

