/*
 * Decompiled with CFR 0.152.
 */
package com.sun.beans.editors;

import java.awt.Canvas;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.TextField;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;

public class ColorEditor
extends Panel
implements PropertyEditor {
    private static final long serialVersionUID = 1781257185164716054L;
    private String[] colorNames = new String[]{" ", "white", "lightGray", "gray", "darkGray", "black", "red", "pink", "orange", "yellow", "green", "magenta", "cyan", "blue"};
    private Color[] colors = new Color[]{null, Color.white, Color.lightGray, Color.gray, Color.darkGray, Color.black, Color.red, Color.pink, Color.orange, Color.yellow, Color.green, Color.magenta, Color.cyan, Color.blue};
    private Canvas sample;
    private int sampleHeight = 20;
    private int sampleWidth = 40;
    private int hPad = 5;
    private int ourWidth;
    private Color color;
    private TextField text;
    private Choice choser;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);

    public ColorEditor() {
        this.setLayout(null);
        this.ourWidth = this.hPad;
        Panel p = new Panel();
        p.setLayout(null);
        p.setBackground(Color.black);
        this.sample = new Canvas();
        p.add(this.sample);
        this.sample.reshape(2, 2, this.sampleWidth, this.sampleHeight);
        this.add(p);
        p.reshape(this.ourWidth, 2, this.sampleWidth + 4, this.sampleHeight + 4);
        this.ourWidth += this.sampleWidth + 4 + this.hPad;
        this.text = new TextField("", 14);
        this.add(this.text);
        this.text.reshape(this.ourWidth, 0, 100, 30);
        this.ourWidth += 100 + this.hPad;
        this.choser = new Choice();
        boolean active = false;
        for (int i = 0; i < this.colorNames.length; ++i) {
            this.choser.addItem(this.colorNames[i]);
        }
        this.add(this.choser);
        this.choser.reshape(this.ourWidth, 0, 100, 30);
        this.ourWidth += 100 + this.hPad;
        this.resize(this.ourWidth, 40);
    }

    @Override
    public void setValue(Object o) {
        Color c = (Color)o;
        this.changeColor(c);
    }

    @Override
    public Dimension preferredSize() {
        return new Dimension(this.ourWidth, 40);
    }

    @Override
    public boolean keyUp(Event e, int key) {
        if (e.target == this.text) {
            try {
                this.setAsText(this.text.getText());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public void setAsText(String s) throws IllegalArgumentException {
        if (s == null) {
            this.changeColor(null);
            return;
        }
        int c1 = s.indexOf(44);
        int c2 = s.indexOf(44, c1 + 1);
        if (c1 < 0 || c2 < 0) {
            throw new IllegalArgumentException(s);
        }
        try {
            int r = Integer.parseInt(s.substring(0, c1));
            int g = Integer.parseInt(s.substring(c1 + 1, c2));
            int b = Integer.parseInt(s.substring(c2 + 1));
            Color c = new Color(r, g, b);
            this.changeColor(c);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(s);
        }
    }

    @Override
    public boolean action(Event e, Object arg) {
        if (e.target == this.choser) {
            this.changeColor(this.colors[this.choser.getSelectedIndex()]);
        }
        return false;
    }

    @Override
    public String getJavaInitializationString() {
        return this.color != null ? "new java.awt.Color(" + this.color.getRGB() + ",true)" : "null";
    }

    private void changeColor(Color c) {
        if (c == null) {
            this.color = null;
            this.text.setText("");
            return;
        }
        this.color = c;
        this.text.setText("" + c.getRed() + "," + c.getGreen() + "," + c.getBlue());
        int active = 0;
        for (int i = 0; i < this.colorNames.length; ++i) {
            if (!this.color.equals(this.colors[i])) continue;
            active = i;
        }
        this.choser.select(active);
        this.sample.setBackground(this.color);
        this.sample.repaint();
        this.support.firePropertyChange("", null, null);
    }

    @Override
    public Object getValue() {
        return this.color;
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        Color oldColor = gfx.getColor();
        gfx.setColor(Color.black);
        gfx.drawRect(box.x, box.y, box.width - 3, box.height - 3);
        gfx.setColor(this.color);
        gfx.fillRect(box.x + 1, box.y + 1, box.width - 4, box.height - 4);
        gfx.setColor(oldColor);
    }

    @Override
    public String getAsText() {
        return this.color != null ? this.color.getRed() + "," + this.color.getGreen() + "," + this.color.getBlue() : null;
    }

    @Override
    public String[] getTags() {
        return null;
    }

    @Override
    public Component getCustomEditor() {
        return this;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.support.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.support.removePropertyChangeListener(l);
    }
}

