/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.ldap;

import com.sun.jndi.ldap.BerEncoder;
import java.io.IOException;
import javax.naming.ldap.BasicControl;

public final class PagedResultsControl
extends BasicControl {
    public static final String OID = "1.2.840.113556.1.4.319";
    private static final byte[] EMPTY_COOKIE = new byte[0];
    private static final long serialVersionUID = 6684806685736844298L;

    public PagedResultsControl(int pageSize, boolean criticality) throws IOException {
        super(OID, criticality, null);
        this.value = this.setEncodedValue(pageSize, EMPTY_COOKIE);
    }

    public PagedResultsControl(int pageSize, byte[] cookie, boolean criticality) throws IOException {
        super(OID, criticality, null);
        if (cookie == null) {
            cookie = EMPTY_COOKIE;
        }
        this.value = this.setEncodedValue(pageSize, cookie);
    }

    private byte[] setEncodedValue(int pageSize, byte[] cookie) throws IOException {
        BerEncoder ber = new BerEncoder(10 + cookie.length);
        ber.beginSeq(48);
        ber.encodeInt(pageSize);
        ber.encodeOctetString(cookie, 4);
        ber.endSeq();
        return ber.getTrimmedBuf();
    }
}

