/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import sun.misc.FDBigInt;

public class FormattedFloatingDecimal {
    boolean isExceptional;
    boolean isNegative;
    int decExponent;
    int decExponentRounded;
    char[] digits;
    int nDigits;
    int bigIntExp;
    int bigIntNBits;
    boolean mustSetRoundDir = false;
    boolean fromHex = false;
    int roundDir = 0;
    int precision;
    private Form form;
    static final long signMask = Long.MIN_VALUE;
    static final long expMask = 0x7FF0000000000000L;
    static final long fractMask = 0xFFFFFFFFFFFFFL;
    static final int expShift = 52;
    static final int expBias = 1023;
    static final long fractHOB = 0x10000000000000L;
    static final long expOne = 0x3FF0000000000000L;
    static final int maxSmallBinExp = 62;
    static final int minSmallBinExp = -21;
    static final int maxDecimalDigits = 15;
    static final int maxDecimalExponent = 308;
    static final int minDecimalExponent = -324;
    static final int bigDecimalExponent = 324;
    static final long highbyte = -72057594037927936L;
    static final long highbit = Long.MIN_VALUE;
    static final long lowbytes = 0xFFFFFFFFFFFFFFL;
    static final int singleSignMask = Integer.MIN_VALUE;
    static final int singleExpMask = 2139095040;
    static final int singleFractMask = 0x7FFFFF;
    static final int singleExpShift = 23;
    static final int singleFractHOB = 0x800000;
    static final int singleExpBias = 127;
    static final int singleMaxDecimalDigits = 7;
    static final int singleMaxDecimalExponent = 38;
    static final int singleMinDecimalExponent = -45;
    static final int intDecimalDigits = 9;
    private static FDBigInt[] b5p;
    private static ThreadLocal perThreadBuffer;
    private static final double[] small10pow;
    private static final float[] singleSmall10pow;
    private static final double[] big10pow;
    private static final double[] tiny10pow;
    private static final int maxSmallTen;
    private static final int singleMaxSmallTen;
    private static final int[] small5pow;
    private static final long[] long5pow;
    private static final int[] n5bits;
    private static final char[] infinity;
    private static final char[] notANumber;
    private static final char[] zero;

    private FormattedFloatingDecimal(boolean negSign, int decExponent, char[] digits, int n, boolean e, int precision, Form form) {
        this.isNegative = negSign;
        this.isExceptional = e;
        this.decExponent = decExponent;
        this.digits = digits;
        this.nDigits = n;
        this.precision = precision;
        this.form = form;
    }

    private static int countBits(long v) {
        if (v == 0L) {
            return 0;
        }
        while ((v & 0xFF00000000000000L) == 0L) {
            v <<= 8;
        }
        while (v > 0L) {
            v <<= 1;
        }
        int n = 0;
        while ((v & 0xFFFFFFFFFFFFFFL) != 0L) {
            v <<= 8;
            n += 8;
        }
        while (v != 0L) {
            v <<= 1;
            ++n;
        }
        return n;
    }

    private static synchronized FDBigInt big5pow(int p) {
        assert (p >= 0) : p;
        if (b5p == null) {
            b5p = new FDBigInt[p + 1];
        } else if (b5p.length <= p) {
            FDBigInt[] t = new FDBigInt[p + 1];
            System.arraycopy(b5p, 0, t, 0, b5p.length);
            b5p = t;
        }
        if (b5p[p] != null) {
            return b5p[p];
        }
        if (p < small5pow.length) {
            FormattedFloatingDecimal.b5p[p] = new FDBigInt(small5pow[p]);
            return FormattedFloatingDecimal.b5p[p];
        }
        if (p < long5pow.length) {
            FormattedFloatingDecimal.b5p[p] = new FDBigInt(long5pow[p]);
            return FormattedFloatingDecimal.b5p[p];
        }
        int q = p >> 1;
        int r = p - q;
        FDBigInt bigq = b5p[q];
        if (bigq == null) {
            bigq = FormattedFloatingDecimal.big5pow(q);
        }
        if (r < small5pow.length) {
            FormattedFloatingDecimal.b5p[p] = bigq.mult(small5pow[r]);
            return FormattedFloatingDecimal.b5p[p];
        }
        FDBigInt bigr = b5p[r];
        if (bigr == null) {
            bigr = FormattedFloatingDecimal.big5pow(r);
        }
        FormattedFloatingDecimal.b5p[p] = bigq.mult(bigr);
        return FormattedFloatingDecimal.b5p[p];
    }

    private static FDBigInt multPow52(FDBigInt v, int p5, int p2) {
        if (p5 != 0) {
            v = p5 < small5pow.length ? v.mult(small5pow[p5]) : v.mult(FormattedFloatingDecimal.big5pow(p5));
        }
        if (p2 != 0) {
            v.lshiftMe(p2);
        }
        return v;
    }

    private static FDBigInt constructPow52(int p5, int p2) {
        FDBigInt v = new FDBigInt(FormattedFloatingDecimal.big5pow(p5));
        if (p2 != 0) {
            v.lshiftMe(p2);
        }
        return v;
    }

    private FDBigInt doubleToBigInt(double dval) {
        long lbits = Double.doubleToLongBits(dval) & Long.MAX_VALUE;
        int binexp = (int)(lbits >>> 52);
        lbits &= 0xFFFFFFFFFFFFFL;
        if (binexp > 0) {
            lbits |= 0x10000000000000L;
        } else {
            assert (lbits != 0L) : lbits;
            ++binexp;
            while ((lbits & 0x10000000000000L) == 0L) {
                lbits <<= 1;
                --binexp;
            }
        }
        int nbits = FormattedFloatingDecimal.countBits(lbits);
        int lowOrderZeros = 53 - nbits;
        this.bigIntExp = (binexp -= 1023) + 1 - nbits;
        this.bigIntNBits = nbits;
        return new FDBigInt(lbits >>>= lowOrderZeros);
    }

    private static double ulp(double dval, boolean subtracting) {
        long lbits = Double.doubleToLongBits(dval) & Long.MAX_VALUE;
        int binexp = (int)(lbits >>> 52);
        if (subtracting && binexp >= 52 && (lbits & 0xFFFFFFFFFFFFFL) == 0L) {
            --binexp;
        }
        double ulpval = binexp > 52 ? Double.longBitsToDouble((long)(binexp - 52) << 52) : (binexp == 0 ? Double.MIN_VALUE : Double.longBitsToDouble(1L << binexp - 1));
        if (subtracting) {
            ulpval = -ulpval;
        }
        return ulpval;
    }

    float stickyRound(double dval) {
        long lbits = Double.doubleToLongBits(dval);
        long binexp = lbits & 0x7FF0000000000000L;
        if (binexp == 0L || binexp == 0x7FF0000000000000L) {
            return (float)dval;
        }
        return (float)Double.longBitsToDouble(lbits += (long)this.roundDir);
    }

    private void developLongDigits(int decExponent, long lvalue, long insignificant) {
        int digitno;
        char[] digits;
        int ndigits;
        int i = 0;
        while (insignificant >= 10L) {
            insignificant /= 10L;
            ++i;
        }
        if (i != 0) {
            long pow10 = long5pow[i] << i;
            long residue = lvalue % pow10;
            lvalue /= pow10;
            decExponent += i;
            if (residue >= pow10 >> 1) {
                ++lvalue;
            }
        }
        if (lvalue <= Integer.MAX_VALUE) {
            assert (lvalue > 0L) : lvalue;
            int ivalue = (int)lvalue;
            ndigits = 10;
            digits = (char[])perThreadBuffer.get();
            digitno = ndigits - 1;
            int c = ivalue % 10;
            ivalue /= 10;
            while (c == 0) {
                ++decExponent;
                c = ivalue % 10;
                ivalue /= 10;
            }
            while (ivalue != 0) {
                digits[digitno--] = (char)(c + 48);
                ++decExponent;
                c = ivalue % 10;
                ivalue /= 10;
            }
            digits[digitno] = (char)(c + 48);
        } else {
            ndigits = 20;
            digits = (char[])perThreadBuffer.get();
            digitno = ndigits - 1;
            int c = (int)(lvalue % 10L);
            lvalue /= 10L;
            while (c == 0) {
                ++decExponent;
                c = (int)(lvalue % 10L);
                lvalue /= 10L;
            }
            while (lvalue != 0L) {
                digits[digitno--] = (char)(c + 48);
                ++decExponent;
                c = (int)(lvalue % 10L);
                lvalue /= 10L;
            }
            digits[digitno] = (char)(c + 48);
        }
        char[] result = new char[ndigits -= digitno];
        System.arraycopy(digits, digitno, result, 0, ndigits);
        this.digits = result;
        this.decExponent = decExponent + 1;
        this.nDigits = ndigits;
    }

    private void roundup() {
        int i = this.nDigits - 1;
        char q = this.digits[i];
        if (q == '9') {
            while (q == '9' && i > 0) {
                this.digits[i] = 48;
                q = this.digits[--i];
            }
            if (q == '9') {
                ++this.decExponent;
                this.digits[0] = 49;
                return;
            }
        }
        this.digits[i] = (char)(q + '\u0001');
    }

    private int checkExponent(int length) {
        if (length >= this.nDigits || length < 0) {
            return this.decExponent;
        }
        for (int i = 0; i < length; ++i) {
            if (this.digits[i] == '9') continue;
            return this.decExponent;
        }
        return this.decExponent + (this.digits[length] >= '5' ? 1 : 0);
    }

    private char[] applyPrecision(int length) {
        int i;
        char[] result = new char[this.nDigits];
        for (i = 0; i < result.length; ++i) {
            result[i] = 48;
        }
        if (length >= this.nDigits || length < 0) {
            System.arraycopy(this.digits, 0, result, 0, this.nDigits);
            return result;
        }
        if (length == 0) {
            if (this.digits[0] >= '5') {
                result[0] = 49;
            }
            return result;
        }
        i = length;
        char q = this.digits[i];
        if (q >= '5' && i > 0) {
            if ((q = this.digits[--i]) == '9') {
                while (q == '9' && i > 0) {
                    q = this.digits[--i];
                }
                if (q == '9') {
                    result[0] = 49;
                    return result;
                }
            }
            result[i] = (char)(q + '\u0001');
        }
        while (--i >= 0) {
            result[i] = this.digits[i];
        }
        return result;
    }

    public FormattedFloatingDecimal(double d) {
        this(d, Integer.MAX_VALUE, Form.COMPATIBLE);
    }

    public FormattedFloatingDecimal(double d, int precision, Form form) {
        int nSignificantBits;
        long dBits = Double.doubleToLongBits(d);
        this.precision = precision;
        this.form = form;
        if ((dBits & Long.MIN_VALUE) != 0L) {
            this.isNegative = true;
            dBits ^= Long.MIN_VALUE;
        } else {
            this.isNegative = false;
        }
        int binExp = (int)((dBits & 0x7FF0000000000000L) >> 52);
        long fractBits = dBits & 0xFFFFFFFFFFFFFL;
        if (binExp == 2047) {
            this.isExceptional = true;
            if (fractBits == 0L) {
                this.digits = infinity;
            } else {
                this.digits = notANumber;
                this.isNegative = false;
            }
            this.nDigits = this.digits.length;
            return;
        }
        this.isExceptional = false;
        if (binExp == 0) {
            if (fractBits == 0L) {
                this.decExponent = 0;
                this.digits = zero;
                this.nDigits = 1;
                return;
            }
            while ((fractBits & 0x10000000000000L) == 0L) {
                fractBits <<= 1;
                --binExp;
            }
            nSignificantBits = 52 + binExp + 1;
            ++binExp;
        } else {
            fractBits |= 0x10000000000000L;
            nSignificantBits = 53;
        }
        this.dtoa(binExp -= 1023, fractBits, nSignificantBits);
    }

    public FormattedFloatingDecimal(float f) {
        this(f, Integer.MAX_VALUE, Form.COMPATIBLE);
    }

    public FormattedFloatingDecimal(float f, int precision, Form form) {
        int nSignificantBits;
        int fBits = Float.floatToIntBits(f);
        this.precision = precision;
        this.form = form;
        if ((fBits & Integer.MIN_VALUE) != 0) {
            this.isNegative = true;
            fBits ^= Integer.MIN_VALUE;
        } else {
            this.isNegative = false;
        }
        int binExp = (fBits & 0x7F800000) >> 23;
        int fractBits = fBits & 0x7FFFFF;
        if (binExp == 255) {
            this.isExceptional = true;
            if ((long)fractBits == 0L) {
                this.digits = infinity;
            } else {
                this.digits = notANumber;
                this.isNegative = false;
            }
            this.nDigits = this.digits.length;
            return;
        }
        this.isExceptional = false;
        if (binExp == 0) {
            if (fractBits == 0) {
                this.decExponent = 0;
                this.digits = zero;
                this.nDigits = 1;
                return;
            }
            while ((fractBits & 0x800000) == 0) {
                fractBits <<= 1;
                --binExp;
            }
            nSignificantBits = 23 + binExp + 1;
            ++binExp;
        } else {
            fractBits |= 0x800000;
            nSignificantBits = 24;
        }
        this.dtoa(binExp -= 127, (long)fractBits << 29, nSignificantBits);
    }

    private void dtoa(int binExp, long fractBits, int nSignificantBits) {
        long lowDigitDifference;
        boolean high;
        boolean low;
        int nFractBits = FormattedFloatingDecimal.countBits(fractBits);
        int nTinyBits = Math.max(0, nFractBits - binExp - 1);
        if (binExp <= 62 && binExp >= -21 && nTinyBits < long5pow.length && nFractBits + n5bits[nTinyBits] < 64 && nTinyBits == 0) {
            long halfULP = binExp > nSignificantBits ? 1L << binExp - nSignificantBits - 1 : 0L;
            fractBits = binExp >= 52 ? (fractBits <<= binExp - 52) : (fractBits >>>= 52 - binExp);
            this.developLongDigits(0, fractBits, halfULP);
            return;
        }
        double d2 = Double.longBitsToDouble(0x3FF0000000000000L | fractBits & 0xFFEFFFFFFFFFFFFFL);
        int decExp = (int)Math.floor((d2 - 1.5) * 0.289529654 + 0.176091259 + (double)binExp * 0.301029995663981);
        int B5 = Math.max(0, -decExp);
        int B2 = B5 + nTinyBits + binExp;
        int S5 = Math.max(0, decExp);
        int S2 = S5 + nTinyBits;
        int M5 = B5;
        int M2 = B2 - nSignificantBits;
        fractBits >>>= 53 - nFractBits;
        int common2factor = Math.min(B2 -= nFractBits - 1, S2);
        B2 -= common2factor;
        S2 -= common2factor;
        M2 -= common2factor;
        if (nFractBits == 1) {
            --M2;
        }
        if (M2 < 0) {
            B2 -= M2;
            S2 -= M2;
            M2 = 0;
        }
        this.digits = new char[18];
        char[] digits = this.digits;
        int ndigit = 0;
        int Bbits = nFractBits + B2 + (B5 < n5bits.length ? n5bits[B5] : B5 * 3);
        int tenSbits = S2 + 1 + (S5 + 1 < n5bits.length ? n5bits[S5 + 1] : (S5 + 1) * 3);
        if (Bbits < 64 && tenSbits < 64) {
            if (Bbits < 32 && tenSbits < 32) {
                int b = (int)fractBits * small5pow[B5] << B2;
                int s = small5pow[S5] << S2;
                int m = small5pow[M5] << M2;
                int tens = s * 10;
                ndigit = 0;
                int q = b / s;
                low = (b = 10 * (b % s)) < (m *= 10);
                boolean bl = high = b + m > tens;
                assert (q < 10) : q;
                if (q == 0 && !high) {
                    --decExp;
                } else {
                    digits[ndigit++] = (char)(48 + q);
                }
                if (this.form != Form.COMPATIBLE || -3 >= decExp || decExp >= 8) {
                    low = false;
                    high = false;
                }
                while (!low && !high) {
                    q = b / s;
                    b = 10 * (b % s);
                    m *= 10;
                    assert (q < 10) : q;
                    if ((long)m > 0L) {
                        low = b < m;
                        high = b + m > tens;
                    } else {
                        low = true;
                        high = true;
                    }
                    digits[ndigit++] = (char)(48 + q);
                }
                lowDigitDifference = (b << 1) - tens;
            } else {
                long b = fractBits * long5pow[B5] << B2;
                long s = long5pow[S5] << S2;
                long m = long5pow[M5] << M2;
                long tens = s * 10L;
                ndigit = 0;
                int q = (int)(b / s);
                low = (b = 10L * (b % s)) < (m *= 10L);
                boolean bl = high = b + m > tens;
                assert (q < 10) : q;
                if (q == 0 && !high) {
                    --decExp;
                } else {
                    digits[ndigit++] = (char)(48 + q);
                }
                if (this.form != Form.COMPATIBLE || -3 >= decExp || decExp >= 8) {
                    low = false;
                    high = false;
                }
                while (!low && !high) {
                    q = (int)(b / s);
                    b = 10L * (b % s);
                    m *= 10L;
                    assert (q < 10) : q;
                    if (m > 0L) {
                        low = b < m;
                        high = b + m > tens;
                    } else {
                        low = true;
                        high = true;
                    }
                    digits[ndigit++] = (char)(48 + q);
                }
                lowDigitDifference = (b << 1) - tens;
            }
        } else {
            FDBigInt Bval = FormattedFloatingDecimal.multPow52(new FDBigInt(fractBits), B5, B2);
            FDBigInt Sval = FormattedFloatingDecimal.constructPow52(S5, S2);
            FDBigInt Mval = FormattedFloatingDecimal.constructPow52(M5, M2);
            int shiftBias = Sval.normalizeMe();
            Bval.lshiftMe(shiftBias);
            Mval.lshiftMe(shiftBias);
            FDBigInt tenSval = Sval.mult(10);
            ndigit = 0;
            int q = Bval.quoRemIteration(Sval);
            Mval = Mval.mult(10);
            low = Bval.cmp(Mval) < 0;
            boolean bl = high = Bval.add(Mval).cmp(tenSval) > 0;
            assert (q < 10) : q;
            if (q == 0 && !high) {
                --decExp;
            } else {
                digits[ndigit++] = (char)(48 + q);
            }
            if (this.form != Form.COMPATIBLE || -3 >= decExp || decExp >= 8) {
                low = false;
                high = false;
            }
            while (!low && !high) {
                q = Bval.quoRemIteration(Sval);
                Mval = Mval.mult(10);
                assert (q < 10) : q;
                low = Bval.cmp(Mval) < 0;
                high = Bval.add(Mval).cmp(tenSval) > 0;
                digits[ndigit++] = (char)(48 + q);
            }
            if (high && low) {
                Bval.lshiftMe(1);
                lowDigitDifference = Bval.cmp(tenSval);
            } else {
                lowDigitDifference = 0L;
            }
        }
        this.decExponent = decExp + 1;
        this.digits = digits;
        this.nDigits = ndigit;
        if (high) {
            if (low) {
                if (lowDigitDifference == 0L) {
                    if ((digits[this.nDigits - 1] & '\u0001') != 0) {
                        this.roundup();
                    }
                } else if (lowDigitDifference > 0L) {
                    this.roundup();
                }
            } else {
                this.roundup();
            }
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer(this.nDigits + 8);
        if (this.isNegative) {
            result.append('-');
        }
        if (this.isExceptional) {
            result.append(this.digits, 0, this.nDigits);
        } else {
            result.append("0.");
            result.append(this.digits, 0, this.nDigits);
            result.append('e');
            result.append(this.decExponent);
        }
        return new String(result);
    }

    public int getExponent() {
        return this.decExponent - 1;
    }

    public int getExponentRounded() {
        return this.decExponentRounded - 1;
    }

    public int getChars(char[] result) {
        assert (this.nDigits <= 19) : this.nDigits;
        int i = 0;
        if (this.isNegative) {
            result[0] = 45;
            i = 1;
        }
        if (this.isExceptional) {
            System.arraycopy(this.digits, 0, result, i, this.nDigits);
            i += this.nDigits;
        } else {
            char[] digits = this.digits;
            int exp = this.decExponent;
            switch (this.form) {
                case COMPATIBLE: {
                    break;
                }
                case DECIMAL_FLOAT: {
                    exp = this.checkExponent(this.decExponent + this.precision);
                    digits = this.applyPrecision(this.decExponent + this.precision);
                    break;
                }
                case SCIENTIFIC: {
                    exp = this.checkExponent(this.precision + 1);
                    digits = this.applyPrecision(this.precision + 1);
                    break;
                }
                case GENERAL: {
                    exp = this.checkExponent(this.precision);
                    digits = this.applyPrecision(this.precision);
                    if (exp - 1 < -4 || exp - 1 >= this.precision) {
                        this.form = Form.SCIENTIFIC;
                        --this.precision;
                        break;
                    }
                    this.form = Form.DECIMAL_FLOAT;
                    this.precision -= exp;
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            this.decExponentRounded = exp;
            if (exp > 0 && (this.form == Form.COMPATIBLE && exp < 8 || this.form == Form.DECIMAL_FLOAT)) {
                int charLength = Math.min(this.nDigits, exp);
                System.arraycopy(digits, 0, result, i, charLength);
                i += charLength;
                if (charLength < exp) {
                    charLength = exp - charLength;
                    for (int nz = 0; nz < charLength; ++nz) {
                        result[i++] = 48;
                    }
                    if (this.form == Form.COMPATIBLE) {
                        result[i++] = 46;
                        result[i++] = 48;
                    }
                } else if (this.form == Form.COMPATIBLE) {
                    result[i++] = 46;
                    if (charLength < this.nDigits) {
                        int t = Math.min(this.nDigits - charLength, this.precision);
                        System.arraycopy(digits, charLength, result, i, t);
                        i += t;
                    } else {
                        result[i++] = 48;
                    }
                } else {
                    int t = Math.min(this.nDigits - charLength, this.precision);
                    if (t > 0) {
                        result[i++] = 46;
                        System.arraycopy(digits, charLength, result, i, t);
                        i += t;
                    }
                }
            } else if (exp <= 0 && (this.form == Form.COMPATIBLE && exp > -3 || this.form == Form.DECIMAL_FLOAT)) {
                int t;
                result[i++] = 48;
                if (exp != 0 && (t = Math.min(-exp, this.precision)) > 0) {
                    result[i++] = 46;
                    for (int nz = 0; nz < t; ++nz) {
                        result[i++] = 48;
                    }
                }
                if ((t = Math.min(digits.length, this.precision + exp)) > 0) {
                    if (i == 1) {
                        result[i++] = 46;
                    }
                    System.arraycopy(digits, 0, result, i, t);
                    i += t;
                }
            } else {
                int e;
                result[i++] = digits[0];
                if (this.form == Form.COMPATIBLE) {
                    result[i++] = 46;
                    if (this.nDigits > 1) {
                        System.arraycopy(digits, 1, result, i, this.nDigits - 1);
                        i += this.nDigits - 1;
                    } else {
                        result[i++] = 48;
                    }
                    result[i++] = 69;
                } else {
                    int t;
                    if (this.nDigits > 1 && (t = Math.min(this.nDigits - 1, this.precision)) > 0) {
                        result[i++] = 46;
                        System.arraycopy(digits, 1, result, i, t);
                        i += t;
                    }
                    result[i++] = 101;
                }
                if (exp <= 0) {
                    result[i++] = 45;
                    e = -exp + 1;
                } else {
                    if (this.form != Form.COMPATIBLE) {
                        result[i++] = 43;
                    }
                    e = exp - 1;
                }
                if (e <= 9) {
                    if (this.form != Form.COMPATIBLE) {
                        result[i++] = 48;
                    }
                    result[i++] = (char)(e + 48);
                } else if (e <= 99) {
                    result[i++] = (char)(e / 10 + 48);
                    result[i++] = (char)(e % 10 + 48);
                } else {
                    result[i++] = (char)(e / 100 + 48);
                    result[i++] = (char)((e %= 100) / 10 + 48);
                    result[i++] = (char)(e % 10 + 48);
                }
            }
        }
        return i;
    }

    public strictfp double doubleValue() {
        boolean overvalue;
        double t;
        int j;
        int i;
        int kDigits = Math.min(this.nDigits, 16);
        if (this.digits == infinity || this.digits == notANumber) {
            if (this.digits == notANumber) {
                return Double.NaN;
            }
            return this.isNegative ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        }
        if (this.mustSetRoundDir) {
            this.roundDir = 0;
        }
        int iValue = this.digits[0] - 48;
        int iDigits = Math.min(kDigits, 9);
        for (i = 1; i < iDigits; ++i) {
            iValue = iValue * 10 + this.digits[i] - 48;
        }
        long lValue = iValue;
        for (i = iDigits; i < kDigits; ++i) {
            lValue = lValue * 10L + (long)(this.digits[i] - 48);
        }
        double dValue = lValue;
        int exp = this.decExponent - kDigits;
        if (this.nDigits <= 15) {
            if (exp == 0 || dValue == 0.0) {
                return this.isNegative ? -dValue : dValue;
            }
            if (exp >= 0) {
                if (exp <= maxSmallTen) {
                    double rValue = dValue * small10pow[exp];
                    if (this.mustSetRoundDir) {
                        double tValue = rValue / small10pow[exp];
                        this.roundDir = tValue == dValue ? 0 : (tValue < dValue ? 1 : -1);
                    }
                    return this.isNegative ? -rValue : rValue;
                }
                int slop = 15 - kDigits;
                if (exp <= maxSmallTen + slop) {
                    double rValue = (dValue *= small10pow[slop]) * small10pow[exp - slop];
                    if (this.mustSetRoundDir) {
                        double tValue = rValue / small10pow[exp - slop];
                        this.roundDir = tValue == dValue ? 0 : (tValue < dValue ? 1 : -1);
                    }
                    return this.isNegative ? -rValue : rValue;
                }
            } else if (exp >= -maxSmallTen) {
                double rValue = dValue / small10pow[-exp];
                double tValue = rValue * small10pow[-exp];
                if (this.mustSetRoundDir) {
                    this.roundDir = tValue == dValue ? 0 : (tValue < dValue ? 1 : -1);
                }
                return this.isNegative ? -rValue : rValue;
            }
        }
        if (exp > 0) {
            if (this.decExponent > 309) {
                return this.isNegative ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            if ((exp & 0xF) != 0) {
                dValue *= small10pow[exp & 0xF];
            }
            if ((exp >>= 4) != 0) {
                j = 0;
                while (exp > 1) {
                    if ((exp & 1) != 0) {
                        dValue *= big10pow[j];
                    }
                    ++j;
                    exp >>= 1;
                }
                t = dValue * big10pow[j];
                if (Double.isInfinite(t)) {
                    t = dValue / 2.0;
                    if (Double.isInfinite(t *= big10pow[j])) {
                        return this.isNegative ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
                    }
                    t = Double.MAX_VALUE;
                }
                dValue = t;
            }
        } else if (exp < 0) {
            exp = -exp;
            if (this.decExponent < -325) {
                return this.isNegative ? -0.0 : 0.0;
            }
            if ((exp & 0xF) != 0) {
                dValue /= small10pow[exp & 0xF];
            }
            if ((exp >>= 4) != 0) {
                j = 0;
                while (exp > 1) {
                    if ((exp & 1) != 0) {
                        dValue *= tiny10pow[j];
                    }
                    ++j;
                    exp >>= 1;
                }
                t = dValue * tiny10pow[j];
                if (t == 0.0) {
                    t = dValue * 2.0;
                    if ((t *= tiny10pow[j]) == 0.0) {
                        return this.isNegative ? -0.0 : 0.0;
                    }
                    t = Double.MIN_VALUE;
                }
                dValue = t;
            }
        }
        FDBigInt bigD0 = new FDBigInt(lValue, this.digits, kDigits, this.nDigits);
        exp = this.decExponent - this.nDigits;
        do {
            FDBigInt halfUlp;
            FDBigInt diff;
            int D2;
            int D5;
            int B2;
            int B5;
            FDBigInt bigB = this.doubleToBigInt(dValue);
            if (exp >= 0) {
                B5 = 0;
                B2 = 0;
                D2 = D5 = exp;
            } else {
                B2 = B5 = -exp;
                D5 = 0;
                D2 = 0;
            }
            if (this.bigIntExp >= 0) {
                B2 += this.bigIntExp;
            } else {
                D2 -= this.bigIntExp;
            }
            int Ulp2 = B2;
            int hulpbias = this.bigIntExp + this.bigIntNBits <= -1022 ? this.bigIntExp + 1023 + 52 : 54 - this.bigIntNBits;
            int common2 = Math.min(B2 += hulpbias, Math.min(D2 += hulpbias, Ulp2));
            Ulp2 -= common2;
            bigB = FormattedFloatingDecimal.multPow52(bigB, B5, B2 -= common2);
            FDBigInt bigD = FormattedFloatingDecimal.multPow52(new FDBigInt(bigD0), D5, D2 -= common2);
            int cmpResult = bigB.cmp(bigD);
            if (cmpResult > 0) {
                overvalue = true;
                diff = bigB.sub(bigD);
                if (this.bigIntNBits == 1 && this.bigIntExp > -1023 && --Ulp2 < 0) {
                    Ulp2 = 0;
                    diff.lshiftMe(1);
                }
            } else {
                if (cmpResult >= 0) break;
                overvalue = false;
                diff = bigD.sub(bigB);
            }
            if ((cmpResult = diff.cmp(halfUlp = FormattedFloatingDecimal.constructPow52(B5, Ulp2))) < 0) {
                if (!this.mustSetRoundDir) break;
                this.roundDir = overvalue ? -1 : 1;
                break;
            }
            if (cmpResult != 0) continue;
            dValue += 0.5 * FormattedFloatingDecimal.ulp(dValue, overvalue);
            if (!this.mustSetRoundDir) break;
            this.roundDir = overvalue ? -1 : 1;
            break;
        } while ((dValue += FormattedFloatingDecimal.ulp(dValue, overvalue)) != 0.0 && dValue != Double.POSITIVE_INFINITY);
        return this.isNegative ? -dValue : dValue;
    }

    public strictfp float floatValue() {
        int kDigits = Math.min(this.nDigits, 8);
        if (this.digits == infinity || this.digits == notANumber) {
            if (this.digits == notANumber) {
                return Float.NaN;
            }
            return this.isNegative ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY;
        }
        int iValue = this.digits[0] - 48;
        for (int i = 1; i < kDigits; ++i) {
            iValue = iValue * 10 + this.digits[i] - 48;
        }
        float fValue = iValue;
        int exp = this.decExponent - kDigits;
        if (this.nDigits <= 7) {
            if (exp == 0 || fValue == 0.0f) {
                return this.isNegative ? -fValue : fValue;
            }
            if (exp >= 0) {
                if (exp <= singleMaxSmallTen) {
                    return this.isNegative ? -fValue : (fValue *= singleSmall10pow[exp]);
                }
                int slop = 7 - kDigits;
                if (exp <= singleMaxSmallTen + slop) {
                    fValue *= singleSmall10pow[slop];
                    return this.isNegative ? -fValue : (fValue *= singleSmall10pow[exp - slop]);
                }
            } else if (exp >= -singleMaxSmallTen) {
                return this.isNegative ? -fValue : (fValue /= singleSmall10pow[-exp]);
            }
        } else if (this.decExponent >= this.nDigits && this.nDigits + this.decExponent <= 15) {
            long lValue = iValue;
            for (int i = kDigits; i < this.nDigits; ++i) {
                lValue = lValue * 10L + (long)(this.digits[i] - 48);
            }
            double dValue = lValue;
            exp = this.decExponent - this.nDigits;
            fValue = (float)(dValue *= small10pow[exp]);
            return this.isNegative ? -fValue : fValue;
        }
        if (this.decExponent > 39) {
            return this.isNegative ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY;
        }
        if (this.decExponent < -46) {
            return this.isNegative ? -0.0f : 0.0f;
        }
        this.mustSetRoundDir = !this.fromHex;
        double dValue = this.doubleValue();
        return this.stickyRound(dValue);
    }

    static {
        perThreadBuffer = new ThreadLocal(){

            protected synchronized Object initialValue() {
                return new char[26];
            }
        };
        small10pow = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16, 1.0E17, 1.0E18, 1.0E19, 1.0E20, 1.0E21, 1.0E22};
        singleSmall10pow = new float[]{1.0f, 10.0f, 100.0f, 1000.0f, 10000.0f, 100000.0f, 1000000.0f, 1.0E7f, 1.0E8f, 1.0E9f, 1.0E10f};
        big10pow = new double[]{1.0E16, 1.0E32, 1.0E64, 1.0E128, 1.0E256};
        tiny10pow = new double[]{1.0E-16, 1.0E-32, 1.0E-64, 1.0E-128, 1.0E-256};
        maxSmallTen = small10pow.length - 1;
        singleMaxSmallTen = singleSmall10pow.length - 1;
        small5pow = new int[]{1, 5, 25, 125, 625, 3125, 15625, 78125, 390625, 1953125, 9765625, 48828125, 244140625, 1220703125};
        long5pow = new long[]{1L, 5L, 25L, 125L, 625L, 3125L, 15625L, 78125L, 390625L, 1953125L, 9765625L, 48828125L, 244140625L, 1220703125L, 6103515625L, 30517578125L, 152587890625L, 762939453125L, 3814697265625L, 19073486328125L, 95367431640625L, 476837158203125L, 2384185791015625L, 11920928955078125L, 59604644775390625L, 298023223876953125L, 1490116119384765625L};
        n5bits = new int[]{0, 3, 5, 7, 10, 12, 14, 17, 19, 21, 24, 26, 28, 31, 33, 35, 38, 40, 42, 45, 47, 49, 52, 54, 56, 59, 61};
        infinity = new char[]{'I', 'n', 'f', 'i', 'n', 'i', 't', 'y'};
        notANumber = new char[]{'N', 'a', 'N'};
        zero = new char[]{'0', '0', '0', '0', '0', '0', '0', '0'};
    }

    public static enum Form {
        SCIENTIFIC,
        COMPATIBLE,
        DECIMAL_FLOAT,
        GENERAL;

    }
}

