/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.selector.ui;

import java.util.concurrent.atomic.AtomicBoolean;

abstract class WrappingSearchCursor<R> {
    private String searchTerm;
    private int majorCounter = 0;
    private int minorCounter = -1;
    private final AtomicBoolean cancelled = new AtomicBoolean(false);

    WrappingSearchCursor(String string) {
        this.searchTerm = string;
    }

    final R forward() {
        this.cancelled.set(false);
        R r = null;
        int n = this.majorCounter;
        int n2 = this.minorCounter;
        do {
            if (this.majorCounter >= this.getSlotsNumber()) {
                this.majorCounter = 0;
                this.minorCounter = -1;
                continue;
            }
            if (++this.minorCounter >= this.getSlotSize(this.majorCounter)) {
                this.minorCounter = -1;
                ++this.majorCounter;
                continue;
            }
            r = this.getItem(this.majorCounter, this.minorCounter);
            if (!this.cancelled.get()) continue;
            return null;
        } while (r == null && (n != this.majorCounter || n2 != this.minorCounter));
        return r;
    }

    final R back() {
        this.cancelled.set(false);
        R r = null;
        int n = this.majorCounter;
        int n2 = this.minorCounter;
        while (true) {
            if (--this.minorCounter < 0) {
                if (--this.majorCounter < 0) {
                    this.majorCounter = this.getSlotsNumber() - 1;
                }
                if (this.minorCounter < 0 && this.majorCounter < 0) {
                    return null;
                }
                this.minorCounter = this.getSlotSize(this.majorCounter);
                if (!this.cancelled.get()) continue;
                return null;
            }
            r = this.getItem(this.majorCounter, this.minorCounter);
            if (this.cancelled.get()) {
                return null;
            }
            if (r != null || n == this.majorCounter && n2 == this.minorCounter) break;
        }
        return r;
    }

    final void cancel() {
        this.cancelled.set(true);
    }

    protected final boolean isCancelled() {
        return this.cancelled.get();
    }

    final String getSearchTerm() {
        return this.searchTerm;
    }

    protected abstract int getSlotsNumber();

    protected abstract int getSlotSize(int var1);

    protected abstract R getItem(int var1, int var2);
}

