/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.threads;

import java.awt.Color;
import java.awt.Graphics;
import org.netbeans.lib.profiler.results.threads.ThreadData;
import org.netbeans.lib.profiler.ui.swing.renderer.BaseRenderer;
import org.netbeans.lib.profiler.ui.threads.ViewManager;

public class TimelineRenderer
extends BaseRenderer {
    private static final Color TICK_COLOR = new Color(200, 200, 200);
    private static final int BAR_MARGIN = 3;
    private static final int BAR_MARGIN_X2 = 6;
    private final ViewManager view;
    private ViewManager.RowView rowView;

    public TimelineRenderer(ViewManager viewManager) {
        this.view = viewManager;
        this.setOpaque(true);
        this.putClientProperty("ProfilerTableHover_NoHover", this);
    }

    @Override
    public void setValue(Object object, int n) {
        this.rowView = (ViewManager.RowView)object;
    }

    @Override
    public void paint(Graphics graphics) {
        int n;
        int n2;
        super.paint(graphics);
        int n3 = this.size.width;
        int n4 = this.size.height;
        long l = this.view.getFirstTimeMark(false);
        long l2 = this.view.getTimeMarksStep();
        graphics.setColor(TICK_COLOR);
        int n5 = n2 = this.view.getTimePosition(l, false);
        while (n2 < n3) {
            graphics.drawLine(n2 + this.location.x, this.location.y, n2 + this.location.x, n4 - 1 + this.location.y);
            n2 = this.view.getTimePosition(l += l2, false);
            if (n2 <= n5) break;
            n5 = n2;
        }
        if ((n = this.rowView.getLastIndex()) != -1) {
            int n6 = Math.min(this.rowView.getMaxPosition(), n3);
            while (n >= 0 && n6 >= 0) {
                n6 = this.paintState(graphics, n--, n6, n4);
            }
        }
    }

    private int paintState(Graphics graphics, int n, int n2, int n3) {
        int n4 = Math.max(0, this.rowView.getPosition(this.rowView.getTime(n)));
        Color color = ThreadData.getThreadStateColor((int)this.rowView.getState(n));
        if (color != null) {
            graphics.setColor(color);
            graphics.fillRect(n4 + this.location.x, 3 + this.location.y, n2 - n4 + 1, n3 - 6);
        }
        return n4 - 1;
    }
}

