/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.process.JavaForkOptions;
import org.gradle.process.internal.DefaultJavaForkOptions;
import org.gradle.util.GUtil;
import org.gradle.workers.WorkerConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultWorkerConfiguration
implements WorkerConfiguration {
    private final JavaForkOptions forkOptions;
    private List<File> classpath = Lists.newArrayList();
    private Serializable[] params = new Serializable[0];
    private String displayName;

    public DefaultWorkerConfiguration(FileResolver fileResolver) {
        this.forkOptions = new DefaultJavaForkOptions(fileResolver);
        this.forkOptions.workingDir((Object)new File("").getAbsoluteFile());
    }

    @Override
    public Iterable<File> getClasspath() {
        return this.classpath;
    }

    @Override
    public void setClasspath(Iterable<File> classpath) {
        this.classpath = Lists.newArrayList(classpath);
    }

    @Override
    public Serializable[] getParams() {
        return this.params;
    }

    @Override
    public void setParams(Serializable[] params) {
        this.params = params;
    }

    @Override
    public JavaForkOptions getForkOptions() {
        return this.forkOptions;
    }

    @Override
    public void classpath(Iterable<File> files) {
        GUtil.addToCollection(this.classpath, (Iterable[])new Iterable[]{files});
    }

    @Override
    public void forkOptions(Action<? super JavaForkOptions> forkOptionsAction) {
        forkOptionsAction.execute((Object)this.forkOptions);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }
}

