/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.load.java.components.JavaAnnotationMapper;
import org.jetbrains.kotlin.load.java.descriptors.JavaClassConstructorDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001c\u0010\u000b\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J\u001c\u0010\f\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J2\u0010\r\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JavaAnnotationCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "reportDeprecatedJavaAnnotation", "reportErrorsOnPositionedArguments", "reportOnValueArgument", "arguments", "", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedValueArgument;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory0;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Companion", "kotlin-compiler"})
public final class JavaAnnotationCallChecker
implements CallChecker {
    public static final Companion Companion = new Companion(null);

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkParameterIsNotNull(resolvedCall2, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(reportOn, "reportOn");
        Intrinsics.checkParameterIsNotNull(context, "context");
        CallableDescriptor resultingDescriptor = resolvedCall2.getResultingDescriptor().getOriginal();
        if (!(resultingDescriptor instanceof JavaClassConstructorDescriptor) || Intrinsics.areEqual((Object)((JavaClassConstructorDescriptor)resultingDescriptor).getContainingDeclaration().getKind(), (Object)ClassKind.ANNOTATION_CLASS) ^ true) {
            return;
        }
        this.reportErrorsOnPositionedArguments(resolvedCall2, context);
        this.reportDeprecatedJavaAnnotation(resolvedCall2, context);
    }

    private final void reportDeprecatedJavaAnnotation(ResolvedCall<?> resolvedCall2, CallCheckerContext context) {
        block6: {
            FqName fqName2;
            ClassifierDescriptor classifierDescriptor;
            KtElement ktElement = resolvedCall2.getCall().getCallElement();
            if (!(ktElement instanceof KtAnnotationEntry)) {
                ktElement = null;
            }
            KtAnnotationEntry ktAnnotationEntry = (KtAnnotationEntry)ktElement;
            if (ktAnnotationEntry == null) {
                return;
            }
            KtAnnotationEntry annotationEntry = ktAnnotationEntry;
            KotlinType kotlinType = (KotlinType)context.getTrace().get(BindingContext.TYPE, annotationEntry.getTypeReference());
            if (kotlinType == null) {
                return;
            }
            KotlinType type2 = kotlinType;
            Object object = JavaAnnotationMapper.INSTANCE.getJavaToKotlinNameMap();
            ClassifierDescriptor classifierDescriptor2 = type2.getConstructor().getDeclarationDescriptor();
            if (classifierDescriptor2 != null) {
                ClassifierDescriptor it = classifierDescriptor = classifierDescriptor2;
                fqName2 = DescriptorUtils.getFqNameSafe(it);
            } else {
                fqName2 = null;
            }
            classifierDescriptor = fqName2;
            Map<FqName, FqName> map2 = object;
            if (map2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, V>");
            }
            FqName fqName3 = map2.get(classifierDescriptor);
            if (fqName3 == null) break block6;
            object = fqName3;
            FqName it = (FqName)object;
            context.getTrace().report(ErrorsJvm.DEPRECATED_JAVA_ANNOTATION.on((KtAnnotationEntry)((PsiElement)annotationEntry), it));
        }
    }

    private final void reportErrorsOnPositionedArguments(ResolvedCall<?> resolvedCall2, CallCheckerContext context) {
        Map<ValueParameterDescriptor, ResolvedValueArgument> $receiver$iv;
        Map<ValueParameterDescriptor, ResolvedValueArgument> map2 = $receiver$iv = Companion.getJavaAnnotationCallValueArgumentsThatShouldBeNamed(resolvedCall2);
        Iterator<Map.Entry<ValueParameterDescriptor, ResolvedValueArgument>> iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> element$iv;
            Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> it = element$iv = iterator2.next();
            DiagnosticFactory0<KtExpression> diagnosticFactory0 = ErrorsJvm.POSITIONED_VALUE_ARGUMENT_FOR_JAVA_ANNOTATION;
            Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory0, "ErrorsJvm.POSITIONED_VAL\u2026UMENT_FOR_JAVA_ANNOTATION");
            this.reportOnValueArgument(context, it, diagnosticFactory0);
        }
    }

    private final void reportOnValueArgument(CallCheckerContext context, Map.Entry<? extends ValueParameterDescriptor, ? extends ResolvedValueArgument> arguments2, DiagnosticFactory0<KtExpression> diagnostic) {
        for (ValueArgument valueArgument : arguments2.getValue().getArguments()) {
            KtExpression argumentExpression;
            if (valueArgument.getArgumentExpression() == null) {
                continue;
            }
            context.getTrace().report(diagnostic.on((KtExpression)((PsiElement)argumentExpression)));
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JavaAnnotationCallChecker$Companion;", "", "()V", "getJavaAnnotationCallValueArgumentsThatShouldBeNamed", "", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedValueArgument;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "kotlin-compiler"})
    public static final class Companion {
        /*
         * Unable to fully structure code
         */
        @NotNull
        public final Map<ValueParameterDescriptor, ResolvedValueArgument> getJavaAnnotationCallValueArgumentsThatShouldBeNamed(@NotNull ResolvedCall<?> resolvedCall) {
            Intrinsics.checkParameterIsNotNull(resolvedCall, "resolvedCall");
            var3_3 = $receiver$iv = resolvedCall.getValueArguments();
            destination$iv$iv = new LinkedHashMap<K, V>();
            var5_5 = $receiver$iv$iv;
            for (Map.Entry<K, V> element$iv$iv : var5_5.entrySet()) {
                p = element$iv$iv;
                if (!(Intrinsics.areEqual(((ValueParameterDescriptor)p.getKey()).getName(), JvmAnnotationNames.DEFAULT_ANNOTATION_MEMBER_NAME) ^ true) || !(p.getValue() instanceof ExpressionValueArgument)) ** GOTO lbl-1000
                v0 = p.getValue();
                if (v0 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument");
                }
                v1 = ((ExpressionValueArgument)v0).getValueArgument();
                if (!(v1 != null ? v1.isNamed() : true)) {
                    v2 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = false;
                }
                if (!v2) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            return destination$iv$iv;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

