/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.lazy;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CharIterator;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KDeclarationContainer;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.common.collect.HashMultimap;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.KotlinLookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.platform.PlatformToKotlinClassMap;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.PlatformClassesMappedToKotlinChecker;
import org.jetbrains.kotlin.resolve.QualifiedExpressionResolver;
import org.jetbrains.kotlin.resolve.lazy.ImportResolver;
import org.jetbrains.kotlin.resolve.lazy.IndexedImports;
import org.jetbrains.kotlin.resolve.lazy.LazyImportResolver;
import org.jetbrains.kotlin.resolve.scopes.ImportingScope;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;
import org.jetbrains.kotlin.storage.MemoizedFunctionToNullable;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.util.collectionUtils.ScopeUtilsKt;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001BS\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0018H\u0002J>\u0010%\u001a\b\u0012\u0004\u0012\u0002H&0\u000f\"\b\b\u0000\u0010&*\u00020'2\u0006\u0010(\u001a\u00020)2\u001e\u0010*\u001a\u001a\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020)\u0012\n\u0012\b\u0012\u0004\u0012\u0002H&0\u000f0+J\b\u0010,\u001a\u00020#H\u0016J\u0010\u0010-\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0018H\u0016J\u000e\u0010.\u001a\u00020\u00192\u0006\u0010/\u001a\u00020\u0018J;\u00100\u001a\u0004\u0018\u0001H&\"\b\b\u0000\u0010&*\u00020'2\u0006\u0010(\u001a\u00020)2\u001a\u00101\u001a\u0016\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020)\u0012\u0006\u0012\u0004\u0018\u0001H&0+\u00a2\u0006\u0002\u00102R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/resolve/lazy/LazyImportResolver;", "Lorg/jetbrains/kotlin/resolve/lazy/ImportResolver;", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "qualifiedExpressionResolver", "Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "platformToKotlinClassMap", "Lorg/jetbrains/kotlin/platform/PlatformToKotlinClassMap;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "indexedImports", "Lorg/jetbrains/kotlin/resolve/lazy/IndexedImports;", "excludedImportNames", "", "Lorg/jetbrains/kotlin/name/FqName;", "traceForImportResolve", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "packageFragment", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentDescriptor;", "(Lorg/jetbrains/kotlin/storage/StorageManager;Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/platform/PlatformToKotlinClassMap;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/resolve/lazy/IndexedImports;Ljava/util/Collection;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/descriptors/PackageFragmentDescriptor;)V", "importedScopesProvider", "Lorg/jetbrains/kotlin/storage/MemoizedFunctionToNullable;", "Lorg/jetbrains/kotlin/psi/KtImportDirective;", "Lorg/jetbrains/kotlin/resolve/scopes/ImportingScope;", "getIndexedImports", "()Lorg/jetbrains/kotlin/resolve/lazy/IndexedImports;", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getModuleDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "getStorageManager", "()Lorg/jetbrains/kotlin/storage/StorageManager;", "checkResolvedImportDirective", "", "importDirective", "collectFromImports", "D", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "name", "Lorg/jetbrains/kotlin/name/Name;", "descriptorsSelector", "Lkotlin/Function2;", "forceResolveAllImports", "forceResolveImport", "getImportScope", "directive", "selectSingleFromImports", "descriptorSelector", "(Lorg/jetbrains/kotlin/name/Name;Lkotlin/jvm/functions/Function2;)Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "kotlin-compiler"})
public final class LazyImportResolver
implements ImportResolver {
    private final MemoizedFunctionToNullable<KtImportDirective, ImportingScope> importedScopesProvider;
    @NotNull
    private final StorageManager storageManager;
    private final QualifiedExpressionResolver qualifiedExpressionResolver;
    @NotNull
    private final ModuleDescriptor moduleDescriptor;
    private final PlatformToKotlinClassMap platformToKotlinClassMap;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final IndexedImports indexedImports;
    private final BindingTrace traceForImportResolve;
    private final PackageFragmentDescriptor packageFragment;

    @Override
    public void forceResolveAllImports() {
        HashMultimap explicitClassImports = HashMultimap.create();
        for (KtImportDirective ktImportDirective : this.indexedImports.getImports()) {
            String alias;
            this.forceResolveImport(ktImportDirective);
            ImportingScope scope = (ImportingScope)this.importedScopesProvider.invoke(ktImportDirective);
            Name name2 = KtPsiUtil.getAliasName(ktImportDirective);
            String string = alias = name2 != null ? name2.getIdentifier() : null;
            if (scope != null && alias != null) {
                Name name3 = Name.identifier(alias);
                Intrinsics.checkExpressionValueIsNotNull(name3, "Name.identifier(alias)");
                if (scope.getContributedClassifier(name3, new KotlinLookupLocation(ktImportDirective)) != null) {
                    explicitClassImports.put(alias, ktImportDirective);
                }
            }
            this.checkResolvedImportDirective(ktImportDirective);
        }
        for (Map.Entry entry : explicitClassImports.entries()) {
            boolean bl;
            KtImportDirective ktImportDirective;
            block7: {
                Object object = entry;
                String alias = (String)object.getKey();
                object = entry;
                ktImportDirective = (KtImportDirective)object.getValue();
                CharSequence $receiver$iv = alias;
                CharIterator charIterator = StringsKt.iterator($receiver$iv);
                while (charIterator.hasNext()) {
                    char element$iv = charIterator.nextChar();
                    char it = element$iv;
                    if (it == '_') continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
            if (!bl) continue;
            this.traceForImportResolve.report(Errors.UNDERSCORE_IS_RESERVED.on(ktImportDirective));
        }
        for (String string : explicitClassImports.keySet()) {
            Set imports = explicitClassImports.get(string);
            if (imports.size() <= 1) continue;
            Iterable $receiver$iv = imports;
            for (Object element$iv : $receiver$iv) {
                KtImportDirective it = (KtImportDirective)element$iv;
                this.traceForImportResolve.report(Errors.CONFLICTING_IMPORT.on((KtImportDirective)((PsiElement)it), string));
            }
        }
    }

    private final void checkResolvedImportDirective(KtImportDirective importDirective) {
        KtExpression ktExpression = importDirective.getImportedReference();
        if (ktExpression == null) {
            return;
        }
        KtSimpleNameExpression ktSimpleNameExpression = KtPsiUtil.getLastReference(ktExpression);
        if (ktSimpleNameExpression == null) {
            return;
        }
        KtSimpleNameExpression importedReference = ktSimpleNameExpression;
        DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)this.traceForImportResolve.getBindingContext().get(BindingContext.REFERENCE_TARGET, importedReference);
        if (declarationDescriptor == null) {
            return;
        }
        DeclarationDescriptor importedDescriptor = declarationDescriptor;
        String aliasName = importDirective.getAliasName();
        if (importedDescriptor instanceof FunctionDescriptor && ((FunctionDescriptor)importedDescriptor).isOperator() && aliasName != null && OperatorConventions.isConventionName(Name.identifier(aliasName))) {
            this.traceForImportResolve.report(Errors.OPERATOR_RENAMED_ON_IMPORT.on((KtSimpleNameExpression)((PsiElement)importedReference)));
        }
    }

    @Override
    public void forceResolveImport(@NotNull KtImportDirective importDirective) {
        Intrinsics.checkParameterIsNotNull(importDirective, "importDirective");
        this.getImportScope(importDirective);
    }

    @Nullable
    public final <D extends DeclarationDescriptor> D selectSingleFromImports(@NotNull Name name2, @NotNull Function2<? super ImportingScope, ? super Name, ? extends D> descriptorSelector) {
        Intrinsics.checkParameterIsNotNull(name2, "name");
        Intrinsics.checkParameterIsNotNull(descriptorSelector, "descriptorSelector");
        Function0 compute$ = new Function0<D>(this, name2, descriptorSelector){
            final /* synthetic */ LazyImportResolver this$0;
            final /* synthetic */ Name $name;
            final /* synthetic */ Function2 $descriptorSelector;

            @Nullable
            public final D invoke() {
                Collection<KtImportDirective> imports = this.this$0.getIndexedImports().importsForName(this.$name);
                DeclarationDescriptor target = null;
                for (KtImportDirective directive : imports) {
                    DeclarationDescriptor resolved;
                    if ((DeclarationDescriptor)this.$descriptorSelector.invoke(this.this$0.getImportScope(directive), this.$name) == null) {
                        continue;
                    }
                    if (target != null && Intrinsics.areEqual(target, resolved) ^ true) {
                        return null;
                    }
                    target = resolved;
                }
                return (D)target;
            }
            {
                this.this$0 = lazyImportResolver;
                this.$name = name2;
                this.$descriptorSelector = function2;
                super(0);
            }
        };
        return (D)((DeclarationDescriptor)this.storageManager.compute(new Function0<D>(compute$){
            final /* synthetic */ selectSingleFromImports.1 $compute;

            @Nullable
            public final D invoke() {
                return (D)this.$compute.invoke();
            }

            public final KDeclarationContainer getOwner() {
                return null;
            }

            public final String getName() {
                return "compute";
            }

            public final String getSignature() {
                return "invoke()Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;";
            }
            {
                this.$compute = var1_1;
                super(0);
            }
        }));
    }

    @NotNull
    public final <D extends DeclarationDescriptor> Collection<D> collectFromImports(@NotNull Name name2, @NotNull Function2<? super ImportingScope, ? super Name, ? extends Collection<? extends D>> descriptorsSelector) {
        Intrinsics.checkParameterIsNotNull(name2, "name");
        Intrinsics.checkParameterIsNotNull(descriptorsSelector, "descriptorsSelector");
        return (Collection)this.storageManager.compute(new Function0<Collection<? extends D>>(this, name2, descriptorsSelector){
            final /* synthetic */ LazyImportResolver this$0;
            final /* synthetic */ Name $name;
            final /* synthetic */ Function2 $descriptorsSelector;

            @NotNull
            public final Collection<D> invoke() {
                Collection<T> descriptors = null;
                for (KtImportDirective directive : this.this$0.getIndexedImports().importsForName(this.$name)) {
                    Collection descriptorsForImport = (Collection)this.$descriptorsSelector.invoke(this.this$0.getImportScope(directive), this.$name);
                    descriptors = ScopeUtilsKt.concat(descriptors, descriptorsForImport);
                }
                Collection<T> collection = descriptors;
                if (collection == null) {
                    collection = SetsKt.emptySet();
                }
                return collection;
            }
            {
                this.this$0 = lazyImportResolver;
                this.$name = name2;
                this.$descriptorsSelector = function2;
                super(0);
            }
        });
    }

    @NotNull
    public final ImportingScope getImportScope(@NotNull KtImportDirective directive) {
        Intrinsics.checkParameterIsNotNull(directive, "directive");
        ImportingScope importingScope = (ImportingScope)this.importedScopesProvider.invoke(directive);
        if (importingScope == null) {
            importingScope = ImportingScope.Empty.INSTANCE;
        }
        return importingScope;
    }

    @NotNull
    public final StorageManager getStorageManager() {
        return this.storageManager;
    }

    @NotNull
    public final ModuleDescriptor getModuleDescriptor() {
        return this.moduleDescriptor;
    }

    @NotNull
    public final LanguageVersionSettings getLanguageVersionSettings() {
        return this.languageVersionSettings;
    }

    @NotNull
    public final IndexedImports getIndexedImports() {
        return this.indexedImports;
    }

    public LazyImportResolver(@NotNull StorageManager storageManager, @NotNull QualifiedExpressionResolver qualifiedExpressionResolver, @NotNull ModuleDescriptor moduleDescriptor, @NotNull PlatformToKotlinClassMap platformToKotlinClassMap, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull IndexedImports indexedImports, @NotNull Collection<FqName> excludedImportNames, @NotNull BindingTrace traceForImportResolve, @NotNull PackageFragmentDescriptor packageFragment) {
        Intrinsics.checkParameterIsNotNull(storageManager, "storageManager");
        Intrinsics.checkParameterIsNotNull(qualifiedExpressionResolver, "qualifiedExpressionResolver");
        Intrinsics.checkParameterIsNotNull(moduleDescriptor, "moduleDescriptor");
        Intrinsics.checkParameterIsNotNull(platformToKotlinClassMap, "platformToKotlinClassMap");
        Intrinsics.checkParameterIsNotNull(languageVersionSettings, "languageVersionSettings");
        Intrinsics.checkParameterIsNotNull(indexedImports, "indexedImports");
        Intrinsics.checkParameterIsNotNull(excludedImportNames, "excludedImportNames");
        Intrinsics.checkParameterIsNotNull(traceForImportResolve, "traceForImportResolve");
        Intrinsics.checkParameterIsNotNull(packageFragment, "packageFragment");
        this.storageManager = storageManager;
        this.qualifiedExpressionResolver = qualifiedExpressionResolver;
        this.moduleDescriptor = moduleDescriptor;
        this.platformToKotlinClassMap = platformToKotlinClassMap;
        this.languageVersionSettings = languageVersionSettings;
        this.indexedImports = indexedImports;
        this.traceForImportResolve = traceForImportResolve;
        this.packageFragment = packageFragment;
        this.importedScopesProvider = this.storageManager.createMemoizedFunctionWithNullableValues((Function1)new Function1<KtImportDirective, ImportingScope>(this, excludedImportNames){
            final /* synthetic */ LazyImportResolver this$0;
            final /* synthetic */ Collection $excludedImportNames;

            @Nullable
            public final ImportingScope invoke(@NotNull KtImportDirective directive) {
                ImportingScope importingScope;
                Intrinsics.checkParameterIsNotNull(directive, "directive");
                ImportingScope importingScope2 = LazyImportResolver.access$getQualifiedExpressionResolver$p(this.this$0).processImportReference(directive, this.this$0.getModuleDescriptor(), LazyImportResolver.access$getTraceForImportResolve$p(this.this$0), this.$excludedImportNames, LazyImportResolver.access$getPackageFragment$p(this.this$0));
                if (importingScope2 != null) {
                    ImportingScope importingScope3;
                    ImportingScope $receiver = importingScope3 = importingScope2;
                    if (!directive.isAllUnder()) {
                        PlatformClassesMappedToKotlinChecker.checkPlatformClassesMappedToKotlin(LazyImportResolver.access$getPlatformToKotlinClassMap$p(this.this$0), LazyImportResolver.access$getTraceForImportResolve$p(this.this$0), directive, ResolutionScope.DefaultImpls.getContributedDescriptors$default($receiver, null, null, 3, null));
                    }
                    importingScope = importingScope3;
                } else {
                    importingScope = null;
                }
                return importingScope;
            }
            {
                this.this$0 = lazyImportResolver;
                this.$excludedImportNames = collection;
                super(1);
            }
        });
    }

    @NotNull
    public static final /* synthetic */ QualifiedExpressionResolver access$getQualifiedExpressionResolver$p(LazyImportResolver $this) {
        return $this.qualifiedExpressionResolver;
    }

    @NotNull
    public static final /* synthetic */ BindingTrace access$getTraceForImportResolve$p(LazyImportResolver $this) {
        return $this.traceForImportResolve;
    }

    @NotNull
    public static final /* synthetic */ PackageFragmentDescriptor access$getPackageFragment$p(LazyImportResolver $this) {
        return $this.packageFragment;
    }

    @NotNull
    public static final /* synthetic */ PlatformToKotlinClassMap access$getPlatformToKotlinClassMap$p(LazyImportResolver $this) {
        return $this.platformToKotlinClassMap;
    }
}

