/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.nativeintegration.services;

import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import net.rubygrapefruit.platform.Files;
import net.rubygrapefruit.platform.Memory;
import net.rubygrapefruit.platform.Native;
import net.rubygrapefruit.platform.NativeException;
import net.rubygrapefruit.platform.PosixFiles;
import net.rubygrapefruit.platform.Process;
import net.rubygrapefruit.platform.ProcessLauncher;
import net.rubygrapefruit.platform.SystemInfo;
import net.rubygrapefruit.platform.Terminals;
import net.rubygrapefruit.platform.WindowsRegistry;
import net.rubygrapefruit.platform.internal.DefaultProcessLauncher;
import org.gradle.api.JavaVersion;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.nativeintegration.NativeIntegrationUnavailableException;
import org.gradle.internal.nativeintegration.ProcessEnvironment;
import org.gradle.internal.nativeintegration.console.ConsoleDetector;
import org.gradle.internal.nativeintegration.console.NativePlatformConsoleDetector;
import org.gradle.internal.nativeintegration.console.NoOpConsoleDetector;
import org.gradle.internal.nativeintegration.console.WindowsConsoleDetector;
import org.gradle.internal.nativeintegration.filesystem.FileMetadataAccessor;
import org.gradle.internal.nativeintegration.filesystem.services.FallbackFileMetadataAccessor;
import org.gradle.internal.nativeintegration.filesystem.services.FileSystemServices;
import org.gradle.internal.nativeintegration.filesystem.services.NativePlatformBackedFileMetadataAccessor;
import org.gradle.internal.nativeintegration.filesystem.services.UnavailablePosixFiles;
import org.gradle.internal.nativeintegration.jansi.JansiBootPathConfigurer;
import org.gradle.internal.nativeintegration.jna.UnsupportedEnvironment;
import org.gradle.internal.nativeintegration.processenvironment.NativePlatformBackedProcessEnvironment;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.internal.service.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeServices
extends DefaultServiceRegistry
implements ServiceRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(NativeServices.class);
    private static boolean useNativeIntegrations = "true".equalsIgnoreCase(System.getProperty("org.gradle.native", "true"));
    private static final NativeServices INSTANCE = new NativeServices();
    private static final JansiBootPathConfigurer JANSI_BOOT_PATH_CONFIGURER = new JansiBootPathConfigurer();
    private static boolean initialized;
    public static final String NATIVE_DIR_OVERRIDE = "org.gradle.native.dir";

    public static void initialize(File userHomeDir) {
        NativeServices.initialize(userHomeDir, true);
    }

    public static synchronized void initialize(File userHomeDir, boolean initializeJansi) {
        if (!initialized) {
            if (useNativeIntegrations) {
                File nativeBaseDir = NativeServices.getNativeServicesDir(userHomeDir);
                try {
                    Native.init((File)nativeBaseDir);
                }
                catch (net.rubygrapefruit.platform.NativeIntegrationUnavailableException ex) {
                    LOGGER.debug("Native-platform is not available.");
                    useNativeIntegrations = false;
                }
                catch (NativeException ex) {
                    if (ex.getCause() instanceof UnsatisfiedLinkError && ex.getCause().getMessage().toLowerCase().contains("already loaded in another classloader")) {
                        LOGGER.debug("Unable to initialize native-platform. Failure: {}", (Object)NativeServices.format(ex));
                        useNativeIntegrations = false;
                    }
                    if (ex.getMessage().equals("Could not extract native JNI library.") && ex.getCause().getMessage().contains("native-platform.dll (The process cannot access the file because it is being used by another process)")) {
                        LOGGER.debug("Unable to initialize native-platform. Failure: {}", (Object)NativeServices.format(ex));
                        useNativeIntegrations = false;
                    }
                    throw ex;
                }
                if (initializeJansi) {
                    JANSI_BOOT_PATH_CONFIGURER.configure(nativeBaseDir);
                }
                LOGGER.info("Initialized native services in: " + nativeBaseDir);
            }
            initialized = true;
        }
    }

    public static File getNativeServicesDir(File userHomeDir) {
        String overrideProperty = NativeServices.getNativeDirOverride();
        if (overrideProperty == null) {
            return new File(userHomeDir, "native");
        }
        return new File(overrideProperty);
    }

    private static String getNativeDirOverride() {
        return System.getProperty(NATIVE_DIR_OVERRIDE, System.getenv(NATIVE_DIR_OVERRIDE));
    }

    public static synchronized NativeServices getInstance() {
        if (!initialized) {
            throw new IllegalStateException("Cannot get an instance of NativeServices without first calling initialize().");
        }
        return INSTANCE;
    }

    private NativeServices() {
        this.addProvider(new FileSystemServices());
    }

    public void close() {
    }

    protected OperatingSystem createOperatingSystem() {
        return OperatingSystem.current();
    }

    protected Jvm createJvm() {
        return Jvm.current();
    }

    protected ProcessEnvironment createProcessEnvironment(OperatingSystem operatingSystem) {
        if (useNativeIntegrations) {
            try {
                Process process = (Process)Native.get(Process.class);
                return new NativePlatformBackedProcessEnvironment(process);
            }
            catch (net.rubygrapefruit.platform.NativeIntegrationUnavailableException ex) {
                LOGGER.debug("Native-platform process integration is not available. Continuing with fallback.");
            }
        }
        return new UnsupportedEnvironment();
    }

    protected ConsoleDetector createConsoleDetector(OperatingSystem operatingSystem) {
        if (useNativeIntegrations) {
            try {
                Terminals terminals = (Terminals)Native.get(Terminals.class);
                return new NativePlatformConsoleDetector(terminals);
            }
            catch (net.rubygrapefruit.platform.NativeIntegrationUnavailableException ex) {
                LOGGER.debug("Native-platform terminal integration is not available. Continuing with fallback.");
            }
            catch (NativeException ex) {
                LOGGER.debug("Unable to load from native-platform backed ConsoleDetector. Continuing with fallback. Failure: {}", (Object)NativeServices.format(ex));
            }
            try {
                if (operatingSystem.isWindows()) {
                    return new WindowsConsoleDetector();
                }
            }
            catch (LinkageError e) {
                LOGGER.debug("Unable to load native library. Continuing with fallback. Failure: {}", (Object)NativeServices.format(e));
            }
        }
        return new NoOpConsoleDetector();
    }

    protected WindowsRegistry createWindowsRegistry(OperatingSystem operatingSystem) {
        if (useNativeIntegrations && operatingSystem.isWindows()) {
            return (WindowsRegistry)Native.get(WindowsRegistry.class);
        }
        return this.notAvailable(WindowsRegistry.class);
    }

    protected SystemInfo createSystemInfo() {
        if (useNativeIntegrations) {
            try {
                return (SystemInfo)Native.get(SystemInfo.class);
            }
            catch (net.rubygrapefruit.platform.NativeIntegrationUnavailableException e) {
                LOGGER.debug("Native-platform system info is not available. Continuing with fallback.");
            }
        }
        return this.notAvailable(SystemInfo.class);
    }

    protected Memory createMemory() {
        if (useNativeIntegrations) {
            try {
                return (Memory)Native.get(Memory.class);
            }
            catch (net.rubygrapefruit.platform.NativeIntegrationUnavailableException e) {
                LOGGER.debug("Native-platform memory integration is not available. Continuing with fallback.");
            }
        }
        return this.notAvailable(Memory.class);
    }

    protected ProcessLauncher createProcessLauncher() {
        if (useNativeIntegrations) {
            try {
                return (ProcessLauncher)Native.get(ProcessLauncher.class);
            }
            catch (net.rubygrapefruit.platform.NativeIntegrationUnavailableException e) {
                LOGGER.debug("Native-platform process launcher is not available. Continuing with fallback.");
            }
        }
        return new DefaultProcessLauncher();
    }

    protected PosixFiles createPosixFiles() {
        if (useNativeIntegrations) {
            try {
                return (PosixFiles)Native.get(PosixFiles.class);
            }
            catch (net.rubygrapefruit.platform.NativeIntegrationUnavailableException e) {
                LOGGER.debug("Native-platform posix files integration is not available. Continuing with fallback.");
            }
        }
        return this.notAvailable(UnavailablePosixFiles.class);
    }

    protected FileMetadataAccessor createFileMetadataAccessor(OperatingSystem operatingSystem) {
        if (operatingSystem.isMacOsX() && useNativeIntegrations) {
            try {
                return new NativePlatformBackedFileMetadataAccessor((Files)Native.get(Files.class));
            }
            catch (net.rubygrapefruit.platform.NativeIntegrationUnavailableException e) {
                LOGGER.debug("Native-platform files integration is not available. Continuing with fallback.");
            }
        }
        if (JavaVersion.current().isJava7Compatible()) {
            return (FileMetadataAccessor)JavaReflectionUtil.newInstanceOrFallback((String)"org.gradle.internal.nativeintegration.filesystem.jdk7.Jdk7FileMetadataAccessor", (ClassLoader)NativeServices.class.getClassLoader(), FallbackFileMetadataAccessor.class);
        }
        return new FallbackFileMetadataAccessor();
    }

    private <T> T notAvailable(Class<T> type) {
        return (T)Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, (InvocationHandler)new BrokenService(type.getSimpleName()));
    }

    private static String format(Throwable throwable) {
        StringBuilder builder = new StringBuilder();
        builder.append(throwable.toString());
        for (Throwable current = throwable.getCause(); current != null; current = current.getCause()) {
            builder.append(SystemProperties.getInstance().getLineSeparator());
            builder.append("caused by: ");
            builder.append(current.toString());
        }
        return builder.toString();
    }

    private static class BrokenService
    implements InvocationHandler {
        private final String type;

        private BrokenService(String type) {
            this.type = type;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            throw new NativeIntegrationUnavailableException(String.format("%s is not supported on this operating system.", this.type));
        }
    }
}

