/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Nullable;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ConfigurationPublications;
import org.gradle.api.artifacts.ConfigurationVariant;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.attributes.AttributeMatchingStrategy;
import org.gradle.api.attributes.MultipleCandidatesDetails;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.artifacts.ArtifactAttributes;
import org.gradle.api.internal.artifacts.publish.AbstractPublishArtifact;
import org.gradle.api.internal.artifacts.publish.ArchivePublishArtifact;
import org.gradle.api.internal.component.BuildableJavaComponent;
import org.gradle.api.internal.component.ComponentRegistry;
import org.gradle.api.internal.java.JavaLibrary;
import org.gradle.api.internal.plugins.DefaultArtifactPublicationSet;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.api.tasks.testing.Test;
import org.gradle.internal.cleanup.BuildOutputCleanupRegistry;
import org.gradle.language.jvm.tasks.ProcessResources;

public class JavaPlugin
implements Plugin<ProjectInternal> {
    public static final String PROCESS_RESOURCES_TASK_NAME = "processResources";
    public static final String CLASSES_TASK_NAME = "classes";
    public static final String COMPILE_JAVA_TASK_NAME = "compileJava";
    public static final String PROCESS_TEST_RESOURCES_TASK_NAME = "processTestResources";
    public static final String TEST_CLASSES_TASK_NAME = "testClasses";
    public static final String COMPILE_TEST_JAVA_TASK_NAME = "compileTestJava";
    public static final String TEST_TASK_NAME = "test";
    public static final String JAR_TASK_NAME = "jar";
    public static final String JAVADOC_TASK_NAME = "javadoc";
    @Incubating
    public static final String API_CONFIGURATION_NAME = "api";
    @Incubating
    public static final String IMPLEMENTATION_CONFIGURATION_NAME = "implementation";
    @Incubating
    public static final String API_ELEMENTS_CONFIGURATION_NAME = "apiElements";
    public static final String COMPILE_CONFIGURATION_NAME = "compile";
    public static final String COMPILE_ONLY_CONFIGURATION_NAME = "compileOnly";
    public static final String RUNTIME_CONFIGURATION_NAME = "runtime";
    @Incubating
    public static final String RUNTIME_ONLY_CONFIGURATION_NAME = "runtimeOnly";
    @Incubating
    public static final String RUNTIME_CLASSPATH_CONFIGURATION_NAME = "runtimeClasspath";
    @Incubating
    public static final String RUNTIME_ELEMENTS_CONFIGURATION_NAME = "runtimeElements";
    @Incubating
    public static final String COMPILE_CLASSPATH_CONFIGURATION_NAME = "compileClasspath";
    public static final String TEST_COMPILE_CONFIGURATION_NAME = "testCompile";
    @Incubating
    public static final String TEST_IMPLEMENTATION_CONFIGURATION_NAME = "testImplementation";
    public static final String TEST_COMPILE_ONLY_CONFIGURATION_NAME = "testCompileOnly";
    public static final String TEST_RUNTIME_CONFIGURATION_NAME = "testRuntime";
    @Incubating
    public static final String TEST_RUNTIME_ONLY_CONFIGURATION_NAME = "testRuntimeOnly";
    @Incubating
    public static final String TEST_COMPILE_CLASSPATH_CONFIGURATION_NAME = "testCompileClasspath";
    @Incubating
    public static final String TEST_RUNTIME_CLASSPATH_CONFIGURATION_NAME = "testRuntimeClasspath";
    @Incubating
    public static final String CLASS_DIRECTORY = "org.gradle.java.classes.directory";
    @Incubating
    public static final String RESOURCES_DIRECTORY = "org.gradle.java.resources.directory";
    @Incubating
    public static final String JAR_TYPE = "jar";
    static final String NON_DEFAULT_JAR_TYPE = "org.gradle.java.implicit";
    private static final Set<String> VARIANT_TYPES = ImmutableSet.of((Object)"jar", (Object)"org.gradle.java.classes.directory", (Object)"org.gradle.java.resources.directory");
    private static final Set<String> DIR_VARIANT_TYPES = ImmutableSet.of((Object)"org.gradle.java.implicit", (Object)"org.gradle.java.classes.directory", (Object)"org.gradle.java.resources.directory");

    public void apply(ProjectInternal project) {
        project.getPluginManager().apply(JavaBasePlugin.class);
        JavaPluginConvention javaConvention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
        ((ComponentRegistry)project.getServices().get(ComponentRegistry.class)).setMainComponent((BuildableJavaComponent)new BuildableJavaComponentImpl(javaConvention));
        BuildOutputCleanupRegistry buildOutputCleanupRegistry = (BuildOutputCleanupRegistry)project.getServices().get(BuildOutputCleanupRegistry.class);
        this.configureSourceSets(javaConvention, buildOutputCleanupRegistry);
        this.configureCompatibilityRules(project);
        this.configureConfigurations((Project)project);
        this.configureJavaDoc(javaConvention);
        this.configureTest((Project)project, javaConvention);
        this.configureArchivesAndComponent((Project)project, javaConvention);
        this.configureBuild((Project)project);
    }

    private void configureCompatibilityRules(ProjectInternal project) {
        AttributeMatchingStrategy matchingStrategy = project.getDependencies().getAttributesSchema().getMatchingStrategy(ArtifactAttributes.ARTIFACT_FORMAT);
        matchingStrategy.getDisambiguationRules().add((Action)new Action<MultipleCandidatesDetails<String>>(){

            public void execute(MultipleCandidatesDetails<String> details) {
                if (details.getCandidateValues().equals(VARIANT_TYPES)) {
                    details.closestMatch((Object)"jar");
                    return;
                }
                if (details.getCandidateValues().equals(DIR_VARIANT_TYPES)) {
                    details.closestMatch((Object)JavaPlugin.CLASS_DIRECTORY);
                }
            }
        });
    }

    private void configureSourceSets(JavaPluginConvention pluginConvention, final BuildOutputCleanupRegistry buildOutputCleanupRegistry) {
        ProjectInternal project = pluginConvention.getProject();
        SourceSet main = (SourceSet)pluginConvention.getSourceSets().create("main");
        SourceSet test = (SourceSet)pluginConvention.getSourceSets().create(TEST_TASK_NAME);
        test.setCompileClasspath((FileCollection)project.files(new Object[]{main.getOutput(), project.getConfigurations().getByName(TEST_COMPILE_CLASSPATH_CONFIGURATION_NAME)}));
        test.setRuntimeClasspath((FileCollection)project.files(new Object[]{test.getOutput(), main.getOutput(), project.getConfigurations().getByName(TEST_RUNTIME_CLASSPATH_CONFIGURATION_NAME)}));
        pluginConvention.getSourceSets().all((Action)new Action<SourceSet>(){

            public void execute(SourceSet sourceSet) {
                buildOutputCleanupRegistry.registerOutputs((Object)sourceSet.getOutput());
            }
        });
    }

    private void configureJavaDoc(JavaPluginConvention pluginConvention) {
        ProjectInternal project = pluginConvention.getProject();
        SourceSet mainSourceSet = (SourceSet)pluginConvention.getSourceSets().getByName("main");
        Javadoc javadoc = (Javadoc)project.getTasks().create(JAVADOC_TASK_NAME, Javadoc.class);
        javadoc.setDescription("Generates Javadoc API documentation for the main source code.");
        javadoc.setGroup("documentation");
        javadoc.setClasspath(mainSourceSet.getOutput().plus(mainSourceSet.getCompileClasspath()));
        javadoc.setSource((Object)mainSourceSet.getAllJava());
        this.addDependsOnTaskInOtherProjects((Task)javadoc, true, JAVADOC_TASK_NAME, COMPILE_CONFIGURATION_NAME);
    }

    private void configureArchivesAndComponent(Project project, JavaPluginConvention pluginConvention) {
        Jar jar = (Jar)project.getTasks().create("jar", Jar.class);
        jar.setDescription("Assembles a jar archive containing the main classes.");
        jar.setGroup("build");
        jar.from(new Object[]{((SourceSet)pluginConvention.getSourceSets().getByName("main")).getOutput()});
        ArchivePublishArtifact jarArtifact = new ArchivePublishArtifact((AbstractArchiveTask)jar);
        Configuration apiElementConfiguration = project.getConfigurations().getByName(API_ELEMENTS_CONFIGURATION_NAME);
        Configuration runtimeConfiguration = project.getConfigurations().getByName(RUNTIME_CONFIGURATION_NAME);
        Configuration runtimeElementsConfiguration = project.getConfigurations().getByName(RUNTIME_ELEMENTS_CONFIGURATION_NAME);
        ((DefaultArtifactPublicationSet)project.getExtensions().getByType(DefaultArtifactPublicationSet.class)).addCandidate((PublishArtifact)jarArtifact);
        JavaCompile javaCompile = (JavaCompile)project.getTasks().getByPath(COMPILE_JAVA_TASK_NAME);
        ProcessResources processResources = (ProcessResources)project.getTasks().getByPath(PROCESS_RESOURCES_TASK_NAME);
        this.addVariants(apiElementConfiguration, jarArtifact, javaCompile, processResources);
        this.addVariants(runtimeConfiguration, jarArtifact, javaCompile, processResources);
        this.addVariants(runtimeElementsConfiguration, jarArtifact, javaCompile, processResources);
        project.getComponents().add((Object)new JavaLibrary(project.getConfigurations(), new PublishArtifact[]{jarArtifact}));
    }

    private void addVariants(Configuration configuration, ArchivePublishArtifact jarArtifact, final JavaCompile javaCompile, final ProcessResources processResources) {
        ConfigurationPublications publications = configuration.getOutgoing();
        publications.getArtifacts().add((Object)jarArtifact);
        publications.getAttributes().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)"jar");
        NamedDomainObjectContainer runtimeVariants = publications.getVariants();
        this.createVariant((NamedDomainObjectContainer<ConfigurationVariant>)runtimeVariants, CLASSES_TASK_NAME, CLASS_DIRECTORY, (PublishArtifact)new IntermediateJavaArtifact(CLASS_DIRECTORY, (Task)javaCompile){

            public File getFile() {
                return javaCompile.getDestinationDir();
            }
        });
        this.createVariant((NamedDomainObjectContainer<ConfigurationVariant>)runtimeVariants, "resources", RESOURCES_DIRECTORY, (PublishArtifact)new IntermediateJavaArtifact(RESOURCES_DIRECTORY, (Task)processResources){

            public File getFile() {
                return processResources.getDestinationDir();
            }
        });
    }

    private void createVariant(NamedDomainObjectContainer<ConfigurationVariant> variants, String name, String artifactType, PublishArtifact artifact) {
        ConfigurationVariant variant = (ConfigurationVariant)variants.create(name);
        variant.getAttributes().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)artifactType);
        variant.artifact((Object)artifact);
    }

    private void configureBuild(Project project) {
        this.addDependsOnTaskInOtherProjects(project.getTasks().getByName("buildNeeded"), true, "buildNeeded", TEST_RUNTIME_CONFIGURATION_NAME);
        this.addDependsOnTaskInOtherProjects(project.getTasks().getByName("buildDependents"), false, "buildDependents", TEST_RUNTIME_CONFIGURATION_NAME);
    }

    private void configureTest(Project project, final JavaPluginConvention pluginConvention) {
        project.getTasks().withType(Test.class, (Action)new Action<Test>(){

            public void execute(Test test) {
                test.getConventionMapping().map("testClassesDir", (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return ((SourceSet)pluginConvention.getSourceSets().getByName(JavaPlugin.TEST_TASK_NAME)).getOutput().getClassesDir();
                    }
                });
                test.getConventionMapping().map("classpath", (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return ((SourceSet)pluginConvention.getSourceSets().getByName(JavaPlugin.TEST_TASK_NAME)).getRuntimeClasspath();
                    }
                });
            }
        });
        Test test = (Test)project.getTasks().create(TEST_TASK_NAME, Test.class);
        project.getTasks().getByName("check").dependsOn(new Object[]{test});
        test.setDescription("Runs the unit tests.");
        test.setGroup("verification");
    }

    private void configureConfigurations(Project project) {
        ConfigurationContainer configurations = project.getConfigurations();
        Configuration defaultConfiguration = configurations.getByName("default");
        Configuration compileConfiguration = configurations.getByName(COMPILE_CONFIGURATION_NAME);
        Configuration implementationConfiguration = configurations.getByName(IMPLEMENTATION_CONFIGURATION_NAME);
        Configuration runtimeConfiguration = configurations.getByName(RUNTIME_CONFIGURATION_NAME);
        Configuration runtimeOnlyConfiguration = configurations.getByName(RUNTIME_ONLY_CONFIGURATION_NAME);
        Configuration compileTestsConfiguration = configurations.getByName(TEST_COMPILE_CONFIGURATION_NAME);
        Configuration testImplementationConfiguration = configurations.getByName(TEST_IMPLEMENTATION_CONFIGURATION_NAME);
        Configuration testRuntimeConfiguration = configurations.getByName(TEST_RUNTIME_CONFIGURATION_NAME);
        Configuration testRuntimeOnlyConfiguration = configurations.getByName(TEST_RUNTIME_ONLY_CONFIGURATION_NAME);
        compileTestsConfiguration.extendsFrom(new Configuration[]{compileConfiguration});
        testImplementationConfiguration.extendsFrom(new Configuration[]{implementationConfiguration});
        testRuntimeConfiguration.extendsFrom(new Configuration[]{runtimeConfiguration});
        testRuntimeOnlyConfiguration.extendsFrom(new Configuration[]{runtimeOnlyConfiguration});
        Configuration apiElementsConfiguration = (Configuration)configurations.maybeCreate(API_ELEMENTS_CONFIGURATION_NAME);
        apiElementsConfiguration.setVisible(false);
        apiElementsConfiguration.setDescription("API elements for main.");
        apiElementsConfiguration.setCanBeResolved(false);
        apiElementsConfiguration.setCanBeConsumed(true);
        apiElementsConfiguration.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)Usage.FOR_COMPILE);
        apiElementsConfiguration.extendsFrom(new Configuration[]{compileConfiguration, runtimeConfiguration});
        Configuration runtimeElementsConfiguration = (Configuration)configurations.maybeCreate(RUNTIME_ELEMENTS_CONFIGURATION_NAME);
        runtimeElementsConfiguration.setVisible(false);
        runtimeElementsConfiguration.setCanBeConsumed(true);
        runtimeElementsConfiguration.setCanBeResolved(false);
        runtimeElementsConfiguration.setDescription("Elements of runtime for main.");
        runtimeElementsConfiguration.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)Usage.FOR_RUNTIME);
        runtimeElementsConfiguration.extendsFrom(new Configuration[]{implementationConfiguration, runtimeOnlyConfiguration, runtimeConfiguration});
        defaultConfiguration.extendsFrom(new Configuration[]{runtimeElementsConfiguration});
    }

    private void addDependsOnTaskInOtherProjects(Task task, boolean useDependedOn, String otherProjectTaskName, String configurationName) {
        Project project = task.getProject();
        Configuration configuration = project.getConfigurations().getByName(configurationName);
        task.dependsOn(new Object[]{configuration.getTaskDependencyFromProjectDependency(useDependedOn, otherProjectTaskName)});
    }

    private static abstract class IntermediateJavaArtifact
    extends AbstractPublishArtifact {
        private final String type;

        IntermediateJavaArtifact(String type, Task task) {
            super(new Object[]{task});
            this.type = type;
        }

        public String getName() {
            return this.getFile().getName();
        }

        public String getExtension() {
            return "";
        }

        public String getType() {
            return this.type;
        }

        @Nullable
        public String getClassifier() {
            return null;
        }

        public Date getDate() {
            return null;
        }
    }

    private static class BuildableJavaComponentImpl
    implements BuildableJavaComponent {
        private final JavaPluginConvention convention;

        public BuildableJavaComponentImpl(JavaPluginConvention convention) {
            this.convention = convention;
        }

        public Collection<String> getRebuildTasks() {
            return Arrays.asList("clean", "build");
        }

        public Collection<String> getBuildTasks() {
            return Arrays.asList("build");
        }

        public FileCollection getRuntimeClasspath() {
            ProjectInternal project = this.convention.getProject();
            SourceSet mainSourceSet = (SourceSet)this.convention.getSourceSets().getByName("main");
            FileCollection runtimeClasspath = mainSourceSet.getRuntimeClasspath();
            Configuration gradleApi = project.getConfigurations().detachedConfiguration(new Dependency[]{project.getDependencies().gradleApi(), project.getDependencies().localGroovy()});
            Configuration runtimeElements = project.getConfigurations().getByName(mainSourceSet.getRuntimeElementsConfigurationName());
            FileCollection mainSourceSetArtifact = runtimeElements.getOutgoing().getArtifacts().getFiles();
            return mainSourceSetArtifact.plus(runtimeClasspath.minus((FileCollection)mainSourceSet.getOutput()).minus((FileCollection)gradleApi));
        }

        public Configuration getCompileDependencies() {
            return this.convention.getProject().getConfigurations().getByName(JavaPlugin.COMPILE_CONFIGURATION_NAME);
        }
    }
}

