/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve;

import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepositoryAccess;
import org.gradle.api.internal.component.ArtifactType;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentOverrideMetadata;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.ModuleSource;
import org.gradle.internal.resolve.ArtifactResolveException;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.resolve.result.BuildableArtifactResolveResult;
import org.gradle.internal.resolve.result.BuildableArtifactSetResolveResult;
import org.gradle.internal.resolve.result.BuildableComponentArtifactsResolveResult;
import org.gradle.internal.resolve.result.BuildableModuleComponentMetaDataResolveResult;
import org.gradle.internal.resolve.result.BuildableModuleVersionListingResolveResult;

public class ErrorHandlingModuleComponentRepository
implements ModuleComponentRepository {
    private final ModuleComponentRepository delegate;
    private final ErrorHandlingModuleComponentRepositoryAccess local;
    private final ErrorHandlingModuleComponentRepositoryAccess remote;

    public ErrorHandlingModuleComponentRepository(ModuleComponentRepository delegate) {
        this.delegate = delegate;
        this.local = new ErrorHandlingModuleComponentRepositoryAccess(delegate.getLocalAccess());
        this.remote = new ErrorHandlingModuleComponentRepositoryAccess(delegate.getRemoteAccess());
    }

    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public String getId() {
        return this.delegate.getId();
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public ModuleComponentRepositoryAccess getLocalAccess() {
        return this.local;
    }

    @Override
    public ModuleComponentRepositoryAccess getRemoteAccess() {
        return this.remote;
    }

    private static final class ErrorHandlingModuleComponentRepositoryAccess
    implements ModuleComponentRepositoryAccess {
        private final ModuleComponentRepositoryAccess delegate;

        public ErrorHandlingModuleComponentRepositoryAccess(ModuleComponentRepositoryAccess delegate) {
            this.delegate = delegate;
        }

        public String toString() {
            return "error handling > " + this.delegate.toString();
        }

        @Override
        public void listModuleVersions(DependencyMetadata dependency, BuildableModuleVersionListingResolveResult result) {
            try {
                this.delegate.listModuleVersions(dependency, result);
            }
            catch (Throwable throwable) {
                result.failed(new ModuleVersionResolveException(dependency.getSelector(), throwable));
            }
        }

        @Override
        public void resolveComponentMetaData(ModuleComponentIdentifier moduleComponentIdentifier, ComponentOverrideMetadata requestMetaData, BuildableModuleComponentMetaDataResolveResult result) {
            try {
                this.delegate.resolveComponentMetaData(moduleComponentIdentifier, requestMetaData, result);
            }
            catch (Throwable throwable) {
                result.failed(new ModuleVersionResolveException(moduleComponentIdentifier, throwable));
            }
        }

        @Override
        public void resolveArtifactsWithType(ComponentResolveMetadata component, ArtifactType artifactType, BuildableArtifactSetResolveResult result) {
            try {
                this.delegate.resolveArtifactsWithType(component, artifactType, result);
            }
            catch (Throwable throwable) {
                result.failed(new ArtifactResolveException(component.getComponentId(), throwable));
            }
        }

        @Override
        public void resolveArtifacts(ComponentResolveMetadata component, BuildableComponentArtifactsResolveResult result) {
            try {
                this.delegate.resolveArtifacts(component, result);
            }
            catch (Throwable throwable) {
                result.failed(new ArtifactResolveException(component.getComponentId(), throwable));
            }
        }

        @Override
        public void resolveArtifact(ComponentArtifactMetadata artifact, ModuleSource moduleSource, BuildableArtifactResolveResult result) {
            try {
                this.delegate.resolveArtifact(artifact, moduleSource, result);
            }
            catch (Throwable throwable) {
                result.failed(new ArtifactResolveException(artifact.getId(), throwable));
            }
        }
    }
}

