/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.gradle.api.Action;
import org.gradle.api.artifacts.ArtifactIdentifier;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedModuleVersion;
import org.gradle.api.artifacts.cache.ArtifactResolutionControl;
import org.gradle.api.artifacts.cache.DependencyResolutionControl;
import org.gradle.api.artifacts.cache.ModuleResolutionControl;
import org.gradle.api.artifacts.cache.ResolutionControl;
import org.gradle.api.artifacts.cache.ResolutionRules;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.configurations.MutationValidator;
import org.gradle.api.internal.artifacts.configurations.dynamicversion.CachePolicy;
import org.gradle.api.internal.artifacts.ivyservice.dynamicversions.DefaultResolvedModuleVersion;

public class DefaultCachePolicy
implements CachePolicy,
ResolutionRules {
    private static final int SECONDS_IN_DAY = 86400;
    final List<Action<? super DependencyResolutionControl>> dependencyCacheRules;
    final List<Action<? super ModuleResolutionControl>> moduleCacheRules;
    final List<Action<? super ArtifactResolutionControl>> artifactCacheRules;
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
    private MutationValidator mutationValidator = MutationValidator.IGNORE;

    public DefaultCachePolicy(ImmutableModuleIdentifierFactory moduleIdentifierFactory) {
        this.moduleIdentifierFactory = moduleIdentifierFactory;
        this.dependencyCacheRules = new ArrayList<Action<? super DependencyResolutionControl>>();
        this.moduleCacheRules = new ArrayList<Action<? super ModuleResolutionControl>>();
        this.artifactCacheRules = new ArrayList<Action<? super ArtifactResolutionControl>>();
        this.cacheDynamicVersionsFor(86400, TimeUnit.SECONDS);
        this.cacheChangingModulesFor(86400, TimeUnit.SECONDS);
        this.cacheMissingArtifactsFor(86400, TimeUnit.SECONDS);
    }

    DefaultCachePolicy(DefaultCachePolicy policy) {
        this.moduleIdentifierFactory = policy.moduleIdentifierFactory;
        this.dependencyCacheRules = new ArrayList<Action<? super DependencyResolutionControl>>(policy.dependencyCacheRules);
        this.moduleCacheRules = new ArrayList<Action<? super ModuleResolutionControl>>(policy.moduleCacheRules);
        this.artifactCacheRules = new ArrayList<Action<? super ArtifactResolutionControl>>(policy.artifactCacheRules);
    }

    public void setMutationValidator(MutationValidator validator) {
        this.mutationValidator = validator;
    }

    public void eachDependency(Action<? super DependencyResolutionControl> rule) {
        this.mutationValidator.validateMutation(MutationValidator.MutationType.STRATEGY);
        this.dependencyCacheRules.add(0, rule);
    }

    public void eachModule(Action<? super ModuleResolutionControl> rule) {
        this.mutationValidator.validateMutation(MutationValidator.MutationType.STRATEGY);
        this.moduleCacheRules.add(0, rule);
    }

    public void eachArtifact(Action<? super ArtifactResolutionControl> rule) {
        this.mutationValidator.validateMutation(MutationValidator.MutationType.STRATEGY);
        this.artifactCacheRules.add(0, rule);
    }

    public void cacheDynamicVersionsFor(final int value, final TimeUnit unit) {
        this.eachDependency((Action<? super DependencyResolutionControl>)new Action<DependencyResolutionControl>(){

            public void execute(DependencyResolutionControl dependencyResolutionControl) {
                dependencyResolutionControl.cacheFor(value, unit);
            }
        });
    }

    public void cacheChangingModulesFor(final int value, final TimeUnit units) {
        this.eachModule((Action<? super ModuleResolutionControl>)new Action<ModuleResolutionControl>(){

            public void execute(ModuleResolutionControl moduleResolutionControl) {
                if (moduleResolutionControl.isChanging()) {
                    moduleResolutionControl.cacheFor(value, units);
                }
            }
        });
        this.eachArtifact((Action<? super ArtifactResolutionControl>)new Action<ArtifactResolutionControl>(){

            public void execute(ArtifactResolutionControl artifactResolutionControl) {
                if (artifactResolutionControl.belongsToChangingModule()) {
                    artifactResolutionControl.cacheFor(value, units);
                }
            }
        });
    }

    private void cacheMissingArtifactsFor(final int value, final TimeUnit units) {
        this.eachArtifact((Action<? super ArtifactResolutionControl>)new Action<ArtifactResolutionControl>(){

            public void execute(ArtifactResolutionControl artifactResolutionControl) {
                if (artifactResolutionControl.getCachedResult() == null) {
                    artifactResolutionControl.cacheFor(value, units);
                }
            }
        });
    }

    public boolean mustRefreshVersionList(ModuleIdentifier moduleIdentifier, Set<ModuleVersionIdentifier> matchingVersions, long ageMillis) {
        CachedDependencyResolutionControl dependencyResolutionControl = new CachedDependencyResolutionControl(moduleIdentifier, matchingVersions, ageMillis);
        for (Action<? super DependencyResolutionControl> rule : this.dependencyCacheRules) {
            rule.execute((Object)dependencyResolutionControl);
            if (!dependencyResolutionControl.ruleMatch()) continue;
            return dependencyResolutionControl.mustCheck();
        }
        return false;
    }

    public boolean mustRefreshMissingModule(ModuleComponentIdentifier component, long ageMillis) {
        return this.mustRefreshModule(component, null, ageMillis, false);
    }

    public boolean mustRefreshModule(ModuleComponentIdentifier component, ResolvedModuleVersion resolvedModuleVersion, long ageMillis) {
        return this.mustRefreshModule(component, resolvedModuleVersion, ageMillis, false);
    }

    public boolean mustRefreshChangingModule(ModuleComponentIdentifier component, ResolvedModuleVersion resolvedModuleVersion, long ageMillis) {
        return this.mustRefreshModule(component, resolvedModuleVersion, ageMillis, true);
    }

    private boolean mustRefreshModule(ModuleComponentIdentifier component, ResolvedModuleVersion version, long ageMillis, boolean changingModule) {
        return this.mustRefreshModule(this.moduleIdentifierFactory.moduleWithVersion(component.getGroup(), component.getModule(), component.getVersion()), version, ageMillis, changingModule);
    }

    private boolean mustRefreshModule(ModuleVersionIdentifier moduleVersionId, ResolvedModuleVersion version, long ageMillis, boolean changingModule) {
        CachedModuleResolutionControl moduleResolutionControl = new CachedModuleResolutionControl(moduleVersionId, version, changingModule, ageMillis);
        for (Action<? super ModuleResolutionControl> rule : this.moduleCacheRules) {
            rule.execute((Object)moduleResolutionControl);
            if (!moduleResolutionControl.ruleMatch()) continue;
            return moduleResolutionControl.mustCheck();
        }
        return false;
    }

    public boolean mustRefreshModuleArtifacts(ModuleVersionIdentifier moduleVersionId, Set<ArtifactIdentifier> artifacts, long ageMillis, boolean belongsToChangingModule, boolean moduleDescriptorInSync) {
        if (belongsToChangingModule && !moduleDescriptorInSync) {
            return true;
        }
        return this.mustRefreshModule(moduleVersionId, (ResolvedModuleVersion)new DefaultResolvedModuleVersion(moduleVersionId), ageMillis, belongsToChangingModule);
    }

    public boolean mustRefreshArtifact(ArtifactIdentifier artifactIdentifier, File cachedArtifactFile, long ageMillis, boolean belongsToChangingModule, boolean moduleDescriptorInSync) {
        CachedArtifactResolutionControl artifactResolutionControl = new CachedArtifactResolutionControl(artifactIdentifier, cachedArtifactFile, ageMillis, belongsToChangingModule);
        if (belongsToChangingModule && !moduleDescriptorInSync) {
            return true;
        }
        for (Action<? super ArtifactResolutionControl> rule : this.artifactCacheRules) {
            rule.execute((Object)artifactResolutionControl);
            if (!artifactResolutionControl.ruleMatch()) continue;
            return artifactResolutionControl.mustCheck();
        }
        return false;
    }

    DefaultCachePolicy copy() {
        return new DefaultCachePolicy(this);
    }

    private class CachedArtifactResolutionControl
    extends AbstractResolutionControl<ArtifactIdentifier, File>
    implements ArtifactResolutionControl {
        private final boolean belongsToChangingModule;

        private CachedArtifactResolutionControl(ArtifactIdentifier artifactIdentifier, File cachedResult, long ageMillis, boolean belongsToChangingModule) {
            super(artifactIdentifier, cachedResult, ageMillis);
            this.belongsToChangingModule = belongsToChangingModule;
        }

        public boolean belongsToChangingModule() {
            return this.belongsToChangingModule;
        }
    }

    private class CachedModuleResolutionControl
    extends AbstractResolutionControl<ModuleVersionIdentifier, ResolvedModuleVersion>
    implements ModuleResolutionControl {
        private final boolean changing;

        private CachedModuleResolutionControl(ModuleVersionIdentifier moduleVersionId, ResolvedModuleVersion cachedVersion, boolean changing, long ageMillis) {
            super(moduleVersionId, cachedVersion, ageMillis);
            this.changing = changing;
        }

        public boolean isChanging() {
            return this.changing;
        }
    }

    private class CachedDependencyResolutionControl
    extends AbstractResolutionControl<ModuleIdentifier, Set<ModuleVersionIdentifier>>
    implements DependencyResolutionControl {
        private CachedDependencyResolutionControl(ModuleIdentifier request, Set<ModuleVersionIdentifier> result, long ageMillis) {
            super(request, result, ageMillis);
        }
    }

    private static abstract class AbstractResolutionControl<A, B>
    implements ResolutionControl<A, B> {
        private final A request;
        private final B cachedResult;
        private final long ageMillis;
        private boolean ruleMatch;
        private boolean mustCheck;

        private AbstractResolutionControl(A request, B cachedResult, long ageMillis) {
            this.request = request;
            this.cachedResult = cachedResult;
            this.ageMillis = this.correctForClockShift(ageMillis);
        }

        private long correctForClockShift(long ageMillis) {
            if (ageMillis < 0L) {
                return 1L;
            }
            return ageMillis;
        }

        public A getRequest() {
            return this.request;
        }

        public B getCachedResult() {
            return this.cachedResult;
        }

        public void cacheFor(int value, TimeUnit units) {
            long expiryMillis = TimeUnit.MILLISECONDS.convert(value, units);
            if (this.ageMillis > expiryMillis) {
                this.setMustCheck(true);
            } else {
                this.setMustCheck(false);
            }
        }

        public void useCachedResult() {
            this.setMustCheck(false);
        }

        public void refresh() {
            this.setMustCheck(true);
        }

        private void setMustCheck(boolean val) {
            this.ruleMatch = true;
            this.mustCheck = val;
        }

        public boolean ruleMatch() {
            return this.ruleMatch;
        }

        public boolean mustCheck() {
            return this.mustCheck;
        }
    }
}

