/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ComponentResolvers;
import org.gradle.api.internal.component.ArtifactType;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentOverrideMetadata;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.ModuleSource;
import org.gradle.internal.resolve.resolver.ArtifactResolver;
import org.gradle.internal.resolve.resolver.ComponentMetaDataResolver;
import org.gradle.internal.resolve.resolver.DependencyToComponentIdResolver;
import org.gradle.internal.resolve.result.BuildableArtifactResolveResult;
import org.gradle.internal.resolve.result.BuildableArtifactSetResolveResult;
import org.gradle.internal.resolve.result.BuildableComponentArtifactsResolveResult;
import org.gradle.internal.resolve.result.BuildableComponentIdResolveResult;
import org.gradle.internal.resolve.result.BuildableComponentResolveResult;

public class ComponentResolversChain
implements ComponentResolvers {
    private final DependencyToComponentIdResolverChain dependencyToComponentIdResolver;
    private final ComponentMetaDataResolverChain componentMetaDataResolver;
    private final ArtifactResolverChain artifactResolverChain;

    public ComponentResolversChain(List<ComponentResolvers> providers) {
        ArrayList<DependencyToComponentIdResolver> depToComponentIdResolvers = new ArrayList<DependencyToComponentIdResolver>(providers.size());
        ArrayList<ComponentMetaDataResolver> componentMetaDataResolvers = new ArrayList<ComponentMetaDataResolver>(providers.size());
        ArrayList<ArtifactResolver> artifactResolvers = new ArrayList<ArtifactResolver>(providers.size());
        for (ComponentResolvers provider : providers) {
            depToComponentIdResolvers.add(provider.getComponentIdResolver());
            componentMetaDataResolvers.add(provider.getComponentResolver());
            artifactResolvers.add(provider.getArtifactResolver());
        }
        this.dependencyToComponentIdResolver = new DependencyToComponentIdResolverChain(depToComponentIdResolvers);
        this.componentMetaDataResolver = new ComponentMetaDataResolverChain(componentMetaDataResolvers);
        this.artifactResolverChain = new ArtifactResolverChain(artifactResolvers);
    }

    @Override
    public DependencyToComponentIdResolver getComponentIdResolver() {
        return this.dependencyToComponentIdResolver;
    }

    @Override
    public ComponentMetaDataResolver getComponentResolver() {
        return this.componentMetaDataResolver;
    }

    @Override
    public ArtifactResolver getArtifactResolver() {
        return this.artifactResolverChain;
    }

    private static class DependencyToComponentIdResolverChain
    implements DependencyToComponentIdResolver {
        private final List<DependencyToComponentIdResolver> resolvers;

        public DependencyToComponentIdResolverChain(List<DependencyToComponentIdResolver> resolvers) {
            this.resolvers = resolvers;
        }

        @Override
        public void resolve(DependencyMetadata dependency, BuildableComponentIdResolveResult result) {
            for (DependencyToComponentIdResolver resolver : this.resolvers) {
                if (result.hasResult()) {
                    return;
                }
                resolver.resolve(dependency, result);
            }
        }
    }

    private static class ArtifactResolverChain
    implements ArtifactResolver {
        private final List<ArtifactResolver> resolvers;

        private ArtifactResolverChain(List<ArtifactResolver> resolvers) {
            this.resolvers = resolvers;
        }

        @Override
        public void resolveArtifact(ComponentArtifactMetadata artifact, ModuleSource moduleSource, BuildableArtifactResolveResult result) {
            for (ArtifactResolver resolver : this.resolvers) {
                if (result.hasResult()) {
                    return;
                }
                resolver.resolveArtifact(artifact, moduleSource, result);
            }
        }

        @Override
        public void resolveArtifacts(ComponentResolveMetadata component, BuildableComponentArtifactsResolveResult result) {
            for (ArtifactResolver resolver : this.resolvers) {
                if (result.hasResult()) {
                    return;
                }
                resolver.resolveArtifacts(component, result);
            }
        }

        @Override
        public void resolveArtifactsWithType(ComponentResolveMetadata component, ArtifactType artifactType, BuildableArtifactSetResolveResult result) {
            for (ArtifactResolver resolver : this.resolvers) {
                if (result.hasResult()) {
                    return;
                }
                resolver.resolveArtifactsWithType(component, artifactType, result);
            }
        }
    }

    private static class ComponentMetaDataResolverChain
    implements ComponentMetaDataResolver {
        private final List<ComponentMetaDataResolver> resolvers;

        public ComponentMetaDataResolverChain(List<ComponentMetaDataResolver> resolvers) {
            this.resolvers = resolvers;
        }

        @Override
        public void resolve(ComponentIdentifier identifier, ComponentOverrideMetadata componentOverrideMetadata, BuildableComponentResolveResult result) {
            for (ComponentMetaDataResolver resolver : this.resolvers) {
                if (result.hasResult()) {
                    return;
                }
                resolver.resolve(identifier, componentOverrideMetadata, result);
            }
        }
    }
}

