/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import org.gradle.api.Buildable;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.tasks.TaskDependency;

public class ArtifactBackedArtifactSet
implements ResolvedArtifactSet {
    private final AttributeContainer variant;
    private final ImmutableSet<ResolvedArtifact> artifacts;

    private ArtifactBackedArtifactSet(AttributeContainer variant, Collection<? extends ResolvedArtifact> artifacts) {
        this.variant = variant;
        this.artifacts = ImmutableSet.copyOf(artifacts);
    }

    public static ResolvedArtifactSet forVariant(AttributeContainer variantAttributes, Collection<? extends ResolvedArtifact> artifacts) {
        if (artifacts.isEmpty()) {
            return EMPTY;
        }
        if (artifacts.size() == 1) {
            return new SingletonSet(variantAttributes, artifacts.iterator().next());
        }
        return new ArtifactBackedArtifactSet(variantAttributes, artifacts);
    }

    @Override
    public Set<ResolvedArtifact> getArtifacts() {
        return this.artifacts;
    }

    @Override
    public void collectBuildDependencies(Collection<? super TaskDependency> dest) {
        for (ResolvedArtifact artifact : this.artifacts) {
            dest.add((TaskDependency)((Buildable)artifact).getBuildDependencies());
        }
    }

    @Override
    public void visit(ArtifactVisitor visitor) {
        for (ResolvedArtifact artifact : this.artifacts) {
            visitor.visitArtifact(this.variant, artifact);
        }
    }

    private static class SingletonSet
    implements ResolvedArtifactSet {
        private final AttributeContainer variantAttributes;
        private final ResolvedArtifact artifact;

        SingletonSet(AttributeContainer variantAttributes, ResolvedArtifact artifact) {
            this.variantAttributes = variantAttributes;
            this.artifact = artifact;
        }

        @Override
        public Set<ResolvedArtifact> getArtifacts() {
            return ImmutableSet.of((Object)this.artifact);
        }

        @Override
        public void visit(ArtifactVisitor visitor) {
            visitor.visitArtifact(this.variantAttributes, this.artifact);
        }

        @Override
        public void collectBuildDependencies(Collection<? super TaskDependency> dest) {
            dest.add((TaskDependency)((Buildable)this.artifact).getBuildDependencies());
        }
    }
}

