/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import com.google.common.hash.HashCode;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.transform.ArtifactTransform;
import org.gradle.api.artifacts.transform.ArtifactTransformException;
import org.gradle.api.artifacts.transform.VariantTransformConfigurationException;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.artifacts.VariantTransformRegistry;
import org.gradle.api.internal.artifacts.transform.ArtifactTransformBackedTransformer;
import org.gradle.api.internal.artifacts.transform.TransformedFileCache;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.GenericFileCollectionSnapshotter;
import org.gradle.api.internal.changedetection.state.SnapshotNormalizationStrategy;
import org.gradle.api.internal.changedetection.state.TaskFilePropertyCompareStrategy;
import org.gradle.api.internal.changedetection.state.TaskFilePropertySnapshotNormalizationStrategy;
import org.gradle.api.internal.changedetection.state.ValueSnapshot;
import org.gradle.api.internal.changedetection.state.ValueSnapshotter;
import org.gradle.api.internal.file.collections.SimpleFileCollection;
import org.gradle.caching.internal.BuildCacheHasher;
import org.gradle.caching.internal.DefaultBuildCacheHasher;
import org.gradle.internal.classloader.ClassLoaderHierarchyHasher;
import org.gradle.internal.util.BiFunction;
import org.gradle.model.internal.type.ModelType;

class DefaultVariantTransformRegistration
implements VariantTransformRegistry.Registration,
Transformer<List<File>, File> {
    private final ImmutableAttributes from;
    private final ImmutableAttributes to;
    private final Class<? extends ArtifactTransform> implementation;
    private final HashCode inputsHash;
    private final GenericFileCollectionSnapshotter fileCollectionSnapshotter;
    private final TransformedFileCache transformedFileCache;
    private final BiFunction<List<File>, File, File> transformer;

    DefaultVariantTransformRegistration(AttributeContainerInternal from, AttributeContainerInternal to, Class<? extends ArtifactTransform> implementation, Object[] params, TransformedFileCache transformedFileCache, GenericFileCollectionSnapshotter fileCollectionSnapshotter, ValueSnapshotter valueSnapshotter, ClassLoaderHierarchyHasher classLoaderHierarchyHasher) {
        ValueSnapshot snapshot;
        this.from = from.asImmutable();
        this.to = to.asImmutable();
        this.implementation = implementation;
        this.transformedFileCache = transformedFileCache;
        this.fileCollectionSnapshotter = fileCollectionSnapshotter;
        DefaultBuildCacheHasher hasher = new DefaultBuildCacheHasher();
        hasher.putString((CharSequence)implementation.getName());
        hasher.putBytes(classLoaderHierarchyHasher.getClassLoaderHash(implementation.getClassLoader()).asBytes());
        try {
            snapshot = valueSnapshotter.snapshot((Object)params);
        }
        catch (Exception e) {
            throw new VariantTransformConfigurationException(String.format("Could not snapshot configuration values for transform %s: %s", ModelType.of(implementation).getDisplayName(), Arrays.asList(params)), (Throwable)e);
        }
        snapshot.appendToHasher((BuildCacheHasher)hasher);
        this.inputsHash = hasher.hash();
        this.transformer = new ArtifactTransformBackedTransformer(implementation, params);
    }

    public AttributeContainerInternal getFrom() {
        return this.from;
    }

    public AttributeContainerInternal getTo() {
        return this.to;
    }

    public Transformer<List<File>, File> getArtifactTransform() {
        return this;
    }

    public List<File> transform(File input) {
        try {
            File absoluteFile = input.getAbsoluteFile();
            FileCollectionSnapshot snapshot = this.fileCollectionSnapshotter.snapshot((FileCollection)new SimpleFileCollection(new File[]{absoluteFile}), TaskFilePropertyCompareStrategy.UNORDERED, (SnapshotNormalizationStrategy)TaskFilePropertySnapshotNormalizationStrategy.ABSOLUTE);
            DefaultBuildCacheHasher hasher = new DefaultBuildCacheHasher();
            hasher.putBytes(this.inputsHash.asBytes());
            snapshot.appendToHasher((BuildCacheHasher)hasher);
            HashCode resultHash = hasher.hash();
            return this.transformedFileCache.getResult(absoluteFile, resultHash, this.transformer);
        }
        catch (Exception e) {
            throw new ArtifactTransformException(input, (AttributeContainer)this.to, this.implementation, (Throwable)e);
        }
    }
}

