/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testkit.runner.internal;

import java.util.List;
import org.gradle.api.Nullable;
import org.gradle.testkit.runner.BuildResult;
import org.gradle.testkit.runner.BuildTask;
import org.gradle.testkit.runner.TaskOutcome;
import org.gradle.testkit.runner.internal.BuildOperationParameters;
import org.gradle.testkit.runner.internal.DefaultBuildResult;
import org.gradle.testkit.runner.internal.feature.BuildResultOutputFeatureCheck;
import org.gradle.testkit.runner.internal.feature.BuildResultTasksFeatureCheck;
import org.gradle.testkit.runner.internal.feature.FeatureCheck;

public class FeatureCheckBuildResult
implements BuildResult {
    private final BuildResult delegateBuildResult;
    private final FeatureCheck outputFeatureCheck;
    private final FeatureCheck tasksFeatureCheck;

    public FeatureCheckBuildResult(BuildOperationParameters buildOperationParameters, String output, List<BuildTask> tasks) {
        this.delegateBuildResult = new DefaultBuildResult(output, tasks);
        this.outputFeatureCheck = new BuildResultOutputFeatureCheck(buildOperationParameters.getTargetGradleVersion(), buildOperationParameters.isEmbedded());
        this.tasksFeatureCheck = new BuildResultTasksFeatureCheck(buildOperationParameters.getTargetGradleVersion());
    }

    @Override
    public String getOutput() {
        this.outputFeatureCheck.verify();
        return this.delegateBuildResult.getOutput();
    }

    @Override
    public List<BuildTask> getTasks() {
        this.tasksFeatureCheck.verify();
        return this.delegateBuildResult.getTasks();
    }

    @Override
    public List<BuildTask> tasks(TaskOutcome outcome) {
        this.tasksFeatureCheck.verify();
        return this.delegateBuildResult.tasks(outcome);
    }

    @Override
    public List<String> taskPaths(TaskOutcome outcome) {
        this.tasksFeatureCheck.verify();
        return this.delegateBuildResult.taskPaths(outcome);
    }

    @Override
    @Nullable
    public BuildTask task(String taskPath) {
        this.tasksFeatureCheck.verify();
        return this.delegateBuildResult.task(taskPath);
    }
}

