/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.taskfactory;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import groovy.lang.GroovyObject;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.internal.AbstractTask;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.internal.project.taskfactory.InputDirectoryPropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.InputFilePropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.InputFilesPropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.InputPropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.NestedBeanPropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.NoOpPropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.OutputDirectoriesPropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.OutputDirectoryPropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.OutputFilePropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.OutputFilesPropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.OverridingPropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.PropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.TaskClassValidator;
import org.gradle.api.internal.project.taskfactory.TaskClassValidatorExtractor;
import org.gradle.api.internal.project.taskfactory.TaskPropertyActionContext;
import org.gradle.api.internal.project.taskfactory.TaskPropertyInfo;
import org.gradle.api.internal.project.taskfactory.UpdateAction;
import org.gradle.api.internal.project.taskfactory.ValidationAction;
import org.gradle.api.internal.tasks.options.OptionValues;
import org.gradle.api.tasks.Console;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.internal.Cast;
import org.gradle.internal.reflect.GroovyMethods;
import org.gradle.internal.reflect.PropertyAccessorType;
import org.gradle.internal.reflect.Types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTaskClassValidatorExtractor
implements TaskClassValidatorExtractor {
    private static final Collection<Class<?>> IGNORED_SUPER_CLASSES = ImmutableSet.of(ConventionTask.class, DefaultTask.class, AbstractTask.class, Task.class, Object.class, GroovyObject.class, (Object[])new Class[0]);
    private static final List<? extends PropertyAnnotationHandler> HANDLERS = Arrays.asList(new InputFilePropertyAnnotationHandler(), new InputDirectoryPropertyAnnotationHandler(), new InputFilesPropertyAnnotationHandler(), new OutputFilePropertyAnnotationHandler(), new OutputFilesPropertyAnnotationHandler(), new OutputDirectoryPropertyAnnotationHandler(), new OutputDirectoriesPropertyAnnotationHandler(), new InputPropertyAnnotationHandler(), new NestedBeanPropertyAnnotationHandler(), new NoOpPropertyAnnotationHandler(Inject.class), new NoOpPropertyAnnotationHandler(Console.class), new NoOpPropertyAnnotationHandler(Internal.class), new NoOpPropertyAnnotationHandler(OptionValues.class));
    private final Map<Class<? extends Annotation>, PropertyAnnotationHandler> annotationHandlers;
    private final Multimap<Class<? extends Annotation>, Class<? extends Annotation>> annotationOverrides;

    public DefaultTaskClassValidatorExtractor(PropertyAnnotationHandler ... customAnnotationHandlers) {
        this(Arrays.asList(customAnnotationHandlers));
    }

    public DefaultTaskClassValidatorExtractor(Iterable<? extends PropertyAnnotationHandler> customAnnotationHandlers) {
        Iterable allAnnotationHandlers = Iterables.concat(HANDLERS, customAnnotationHandlers);
        this.annotationHandlers = Maps.uniqueIndex((Iterable)allAnnotationHandlers, (Function)new Function<PropertyAnnotationHandler, Class<? extends Annotation>>(){

            public Class<? extends Annotation> apply(PropertyAnnotationHandler handler) {
                return handler.getAnnotationType();
            }
        });
        this.annotationOverrides = DefaultTaskClassValidatorExtractor.collectAnnotationOverrides(allAnnotationHandlers);
    }

    private static Multimap<Class<? extends Annotation>, Class<? extends Annotation>> collectAnnotationOverrides(Iterable<PropertyAnnotationHandler> allAnnotationHandlers) {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        for (PropertyAnnotationHandler handler : allAnnotationHandlers) {
            if (!(handler instanceof OverridingPropertyAnnotationHandler)) continue;
            builder.put(((OverridingPropertyAnnotationHandler)handler).getOverriddenAnnotationType(), handler.getAnnotationType());
        }
        return builder.build();
    }

    @Override
    public TaskClassValidator extractValidator(Class<? extends Task> type) {
        ImmutableSet.Builder validatedPropertiesBuilder = ImmutableSet.builder();
        ImmutableSortedSet.Builder nonAnnotatedPropertiesBuilder = ImmutableSortedSet.naturalOrder();
        ArrayDeque<TypeEntry> queue = new ArrayDeque<TypeEntry>();
        queue.add(new TypeEntry(null, type));
        while (!queue.isEmpty()) {
            TypeEntry entry = (TypeEntry)queue.remove();
            this.parseProperties(entry.parent, entry.type, (ImmutableSet.Builder<TaskPropertyInfo>)validatedPropertiesBuilder, (ImmutableSet.Builder<String>)nonAnnotatedPropertiesBuilder, queue);
        }
        return new TaskClassValidator((Set<TaskPropertyInfo>)validatedPropertiesBuilder.build(), (Set<String>)nonAnnotatedPropertiesBuilder.build());
    }

    private <T> void parseProperties(final TaskPropertyInfo parent, Class<T> type, ImmutableSet.Builder<TaskPropertyInfo> validatedPropertiesBuilder, ImmutableSet.Builder<String> nonAnnotatedPropertiesBuilder, Queue<TypeEntry> queue) {
        final Set<Class<? extends Annotation>> propertyTypeAnnotations = this.annotationHandlers.keySet();
        final HashMap propertyContexts = Maps.newHashMap();
        Types.walkTypeHierarchy(type, IGNORED_SUPER_CLASSES, (Types.TypeVisitor)new Types.TypeVisitor<T>(){

            public void visitType(Class<? super T> type) {
                Method[] methods;
                Map fields = DefaultTaskClassValidatorExtractor.getFields(type);
                for (Method method : methods = type.getDeclaredMethods()) {
                    PropertyAccessorType accessorType = PropertyAccessorType.of((Method)method);
                    if (accessorType == null || accessorType == PropertyAccessorType.SETTER || method.isBridge() || GroovyMethods.isObjectMethod((Method)method)) continue;
                    String fieldName = accessorType.propertyNameFor(method);
                    Field field = (Field)fields.get(fieldName);
                    String propertyName = parent != null ? parent.getName() + '.' + fieldName : fieldName;
                    DefaultTaskPropertyActionContext propertyContext = (DefaultTaskPropertyActionContext)propertyContexts.get(propertyName);
                    if (propertyContext == null) {
                        propertyContext = new DefaultTaskPropertyActionContext(propertyTypeAnnotations, parent, propertyName, method);
                        propertyContexts.put(propertyName, propertyContext);
                    }
                    final ArrayList declaredAnnotations = Lists.newArrayList((Object[])method.getDeclaredAnnotations());
                    if (field != null) {
                        propertyContext.setInstanceVariableField(field);
                        Collections.addAll(declaredAnnotations, field.getDeclaredAnnotations());
                    }
                    propertyContext.addAnnotations(Iterables.filter((Iterable)declaredAnnotations, (Predicate)new Predicate<Annotation>(){

                        public boolean apply(Annotation input) {
                            Class<? extends Annotation> annotationType = input.annotationType();
                            if (!propertyTypeAnnotations.contains(annotationType)) {
                                return true;
                            }
                            for (Class overridingAnnotation : DefaultTaskClassValidatorExtractor.this.annotationOverrides.get(annotationType)) {
                                for (Annotation declaredAnnotation : declaredAnnotations) {
                                    if (!declaredAnnotation.annotationType().equals(overridingAnnotation)) continue;
                                    return false;
                                }
                            }
                            return true;
                        }
                    }));
                }
            }
        });
        for (DefaultTaskPropertyActionContext propertyContext : propertyContexts.values()) {
            TaskPropertyInfo property = this.createProperty(propertyContext, nonAnnotatedPropertiesBuilder);
            if (property == null) continue;
            validatedPropertiesBuilder.add((Object)property);
            Class<?> nestedType = propertyContext.getNestedType();
            if (nestedType == null) continue;
            queue.add(new TypeEntry(property, nestedType));
        }
    }

    private TaskPropertyInfo createProperty(DefaultTaskPropertyActionContext propertyContext, ImmutableSet.Builder<String> nonAnnotatedProperties) {
        Class<? extends Annotation> propertyType = propertyContext.getPropertyType();
        if (propertyType != null) {
            if (propertyContext.isAnnotationPresent(Optional.class)) {
                propertyContext.setOptional(true);
            }
            PropertyAnnotationHandler handler = this.annotationHandlers.get(propertyType);
            handler.attachActions(propertyContext);
            return propertyContext.createProperty();
        }
        nonAnnotatedProperties.add((Object)propertyContext.getName());
        return null;
    }

    private static Map<String, Field> getFields(Class<?> type) {
        HashMap fields = Maps.newHashMap();
        for (Field field : type.getDeclaredFields()) {
            fields.put(field.getName(), field);
        }
        return fields;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultTaskPropertyActionContext
    implements TaskPropertyActionContext {
        private final Set<Class<? extends Annotation>> propertyTypeAnnotations;
        private final TaskPropertyInfo parent;
        private final String name;
        private final Method method;
        private final List<Annotation> annotations = Lists.newArrayList();
        private Field instanceVariableField;
        private ValidationAction validationAction;
        private UpdateAction configureAction;
        private boolean optional;
        private Class<?> nestedType;
        private Class<? extends Annotation> propertyType;

        public DefaultTaskPropertyActionContext(Set<Class<? extends Annotation>> propertyTypeAnnotations, TaskPropertyInfo parent, String name, Method method) {
            this.propertyTypeAnnotations = propertyTypeAnnotations;
            this.parent = parent;
            this.name = name;
            this.method = method;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Class<? extends Annotation> getPropertyType() {
            return this.propertyType;
        }

        @Override
        public Class<?> getValueType() {
            return this.instanceVariableField != null ? this.instanceVariableField.getType() : this.method.getReturnType();
        }

        @Override
        public void addAnnotations(Iterable<? extends Annotation> declaredAnnotations) {
            for (Annotation annotation : declaredAnnotations) {
                Class<? extends Annotation> annotationType = annotation.annotationType();
                if (this.propertyType == null && this.isPropertyTypeAnnotation(annotationType)) {
                    this.propertyType = annotationType;
                }
                if (this.isAnnotationPresent(annotation.getClass())) continue;
                this.annotations.add(annotation);
            }
        }

        private boolean isPropertyTypeAnnotation(Class<? extends Annotation> annotationType) {
            return this.propertyTypeAnnotations.contains(annotationType);
        }

        @Override
        public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
            for (Annotation annotation : this.annotations) {
                if (!annotationType.isAssignableFrom(annotation.getClass())) continue;
                return (A)((Annotation)Cast.uncheckedCast((Object)annotation));
            }
            return null;
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            return this.getAnnotation(annotationType) != null;
        }

        @Override
        public void setInstanceVariableField(Field instanceVariableField) {
            if (this.instanceVariableField == null && instanceVariableField != null) {
                this.instanceVariableField = instanceVariableField;
            }
        }

        @Override
        public boolean isOptional() {
            return this.optional;
        }

        @Override
        public void setOptional(boolean optional) {
            this.optional = optional;
        }

        @Override
        public void setValidationAction(ValidationAction action) {
            this.validationAction = action;
        }

        @Override
        public void setConfigureAction(UpdateAction action) {
            this.configureAction = action;
        }

        public Class<?> getNestedType() {
            return this.nestedType;
        }

        @Override
        public void setNestedType(Class<?> nestedType) {
            this.nestedType = nestedType;
        }

        public TaskPropertyInfo createProperty() {
            if (this.configureAction == null && this.validationAction == null) {
                return null;
            }
            return new TaskPropertyInfo(this.parent, this.name, this.propertyType, this.method, this.validationAction, this.configureAction, this.optional);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TypeEntry {
        private final TaskPropertyInfo parent;
        private final Class<?> type;

        public TypeEntry(TaskPropertyInfo parent, Class<?> type) {
            this.parent = parent;
            this.type = type;
        }
    }
}

