/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal;

import com.google.common.annotations.VisibleForTesting;
import javax.inject.Inject;
import org.gradle.StartParameter;
import org.gradle.api.internal.file.TemporaryFileProvider;
import org.gradle.caching.BuildCacheService;
import org.gradle.caching.BuildCacheServiceFactory;
import org.gradle.caching.configuration.BuildCache;
import org.gradle.caching.configuration.internal.BuildCacheConfigurationInternal;
import org.gradle.caching.internal.BuildOperationFiringBuildCacheServiceDecorator;
import org.gradle.caching.internal.DispatchingBuildCacheService;
import org.gradle.caching.internal.ForwardingBuildCacheService;
import org.gradle.caching.internal.LoggingBuildCacheServiceDecorator;
import org.gradle.caching.internal.NoOpBuildCacheService;
import org.gradle.caching.internal.PushOrPullPreventingBuildCacheServiceDecorator;
import org.gradle.caching.internal.RoleAwareBuildCacheService;
import org.gradle.caching.internal.ShortCircuitingErrorHandlerBuildCacheServiceDecorator;
import org.gradle.internal.Cast;
import org.gradle.internal.progress.BuildOperationExecutor;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.util.SingleMessageLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildCacheServiceProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(BuildCacheServiceProvider.class);
    private static final int MAX_ERROR_COUNT_FOR_BUILD_CACHE = 3;
    private final BuildCacheConfigurationInternal buildCacheConfiguration;
    private final BuildOperationExecutor buildOperationExecutor;
    private final Instantiator instantiator;
    private final StartParameter startParameter;
    private final TemporaryFileProvider temporaryFileProvider;

    @Inject
    public BuildCacheServiceProvider(BuildCacheConfigurationInternal buildCacheConfiguration, StartParameter startParameter, Instantiator instantiator, BuildOperationExecutor buildOperationExecutor, TemporaryFileProvider temporaryFileProvider) {
        this.buildCacheConfiguration = buildCacheConfiguration;
        this.startParameter = startParameter;
        this.instantiator = instantiator;
        this.buildOperationExecutor = buildOperationExecutor;
        this.temporaryFileProvider = temporaryFileProvider;
    }

    public BuildCacheService createBuildCacheService() {
        RoleAwareBuildCacheService buildCacheService;
        if (!this.startParameter.isBuildCacheEnabled()) {
            return new NoOpBuildCacheService();
        }
        SingleMessageLogger.incubatingFeatureUsed((String)"Build cache");
        BuildCache local = this.buildCacheConfiguration.getLocal();
        BuildCache remote = this.buildCacheConfiguration.getRemote();
        if (local.isEnabled()) {
            buildCacheService = remote != null && remote.isEnabled() ? this.createDispatchingBuildCacheService(local, remote) : this.createStandaloneLocalBuildService(local);
        } else if (remote != null && remote.isEnabled()) {
            buildCacheService = this.createStandaloneRemoteBuildService(remote);
        } else {
            LOGGER.warn("Task output caching is enabled, but no build caches are configured or enabled.");
            return new NoOpBuildCacheService();
        }
        if (this.buildCacheConfiguration.isPullDisabled() || this.buildCacheConfiguration.isPushDisabled()) {
            if (this.buildCacheConfiguration.isPushDisabled()) {
                LOGGER.warn("Pushing to any build cache is globally disabled.");
            }
            if (this.buildCacheConfiguration.isPullDisabled()) {
                LOGGER.warn("Pulling from any build cache is globally disabled.");
            }
            buildCacheService = new PushOrPullPreventingBuildCacheServiceDecorator(this.buildCacheConfiguration.isPushDisabled(), this.buildCacheConfiguration.isPullDisabled(), buildCacheService);
        }
        return buildCacheService;
    }

    private RoleAwareBuildCacheService createDispatchingBuildCacheService(BuildCache local, BuildCache remote) {
        return new DispatchingBuildCacheService(this.createDecoratedBuildCacheService("local", local), local.isPush(), this.createDecoratedBuildCacheService("remote", remote), remote.isPush(), this.temporaryFileProvider);
    }

    private RoleAwareBuildCacheService createStandaloneLocalBuildService(BuildCache local) {
        return this.preventPushIfNecessary(this.createDecoratedBuildCacheService("local", local), local.isPush());
    }

    private RoleAwareBuildCacheService createStandaloneRemoteBuildService(BuildCache remote) {
        return this.preventPushIfNecessary(this.createDecoratedBuildCacheService("remote", remote), remote.isPush());
    }

    private RoleAwareBuildCacheService preventPushIfNecessary(RoleAwareBuildCacheService buildCacheService, boolean pushEnabled) {
        return pushEnabled ? buildCacheService : new PushOrPullPreventingBuildCacheServiceDecorator(true, false, buildCacheService);
    }

    @VisibleForTesting
    RoleAwareBuildCacheService createDecoratedBuildCacheService(String role, BuildCache buildCache) {
        ForwardingBuildCacheService buildCacheService = new BuildCacheServiceWithRole(role, this.createRawBuildCacheService(buildCache));
        LOGGER.warn("Using {} as {} build cache, push is {}.", new Object[]{buildCacheService.getDescription(), role, buildCache.isPush() ? "enabled" : "disabled"});
        buildCacheService = new BuildOperationFiringBuildCacheServiceDecorator(this.buildOperationExecutor, (RoleAwareBuildCacheService)((Object)buildCacheService));
        buildCacheService = new LoggingBuildCacheServiceDecorator((RoleAwareBuildCacheService)((Object)buildCacheService));
        buildCacheService = new ShortCircuitingErrorHandlerBuildCacheServiceDecorator(3, (RoleAwareBuildCacheService)((Object)buildCacheService));
        return buildCacheService;
    }

    private <T extends BuildCache> BuildCacheService createRawBuildCacheService(T configuration) {
        Class buildCacheServiceFactoryType = (Class)Cast.uncheckedCast(this.buildCacheConfiguration.getBuildCacheServiceFactoryType(configuration.getClass()));
        return ((BuildCacheServiceFactory)this.instantiator.newInstance(buildCacheServiceFactoryType, new Object[0])).createBuildCacheService(configuration);
    }

    private static class BuildCacheServiceWithRole
    extends ForwardingBuildCacheService
    implements RoleAwareBuildCacheService {
        private final String role;
        private final BuildCacheService delegate;

        public BuildCacheServiceWithRole(String role, BuildCacheService delegate) {
            this.role = role;
            this.delegate = delegate;
        }

        protected BuildCacheService delegate() {
            return this.delegate;
        }

        public String getRole() {
            return this.role;
        }
    }
}

