/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal;

import org.gradle.caching.BuildCacheEntryReader;
import org.gradle.caching.BuildCacheEntryWriter;
import org.gradle.caching.BuildCacheException;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.internal.AbstractRoleAwareBuildCacheServiceDecorator;
import org.gradle.caching.internal.RoleAwareBuildCacheService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushOrPullPreventingBuildCacheServiceDecorator
extends AbstractRoleAwareBuildCacheServiceDecorator {
    private static final Logger LOGGER = LoggerFactory.getLogger(PushOrPullPreventingBuildCacheServiceDecorator.class);
    private final boolean pushDisabled;
    private final boolean pullDisabled;

    public PushOrPullPreventingBuildCacheServiceDecorator(boolean pushDisabled, boolean pullDisabled, RoleAwareBuildCacheService delegate) {
        super(delegate);
        this.pushDisabled = pushDisabled;
        this.pullDisabled = pullDisabled;
    }

    public boolean load(BuildCacheKey key, BuildCacheEntryReader reader) throws BuildCacheException {
        if (this.pullDisabled) {
            LOGGER.debug("Not loading entry {} because pulling from {} build cache is disabled for the build", (Object)key, (Object)this.getRole());
            return false;
        }
        return super.load(key, reader);
    }

    public void store(BuildCacheKey key, BuildCacheEntryWriter writer) throws BuildCacheException {
        if (this.pushDisabled) {
            LOGGER.debug("Not storing entry {} because pushing to {} build cache is disabled for the build", (Object)key, (Object)this.getRole());
        } else {
            super.store(key, writer);
        }
    }
}

