/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts;

import groovy.lang.MetaClass;
import java.io.PrintStream;
import java.util.Map;
import org.gradle.api.internal.DynamicObjectUtil;
import org.gradle.api.internal.ProcessOperations;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.groovy.scripts.Script;
import org.gradle.internal.logging.StandardOutputCapture;
import org.gradle.internal.metaobject.BeanDynamicObject;
import org.gradle.internal.metaobject.DynamicObject;
import org.gradle.internal.metaobject.GetPropertyResult;
import org.gradle.internal.metaobject.InvokeMethodResult;
import org.gradle.internal.service.ServiceRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasicScript
extends Script
implements org.gradle.api.Script,
FileOperations,
ProcessOperations {
    private StandardOutputCapture standardOutputCapture;
    private Object target;
    private DynamicObject dynamicTarget;
    private final DynamicObject scriptObject = new BeanDynamicObject(this).withNotImplementsMissing();

    @Override
    public void init(Object target, ServiceRegistry services) {
        this.standardOutputCapture = (StandardOutputCapture)services.get(StandardOutputCapture.class);
        this.setScriptTarget(target);
    }

    public Object getScriptTarget() {
        return this.target;
    }

    private void setScriptTarget(Object target) {
        this.target = target;
        this.dynamicTarget = DynamicObjectUtil.asDynamicObject(target);
    }

    @Override
    public StandardOutputCapture getStandardOutputCapture() {
        return this.standardOutputCapture;
    }

    public PrintStream getOut() {
        return System.out;
    }

    public Object getProperty(String property) {
        if (this.getBinding().hasVariable(property)) {
            return super.getProperty(property);
        }
        GetPropertyResult result = new GetPropertyResult();
        this.scriptObject.getProperty(property, result);
        if (result.isFound()) {
            return result.getValue();
        }
        this.dynamicTarget.getProperty(property, result);
        if (result.isFound()) {
            return result.getValue();
        }
        throw this.dynamicTarget.getMissingProperty(property);
    }

    public void setProperty(String property, Object newValue) {
        if ("metaClass".equals(property)) {
            this.setMetaClass((MetaClass)newValue);
        } else if ("scriptTarget".equals(property)) {
            this.setScriptTarget(newValue);
        } else {
            this.dynamicTarget.setProperty(property, newValue);
        }
    }

    public Map<String, ?> getProperties() {
        return this.dynamicTarget.getProperties();
    }

    public boolean hasProperty(String property) {
        return this.getBinding().hasVariable(property) || this.scriptObject.hasProperty(property) || this.dynamicTarget.hasProperty(property);
    }

    public Object invokeMethod(String name, Object args) {
        Object[] arguments = (Object[])args;
        InvokeMethodResult result = new InvokeMethodResult();
        this.scriptObject.invokeMethod(name, result, arguments);
        if (result.isFound()) {
            return result.getResult();
        }
        this.dynamicTarget.invokeMethod(name, result, arguments);
        if (result.isFound()) {
            return result.getResult();
        }
        throw this.dynamicTarget.methodMissingException(name, arguments);
    }

    public Object methodMissing(String name, Object args) {
        return this.invokeMethod(name, args);
    }
}

