/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testing.jacoco.plugins;

import java.io.File;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.internal.Cast;
import org.gradle.internal.jacoco.JacocoAgentJar;
import org.gradle.process.JavaForkOptions;
import org.gradle.testing.jacoco.plugins.JacocoTaskExtension;

@Incubating
public class JacocoPluginExtension {
    public static final String TASK_EXTENSION_NAME = "jacoco";
    private Logger logger = Logging.getLogger(this.getClass());
    protected final Project project;
    private final JacocoAgentJar agent;
    private String toolVersion;
    private File reportsDir;

    public JacocoPluginExtension(Project project, JacocoAgentJar agent) {
        this.project = project;
        this.agent = agent;
    }

    public String getToolVersion() {
        return this.toolVersion;
    }

    public void setToolVersion(String toolVersion) {
        this.toolVersion = toolVersion;
    }

    public File getReportsDir() {
        return this.reportsDir;
    }

    public void setReportsDir(File reportsDir) {
        this.reportsDir = reportsDir;
    }

    public <T extends Task & JavaForkOptions> void applyTo(final T task) {
        final String taskName = task.getName();
        this.logger.debug("Applying Jacoco to " + taskName);
        final JacocoTaskExtension extension = (JacocoTaskExtension)task.getExtensions().create(TASK_EXTENSION_NAME, JacocoTaskExtension.class, new Object[]{this.agent, task});
        ((IConventionAware)extension).getConventionMapping().map("destinationFile", (Callable)new Callable<File>(){

            @Override
            public File call() {
                return JacocoPluginExtension.this.project.file((Object)(String.valueOf(JacocoPluginExtension.this.project.getBuildDir()) + "/jacoco/" + taskName + ".exec"));
            }
        });
        task.getInputs().property("jacoco.enabled", (Object)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return extension.isEnabled();
            }
        });
        task.getInputs().property("jacoco.jvmArgs", (Object)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return extension.getAsJvmArg();
            }
        });
        TaskInternal taskInternal = (TaskInternal)task;
        taskInternal.getOutputs().doNotCacheIf("Jacoco configured to not produce its output as a file", (Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task element) {
                return extension.isEnabled() && extension.getOutput() != JacocoTaskExtension.Output.FILE;
            }
        });
        taskInternal.getOutputs().file((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return extension.getDestinationFile();
            }
        }).optional().withPropertyName("jacoco.destinationFile");
        taskInternal.getOutputs().dir((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return extension.getClassDumpDir();
            }
        }).optional().withPropertyName("jacoco.classDumpDir");
        taskInternal.prependParallelSafeAction((Action)new Action<Task>(){

            public void execute(Task input) {
                if (extension.isEnabled()) {
                    ((JavaForkOptions)task).jvmArgs(new Object[]{extension.getAsJvmArg()});
                }
            }
        });
        taskInternal.getOutputs().doNotCacheIf("Jacoco agent configured with `append = true`", (Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task element) {
                return extension.isAppend();
            }
        });
    }

    public <T extends Task & JavaForkOptions> void applyTo(TaskCollection tasks) {
        tasks.withType(JavaForkOptions.class, (Action)new Action<JavaForkOptions>(){

            public void execute(JavaForkOptions task) {
                JacocoPluginExtension.this.applyTo((Task)Cast.uncheckedCast((Object)task));
            }
        });
    }

    @Deprecated
    public Logger getLogger() {
        return this.logger;
    }

    @Deprecated
    public void setLogger(Logger logger) {
        this.logger = logger;
    }
}

