/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.console;

import java.util.Arrays;
import org.gradle.internal.logging.console.Console;
import org.gradle.internal.logging.console.StyledLabel;
import org.gradle.internal.logging.events.BatchOutputEventListener;
import org.gradle.internal.logging.events.OperationIdentifier;
import org.gradle.internal.logging.events.OutputEvent;
import org.gradle.internal.logging.events.ProgressCompleteEvent;
import org.gradle.internal.logging.events.ProgressEvent;
import org.gradle.internal.logging.events.ProgressStartEvent;
import org.gradle.internal.logging.text.Span;
import org.gradle.internal.logging.text.Style;
import org.gradle.internal.nativeintegration.console.ConsoleMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildStatusRenderer
extends BatchOutputEventListener {
    public static final String BUILD_PROGRESS_CATEGORY = "org.gradle.internal.progress.BuildProgressLogger";
    private final BatchOutputEventListener listener;
    private final StyledLabel buildStatusLabel;
    private final Console console;
    private final ConsoleMetaData consoleMetaData;
    private String currentBuildStatus;
    private OperationIdentifier rootOperationId;

    public BuildStatusRenderer(BatchOutputEventListener listener, StyledLabel buildStatusLabel, Console console, ConsoleMetaData consoleMetaData) {
        this.listener = listener;
        this.buildStatusLabel = buildStatusLabel;
        this.console = console;
        this.consoleMetaData = consoleMetaData;
    }

    private void buildStarted(ProgressStartEvent progressStartEvent) {
        this.currentBuildStatus = progressStartEvent.getShortDescription();
    }

    private void buildProgressed(ProgressEvent progressEvent) {
        this.currentBuildStatus = progressEvent.getStatus();
    }

    private void buildFinished(ProgressCompleteEvent progressCompleteEvent) {
        this.currentBuildStatus = "";
    }

    @Override
    public void onOutput(OutputEvent event) {
        ProgressEvent progressEvent;
        if (event instanceof ProgressStartEvent) {
            ProgressStartEvent startEvent = (ProgressStartEvent)event;
            if (startEvent.getParentId() == null && BUILD_PROGRESS_CATEGORY.equals(startEvent.getCategory())) {
                this.rootOperationId = startEvent.getOperationId();
                this.buildStarted(startEvent);
            }
        } else if (event instanceof ProgressCompleteEvent) {
            ProgressCompleteEvent completeEvent = (ProgressCompleteEvent)event;
            if (completeEvent.getOperationId().equals(this.rootOperationId)) {
                this.rootOperationId = null;
                this.buildFinished(completeEvent);
            }
        } else if (event instanceof ProgressEvent && (progressEvent = (ProgressEvent)event).getOperationId().equals(this.rootOperationId)) {
            this.buildProgressed(progressEvent);
        }
    }

    @Override
    public void onOutput(Iterable<OutputEvent> events) {
        super.onOutput(events);
        this.listener.onOutput(events);
        this.renderNow();
    }

    private String trimToConsole(String str) {
        int width = this.consoleMetaData.getCols() - 1;
        if (width > 0 && width < str.length()) {
            return str.substring(0, width);
        }
        return str;
    }

    private void renderNow() {
        if (this.currentBuildStatus != null) {
            this.buildStatusLabel.setText(Arrays.asList(new Span(Style.of(Style.Emphasis.BOLD), this.trimToConsole(this.currentBuildStatus))));
        }
        this.console.flush();
    }
}

