/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.console;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.gradle.internal.logging.events.BatchOutputEventListener;
import org.gradle.internal.logging.events.EndOutputEvent;
import org.gradle.internal.logging.events.OutputEvent;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.time.TimeProvider;

public class ThrottlingOutputEventListener
implements OutputEventListener {
    private final BatchOutputEventListener listener;
    private final ScheduledExecutorService executor;
    private final TimeProvider timeProvider;
    private final int throttleMs;
    private final Object lock = new Object();
    private long lastUpdate;
    private final List<OutputEvent> queue = new ArrayList<OutputEvent>();

    public ThrottlingOutputEventListener(BatchOutputEventListener listener, TimeProvider timeProvider) {
        this(listener, Integer.getInteger("org.gradle.console.throttle", 85), Executors.newSingleThreadScheduledExecutor(), timeProvider);
    }

    ThrottlingOutputEventListener(BatchOutputEventListener listener, int throttleMs, ScheduledExecutorService executor, TimeProvider timeProvider) {
        this.throttleMs = throttleMs;
        this.listener = listener;
        this.executor = executor;
        this.timeProvider = timeProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOutput(OutputEvent newEvent) {
        Object object = this.lock;
        synchronized (object) {
            this.queue.add(newEvent);
            if (newEvent instanceof EndOutputEvent) {
                this.renderNow(this.timeProvider.getCurrentTime());
                this.executor.shutdown();
                return;
            }
            if (this.queue.size() > 1) {
                return;
            }
            long now = this.timeProvider.getCurrentTime();
            if (now - this.lastUpdate >= (long)this.throttleMs) {
                this.renderNow(now);
                return;
            }
            this.executor.schedule(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object object = ThrottlingOutputEventListener.this.lock;
                    synchronized (object) {
                        ThrottlingOutputEventListener.this.renderNow(ThrottlingOutputEventListener.this.timeProvider.getCurrentTime());
                    }
                }
            }, (long)this.throttleMs, TimeUnit.MILLISECONDS);
        }
    }

    private void renderNow(long now) {
        if (this.queue.isEmpty()) {
            return;
        }
        this.listener.onOutput(new ArrayList<OutputEvent>(this.queue));
        this.queue.clear();
        this.lastUpdate = now;
    }
}

