/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal.incremental;

import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.gradle.internal.FileUtils;
import org.gradle.language.nativeplatform.internal.Include;
import org.gradle.language.nativeplatform.internal.IncludeDirectives;
import org.gradle.language.nativeplatform.internal.incremental.ResolvedInclude;
import org.gradle.language.nativeplatform.internal.incremental.SourceIncludesResolver;

public class DefaultSourceIncludesResolver
implements SourceIncludesResolver {
    private final List<File> includePaths;

    public DefaultSourceIncludesResolver(List<File> includePaths) {
        this.includePaths = includePaths;
    }

    @Override
    public SourceIncludesResolver.ResolvedSourceIncludes resolveIncludes(File sourceFile, IncludeDirectives includes) {
        BuildableResolvedSourceIncludes resolvedSourceIncludes = new BuildableResolvedSourceIncludes();
        this.searchForDependencies(this.prependSourceDir(sourceFile, this.includePaths), includes.getQuotedIncludes(), resolvedSourceIncludes);
        this.searchForDependencies(this.includePaths, includes.getSystemIncludes(), resolvedSourceIncludes);
        if (!includes.getMacroIncludes().isEmpty()) {
            resolvedSourceIncludes.resolved(((Include)includes.getMacroIncludes().get(0)).getValue(), null);
        }
        return resolvedSourceIncludes;
    }

    private List<File> prependSourceDir(File sourceFile, List<File> includePaths) {
        ArrayList<File> quotedSearchPath = new ArrayList<File>(includePaths.size() + 1);
        quotedSearchPath.add(sourceFile.getParentFile());
        quotedSearchPath.addAll(includePaths);
        return quotedSearchPath;
    }

    private void searchForDependencies(List<File> searchPath, List<Include> includes, BuildableResolvedSourceIncludes dependencies) {
        for (Include include : includes) {
            this.searchForDependency(searchPath, include.getValue(), dependencies);
        }
    }

    private void searchForDependency(List<File> searchPath, String include, BuildableResolvedSourceIncludes dependencies) {
        for (File searchDir : searchPath) {
            File candidate = new File(searchDir, include);
            if (!candidate.isDirectory()) {
                dependencies.searched(candidate);
            }
            if (!candidate.isFile()) continue;
            dependencies.resolved(include, candidate);
            return;
        }
    }

    private static class BuildableResolvedSourceIncludes
    implements SourceIncludesResolver.ResolvedSourceIncludes {
        private final Set<ResolvedInclude> dependencies = Sets.newLinkedHashSet();
        private final Set<File> candidates = Sets.newLinkedHashSet();

        private BuildableResolvedSourceIncludes() {
        }

        void searched(File candidate) {
            this.candidates.add(candidate);
        }

        void resolved(String rawInclude, File resolved) {
            File dependencyFile = resolved == null ? null : FileUtils.canonicalize((File)resolved);
            this.dependencies.add(new ResolvedInclude(rawInclude, dependencyFile));
        }

        @Override
        public Set<ResolvedInclude> getResolvedIncludes() {
            return this.dependencies;
        }

        @Override
        public Set<File> getCheckedLocations() {
            return this.candidates;
        }
    }
}

