/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.gui.datatransfer.ClipboardUtils;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.OpenBrowser;

public class UrlLabel
extends JLabel
implements MouseListener {
    private String url = "";
    private String description = "";

    public UrlLabel() {
        this.addMouseListener(this);
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    public UrlLabel(String string) {
        this(string, string, 0);
    }

    public UrlLabel(String string, int n) {
        this(string, string, n);
    }

    public UrlLabel(String string, String string2) {
        this(string, string2, 0);
    }

    public UrlLabel(String string, String string2, int n) {
        this();
        this.setUrl(string);
        this.setDescription(string2);
        if (n != 0) {
            this.setFont(this.getFont().deriveFont(0, (float)this.getFont().getSize() + (float)n));
        }
        this.refresh();
    }

    protected final void refresh() {
        if (this.url != null && !this.url.isEmpty()) {
            this.setText("<html><a href=\"" + this.url + "\">" + this.description + "</a></html>");
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.setToolTipText(String.format("<html>%s<br/>%s</html>", this.url, I18n.tr("Right click = copy to clipboard", new Object[0])));
        } else {
            this.setText("<html>" + this.description + "</html>");
            this.setCursor(null);
            this.setToolTipText(null);
        }
    }

    public final void setUrl(String string) {
        this.url = string;
        this.refresh();
    }

    public final void setDescription(String string) {
        this.description = string == null ? "" : string;
        this.description = this.description.replace("&", "&amp;").replace(">", "&gt;").replace("<", "&lt;");
        this.refresh();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.url != null && !this.url.isEmpty()) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                OpenBrowser.displayUrl(this.url);
            } else if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                ClipboardUtils.copyString(this.url);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

