/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JarUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.io.JarUtil");

    @Nullable
    public static String getJarAttribute(@NotNull File file2, @NotNull Attributes.Name attribute) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/io/JarUtil", "getJarAttribute"));
        }
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/intellij/openapi/util/io/JarUtil", "getJarAttribute"));
        }
        return JarUtil.getJarAttributeImpl(file2, null, attribute);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getJarAttributeImpl(@NotNull File file2, @Nullable String entryName, @NotNull Attributes.Name attribute) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/io/JarUtil", "getJarAttributeImpl"));
        }
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/intellij/openapi/util/io/JarUtil", "getJarAttributeImpl"));
        }
        if (!file2.canRead()) return null;
        try {
            JarFile jarFile = new JarFile(file2);
            try {
                Manifest manifest = jarFile.getManifest();
                if (manifest == null) return null;
                Attributes attributes = entryName != null ? manifest.getAttributes(entryName) : manifest.getMainAttributes();
                String string = attributes.getValue(attribute);
                return string;
            }
            finally {
                jarFile.close();
            }
        }
        catch (IOException e) {
            LOG.debug(e);
        }
        return null;
    }
}

