/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.AbstractCommand;
import CH.ifa.draw.standard.ReverseFigureEnumerator;
import CH.ifa.draw.util.Undoable;
import CH.ifa.draw.util.UndoableAdapter;
import java.util.Hashtable;

public class SendToBackCommand
extends AbstractCommand {
    public SendToBackCommand(String name, DrawingEditor newDrawingEditor) {
        super(name, newDrawingEditor);
    }

    public void execute() {
        super.execute();
        this.setUndoActivity(this.createUndoActivity());
        this.getUndoActivity().setAffectedFigures(new ReverseFigureEnumerator(this.view().selectionZOrdered()));
        FigureEnumeration fe = this.getUndoActivity().getAffectedFigures();
        while (fe.hasMoreElements()) {
            this.view().drawing().sendToBack(fe.nextFigure());
        }
        this.view().checkDamage();
    }

    protected boolean isExecutableWithView() {
        return this.view().selectionCount() > 0;
    }

    protected Undoable createUndoActivity() {
        return new UndoActivity(this.view());
    }

    public static class UndoActivity
    extends UndoableAdapter {
        private Hashtable myOriginalLayers = new Hashtable();

        public UndoActivity(DrawingView newDrawingView) {
            super(newDrawingView);
            this.setUndoable(true);
            this.setRedoable(true);
        }

        public boolean undo() {
            if (!super.undo()) {
                return false;
            }
            FigureEnumeration fe = this.getAffectedFigures();
            while (fe.hasMoreElements()) {
                Figure currentFigure = fe.nextFigure();
                int currentFigureLayer = this.getOriginalLayer(currentFigure);
                this.getDrawingView().drawing().sendToLayer(currentFigure, currentFigureLayer);
            }
            return true;
        }

        public boolean redo() {
            if (!this.isRedoable()) {
                return false;
            }
            FigureEnumeration fe = this.getAffectedFigures();
            while (fe.hasMoreElements()) {
                this.sendToCommand(fe.nextFigure());
            }
            return true;
        }

        protected void sendToCommand(Figure f) {
            this.getDrawingView().drawing().sendToBack(f);
        }

        protected void addOriginalLayer(Figure affectedFigure, int newOriginalLayer) {
            this.myOriginalLayers.put(affectedFigure, new Integer(newOriginalLayer));
        }

        protected int getOriginalLayer(Figure lookupAffectedFigure) {
            return (Integer)this.myOriginalLayers.get(lookupAffectedFigure);
        }

        public void setAffectedFigures(FigureEnumeration fe) {
            super.setAffectedFigures(fe);
            FigureEnumeration copyFe = this.getAffectedFigures();
            while (copyFe.hasMoreElements()) {
                Figure f = copyFe.nextFigure();
                int originalLayer = this.getDrawingView().drawing().getLayer(f);
                this.addOriginalLayer(f, originalLayer);
            }
        }
    }
}

