/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.peer.ComponentPeer;
import java.awt.peer.LightweightPeer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.SplitPaneUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.LazyActionMap;
import sun.swing.DefaultLookup;
import sun.swing.SwingUtilities2;
import sun.swing.UIAction;

public class BasicSplitPaneUI
extends SplitPaneUI {
    protected static final String NON_CONTINUOUS_DIVIDER = "nonContinuousDivider";
    protected static int KEYBOARD_DIVIDER_MOVE_OFFSET = 3;
    protected JSplitPane splitPane;
    protected BasicHorizontalLayoutManager layoutManager;
    protected BasicSplitPaneDivider divider;
    protected PropertyChangeListener propertyChangeListener;
    protected FocusListener focusListener;
    private Handler handler;
    private Set<KeyStroke> managingFocusForwardTraversalKeys;
    private Set<KeyStroke> managingFocusBackwardTraversalKeys;
    protected int dividerSize;
    protected Component nonContinuousLayoutDivider;
    protected boolean draggingHW;
    protected int beginDragDividerLocation;
    @Deprecated
    protected KeyStroke upKey;
    @Deprecated
    protected KeyStroke downKey;
    @Deprecated
    protected KeyStroke leftKey;
    @Deprecated
    protected KeyStroke rightKey;
    @Deprecated
    protected KeyStroke homeKey;
    @Deprecated
    protected KeyStroke endKey;
    @Deprecated
    protected KeyStroke dividerResizeToggleKey;
    @Deprecated
    protected ActionListener keyboardUpLeftListener;
    @Deprecated
    protected ActionListener keyboardDownRightListener;
    @Deprecated
    protected ActionListener keyboardHomeListener;
    @Deprecated
    protected ActionListener keyboardEndListener;
    @Deprecated
    protected ActionListener keyboardResizeToggleListener;
    private int orientation;
    private int lastDragLocation;
    private boolean continuousLayout;
    private boolean dividerKeyboardResize;
    private boolean dividerLocationIsSet;
    private Color dividerDraggingColor;
    private boolean rememberPaneSizes;
    private boolean keepHidden = false;
    boolean painted;
    boolean ignoreDividerLocationChange;

    public static ComponentUI createUI(JComponent x) {
        return new BasicSplitPaneUI();
    }

    static void loadActionMap(LazyActionMap map) {
        map.put(new Actions("negativeIncrement"));
        map.put(new Actions("positiveIncrement"));
        map.put(new Actions("selectMin"));
        map.put(new Actions("selectMax"));
        map.put(new Actions("startResize"));
        map.put(new Actions("toggleFocus"));
        map.put(new Actions("focusOutForward"));
        map.put(new Actions("focusOutBackward"));
    }

    @Override
    public void installUI(JComponent c) {
        this.splitPane = (JSplitPane)c;
        this.dividerLocationIsSet = false;
        this.dividerKeyboardResize = false;
        this.keepHidden = false;
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
        this.setLastDragLocation(-1);
    }

    protected void installDefaults() {
        LookAndFeel.installBorder(this.splitPane, "SplitPane.border");
        LookAndFeel.installColors(this.splitPane, "SplitPane.background", "SplitPane.foreground");
        LookAndFeel.installProperty(this.splitPane, "opaque", Boolean.TRUE);
        if (this.divider == null) {
            this.divider = this.createDefaultDivider();
        }
        this.divider.setBasicSplitPaneUI(this);
        Border b = this.divider.getBorder();
        if (b == null || !(b instanceof UIResource)) {
            this.divider.setBorder(UIManager.getBorder("SplitPaneDivider.border"));
        }
        this.dividerDraggingColor = UIManager.getColor("SplitPaneDivider.draggingColor");
        this.setOrientation(this.splitPane.getOrientation());
        Integer temp = (Integer)UIManager.get("SplitPane.dividerSize");
        LookAndFeel.installProperty(this.splitPane, "dividerSize", temp == null ? 10 : temp);
        this.divider.setDividerSize(this.splitPane.getDividerSize());
        this.dividerSize = this.divider.getDividerSize();
        this.splitPane.add((Component)this.divider, "divider");
        this.setContinuousLayout(this.splitPane.isContinuousLayout());
        this.resetLayoutManager();
        if (this.nonContinuousLayoutDivider == null) {
            this.setNonContinuousLayoutDivider(this.createDefaultNonContinuousLayoutDivider(), true);
        } else {
            this.setNonContinuousLayoutDivider(this.nonContinuousLayoutDivider, true);
        }
        if (this.managingFocusForwardTraversalKeys == null) {
            this.managingFocusForwardTraversalKeys = new HashSet<KeyStroke>();
            this.managingFocusForwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 0));
        }
        this.splitPane.setFocusTraversalKeys(0, this.managingFocusForwardTraversalKeys);
        if (this.managingFocusBackwardTraversalKeys == null) {
            this.managingFocusBackwardTraversalKeys = new HashSet<KeyStroke>();
            this.managingFocusBackwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 1));
        }
        this.splitPane.setFocusTraversalKeys(1, this.managingFocusBackwardTraversalKeys);
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        if (this.propertyChangeListener != null) {
            this.splitPane.addPropertyChangeListener(this.propertyChangeListener);
        }
        if ((this.focusListener = this.createFocusListener()) != null) {
            this.splitPane.addFocusListener(this.focusListener);
        }
    }

    protected void installKeyboardActions() {
        InputMap km = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.splitPane, 1, km);
        LazyActionMap.installLazyActionMap(this.splitPane, BasicSplitPaneUI.class, "SplitPane.actionMap");
    }

    InputMap getInputMap(int condition) {
        if (condition == 1) {
            return (InputMap)DefaultLookup.get(this.splitPane, this, "SplitPane.ancestorInputMap");
        }
        return null;
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.dividerLocationIsSet = false;
        this.dividerKeyboardResize = false;
        this.splitPane = null;
    }

    protected void uninstallDefaults() {
        if (this.splitPane.getLayout() == this.layoutManager) {
            this.splitPane.setLayout(null);
        }
        if (this.nonContinuousLayoutDivider != null) {
            this.splitPane.remove(this.nonContinuousLayoutDivider);
        }
        LookAndFeel.uninstallBorder(this.splitPane);
        Border b = this.divider.getBorder();
        if (b instanceof UIResource) {
            this.divider.setBorder(null);
        }
        this.splitPane.remove(this.divider);
        this.divider.setBasicSplitPaneUI(null);
        this.layoutManager = null;
        this.divider = null;
        this.nonContinuousLayoutDivider = null;
        this.setNonContinuousLayoutDivider(null);
        this.splitPane.setFocusTraversalKeys(0, null);
        this.splitPane.setFocusTraversalKeys(1, null);
    }

    protected void uninstallListeners() {
        if (this.propertyChangeListener != null) {
            this.splitPane.removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
        if (this.focusListener != null) {
            this.splitPane.removeFocusListener(this.focusListener);
            this.focusListener = null;
        }
        this.keyboardUpLeftListener = null;
        this.keyboardDownRightListener = null;
        this.keyboardHomeListener = null;
        this.keyboardEndListener = null;
        this.keyboardResizeToggleListener = null;
        this.handler = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.splitPane, null);
        SwingUtilities.replaceUIInputMap(this.splitPane, 1, null);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return this.getHandler();
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    protected FocusListener createFocusListener() {
        return this.getHandler();
    }

    @Deprecated
    protected ActionListener createKeyboardUpLeftListener() {
        return new KeyboardUpLeftHandler();
    }

    @Deprecated
    protected ActionListener createKeyboardDownRightListener() {
        return new KeyboardDownRightHandler();
    }

    @Deprecated
    protected ActionListener createKeyboardHomeListener() {
        return new KeyboardHomeHandler();
    }

    @Deprecated
    protected ActionListener createKeyboardEndListener() {
        return new KeyboardEndHandler();
    }

    @Deprecated
    protected ActionListener createKeyboardResizeToggleListener() {
        return new KeyboardResizeToggleHandler();
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public boolean isContinuousLayout() {
        return this.continuousLayout;
    }

    public void setContinuousLayout(boolean b) {
        this.continuousLayout = b;
    }

    public int getLastDragLocation() {
        return this.lastDragLocation;
    }

    public void setLastDragLocation(int l) {
        this.lastDragLocation = l;
    }

    int getKeyboardMoveIncrement() {
        return 3;
    }

    public BasicSplitPaneDivider getDivider() {
        return this.divider;
    }

    protected Component createDefaultNonContinuousLayoutDivider() {
        return new Canvas(){

            @Override
            public void paint(Graphics g) {
                if (!BasicSplitPaneUI.this.isContinuousLayout() && BasicSplitPaneUI.this.getLastDragLocation() != -1) {
                    Dimension size = BasicSplitPaneUI.this.splitPane.getSize();
                    g.setColor(BasicSplitPaneUI.this.dividerDraggingColor);
                    if (BasicSplitPaneUI.this.orientation == 1) {
                        g.fillRect(0, 0, BasicSplitPaneUI.this.dividerSize - 1, size.height - 1);
                    } else {
                        g.fillRect(0, 0, size.width - 1, BasicSplitPaneUI.this.dividerSize - 1);
                    }
                }
            }
        };
    }

    protected void setNonContinuousLayoutDivider(Component newDivider) {
        this.setNonContinuousLayoutDivider(newDivider, true);
    }

    protected void setNonContinuousLayoutDivider(Component newDivider, boolean rememberSizes) {
        this.rememberPaneSizes = rememberSizes;
        if (this.nonContinuousLayoutDivider != null && this.splitPane != null) {
            this.splitPane.remove(this.nonContinuousLayoutDivider);
        }
        this.nonContinuousLayoutDivider = newDivider;
    }

    private void addHeavyweightDivider() {
        if (this.nonContinuousLayoutDivider != null && this.splitPane != null) {
            Component leftC = this.splitPane.getLeftComponent();
            Component rightC = this.splitPane.getRightComponent();
            int lastLocation = this.splitPane.getDividerLocation();
            if (leftC != null) {
                this.splitPane.setLeftComponent(null);
            }
            if (rightC != null) {
                this.splitPane.setRightComponent(null);
            }
            this.splitPane.remove(this.divider);
            this.splitPane.add(this.nonContinuousLayoutDivider, NON_CONTINUOUS_DIVIDER, this.splitPane.getComponentCount());
            this.splitPane.setLeftComponent(leftC);
            this.splitPane.setRightComponent(rightC);
            this.splitPane.add((Component)this.divider, "divider");
            if (this.rememberPaneSizes) {
                this.splitPane.setDividerLocation(lastLocation);
            }
        }
    }

    public Component getNonContinuousLayoutDivider() {
        return this.nonContinuousLayoutDivider;
    }

    public JSplitPane getSplitPane() {
        return this.splitPane;
    }

    public BasicSplitPaneDivider createDefaultDivider() {
        return new BasicSplitPaneDivider(this);
    }

    @Override
    public void resetToPreferredSizes(JSplitPane jc) {
        if (this.splitPane != null) {
            this.layoutManager.resetToPreferredSizes();
            this.splitPane.revalidate();
            this.splitPane.repaint();
        }
    }

    @Override
    public void setDividerLocation(JSplitPane jc, int location) {
        if (!this.ignoreDividerLocationChange) {
            this.dividerLocationIsSet = true;
            this.splitPane.revalidate();
            this.splitPane.repaint();
            if (this.keepHidden) {
                Insets insets = this.splitPane.getInsets();
                int orientation = this.splitPane.getOrientation();
                if (orientation == 0 && location != insets.top && location != this.splitPane.getHeight() - this.divider.getHeight() - insets.top || orientation == 1 && location != insets.left && location != this.splitPane.getWidth() - this.divider.getWidth() - insets.left) {
                    this.setKeepHidden(false);
                }
            }
        } else {
            this.ignoreDividerLocationChange = false;
        }
    }

    @Override
    public int getDividerLocation(JSplitPane jc) {
        if (this.orientation == 1) {
            return this.divider.getLocation().x;
        }
        return this.divider.getLocation().y;
    }

    @Override
    public int getMinimumDividerLocation(JSplitPane jc) {
        int minLoc = 0;
        Component leftC = this.splitPane.getLeftComponent();
        if (leftC != null && leftC.isVisible()) {
            Insets insets = this.splitPane.getInsets();
            Dimension minSize = leftC.getMinimumSize();
            minLoc = this.orientation == 1 ? minSize.width : minSize.height;
            if (insets != null) {
                minLoc = this.orientation == 1 ? (minLoc += insets.left) : (minLoc += insets.top);
            }
        }
        return minLoc;
    }

    @Override
    public int getMaximumDividerLocation(JSplitPane jc) {
        Dimension splitPaneSize = this.splitPane.getSize();
        int maxLoc = 0;
        Component rightC = this.splitPane.getRightComponent();
        if (rightC != null) {
            Insets insets = this.splitPane.getInsets();
            Dimension minSize = new Dimension(0, 0);
            if (rightC.isVisible()) {
                minSize = rightC.getMinimumSize();
            }
            maxLoc = this.orientation == 1 ? splitPaneSize.width - minSize.width : splitPaneSize.height - minSize.height;
            maxLoc -= this.dividerSize;
            if (insets != null) {
                maxLoc = this.orientation == 1 ? (maxLoc -= insets.right) : (maxLoc -= insets.top);
            }
        }
        return Math.max(this.getMinimumDividerLocation(this.splitPane), maxLoc);
    }

    @Override
    public void finishedPaintingChildren(JSplitPane sp, Graphics g) {
        if (sp == this.splitPane && this.getLastDragLocation() != -1 && !this.isContinuousLayout() && !this.draggingHW) {
            Dimension size = this.splitPane.getSize();
            g.setColor(this.dividerDraggingColor);
            if (this.orientation == 1) {
                g.fillRect(this.getLastDragLocation(), 0, this.dividerSize - 1, size.height - 1);
            } else {
                g.fillRect(0, this.lastDragLocation, size.width - 1, this.dividerSize - 1);
            }
        }
    }

    @Override
    public void paint(Graphics g, JComponent jc) {
        if (!this.painted && this.splitPane.getDividerLocation() < 0) {
            this.ignoreDividerLocationChange = true;
            this.splitPane.setDividerLocation(this.getDividerLocation(this.splitPane));
        }
        this.painted = true;
    }

    @Override
    public Dimension getPreferredSize(JComponent jc) {
        if (this.splitPane != null) {
            return this.layoutManager.preferredLayoutSize(this.splitPane);
        }
        return new Dimension(0, 0);
    }

    @Override
    public Dimension getMinimumSize(JComponent jc) {
        if (this.splitPane != null) {
            return this.layoutManager.minimumLayoutSize(this.splitPane);
        }
        return new Dimension(0, 0);
    }

    @Override
    public Dimension getMaximumSize(JComponent jc) {
        if (this.splitPane != null) {
            return this.layoutManager.maximumLayoutSize(this.splitPane);
        }
        return new Dimension(0, 0);
    }

    public Insets getInsets(JComponent jc) {
        return null;
    }

    protected void resetLayoutManager() {
        this.layoutManager = this.orientation == 1 ? new BasicHorizontalLayoutManager(0) : new BasicHorizontalLayoutManager(1);
        this.splitPane.setLayout(this.layoutManager);
        this.layoutManager.updateComponents();
        this.splitPane.revalidate();
        this.splitPane.repaint();
    }

    void setKeepHidden(boolean keepHidden) {
        this.keepHidden = keepHidden;
    }

    private boolean getKeepHidden() {
        return this.keepHidden;
    }

    protected void startDragging() {
        ComponentPeer cPeer;
        Component leftC = this.splitPane.getLeftComponent();
        Component rightC = this.splitPane.getRightComponent();
        this.beginDragDividerLocation = this.getDividerLocation(this.splitPane);
        this.draggingHW = false;
        if (leftC != null && (cPeer = leftC.getPeer()) != null && !(cPeer instanceof LightweightPeer)) {
            this.draggingHW = true;
        } else if (rightC != null && (cPeer = rightC.getPeer()) != null && !(cPeer instanceof LightweightPeer)) {
            this.draggingHW = true;
        }
        if (this.orientation == 1) {
            this.setLastDragLocation(this.divider.getBounds().x);
            this.dividerSize = this.divider.getSize().width;
            if (!this.isContinuousLayout() && this.draggingHW) {
                this.nonContinuousLayoutDivider.setBounds(this.getLastDragLocation(), 0, this.dividerSize, this.splitPane.getHeight());
                this.addHeavyweightDivider();
            }
        } else {
            this.setLastDragLocation(this.divider.getBounds().y);
            this.dividerSize = this.divider.getSize().height;
            if (!this.isContinuousLayout() && this.draggingHW) {
                this.nonContinuousLayoutDivider.setBounds(0, this.getLastDragLocation(), this.splitPane.getWidth(), this.dividerSize);
                this.addHeavyweightDivider();
            }
        }
    }

    protected void dragDividerTo(int location) {
        if (this.getLastDragLocation() != location) {
            if (this.isContinuousLayout()) {
                this.splitPane.setDividerLocation(location);
                this.setLastDragLocation(location);
            } else {
                int lastLoc = this.getLastDragLocation();
                this.setLastDragLocation(location);
                if (this.orientation == 1) {
                    if (this.draggingHW) {
                        this.nonContinuousLayoutDivider.setLocation(this.getLastDragLocation(), 0);
                    } else {
                        int splitHeight = this.splitPane.getHeight();
                        this.splitPane.repaint(lastLoc, 0, this.dividerSize, splitHeight);
                        this.splitPane.repaint(location, 0, this.dividerSize, splitHeight);
                    }
                } else if (this.draggingHW) {
                    this.nonContinuousLayoutDivider.setLocation(0, this.getLastDragLocation());
                } else {
                    int splitWidth = this.splitPane.getWidth();
                    this.splitPane.repaint(0, lastLoc, splitWidth, this.dividerSize);
                    this.splitPane.repaint(0, location, splitWidth, this.dividerSize);
                }
            }
        }
    }

    protected void finishDraggingTo(int location) {
        this.dragDividerTo(location);
        this.setLastDragLocation(-1);
        if (!this.isContinuousLayout()) {
            Component leftC = this.splitPane.getLeftComponent();
            Rectangle leftBounds = leftC.getBounds();
            if (this.draggingHW) {
                if (this.orientation == 1) {
                    this.nonContinuousLayoutDivider.setLocation(-this.dividerSize, 0);
                } else {
                    this.nonContinuousLayoutDivider.setLocation(0, -this.dividerSize);
                }
                this.splitPane.remove(this.nonContinuousLayoutDivider);
            }
            this.splitPane.setDividerLocation(location);
        }
    }

    @Deprecated
    protected int getDividerBorderSize() {
        return 1;
    }

    private static class Actions
    extends UIAction {
        private static final String NEGATIVE_INCREMENT = "negativeIncrement";
        private static final String POSITIVE_INCREMENT = "positiveIncrement";
        private static final String SELECT_MIN = "selectMin";
        private static final String SELECT_MAX = "selectMax";
        private static final String START_RESIZE = "startResize";
        private static final String TOGGLE_FOCUS = "toggleFocus";
        private static final String FOCUS_OUT_FORWARD = "focusOutForward";
        private static final String FOCUS_OUT_BACKWARD = "focusOutBackward";

        Actions(String key) {
            super(key);
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            JSplitPane splitPane = (JSplitPane)ev.getSource();
            BasicSplitPaneUI ui = (BasicSplitPaneUI)BasicLookAndFeel.getUIOfType(splitPane.getUI(), BasicSplitPaneUI.class);
            if (ui == null) {
                return;
            }
            String key = this.getName();
            if (key == NEGATIVE_INCREMENT) {
                if (ui.dividerKeyboardResize) {
                    splitPane.setDividerLocation(Math.max(0, ui.getDividerLocation(splitPane) - ui.getKeyboardMoveIncrement()));
                }
            } else if (key == POSITIVE_INCREMENT) {
                if (ui.dividerKeyboardResize) {
                    splitPane.setDividerLocation(ui.getDividerLocation(splitPane) + ui.getKeyboardMoveIncrement());
                }
            } else if (key == SELECT_MIN) {
                if (ui.dividerKeyboardResize) {
                    splitPane.setDividerLocation(0);
                }
            } else if (key == SELECT_MAX) {
                if (ui.dividerKeyboardResize) {
                    int rightI;
                    Insets insets = splitPane.getInsets();
                    int bottomI = insets != null ? insets.bottom : 0;
                    int n = rightI = insets != null ? insets.right : 0;
                    if (ui.orientation == 0) {
                        splitPane.setDividerLocation(splitPane.getHeight() - bottomI);
                    } else {
                        splitPane.setDividerLocation(splitPane.getWidth() - rightI);
                    }
                }
            } else if (key == START_RESIZE) {
                if (!ui.dividerKeyboardResize) {
                    splitPane.requestFocus();
                } else {
                    JSplitPane parentSplitPane = (JSplitPane)SwingUtilities.getAncestorOfClass(JSplitPane.class, splitPane);
                    if (parentSplitPane != null) {
                        parentSplitPane.requestFocus();
                    }
                }
            } else if (key == TOGGLE_FOCUS) {
                this.toggleFocus(splitPane);
            } else if (key == FOCUS_OUT_FORWARD) {
                this.moveFocus(splitPane, 1);
            } else if (key == FOCUS_OUT_BACKWARD) {
                this.moveFocus(splitPane, -1);
            }
        }

        private void moveFocus(JSplitPane splitPane, int direction) {
            Container rootAncestor = splitPane.getFocusCycleRootAncestor();
            FocusTraversalPolicy policy = rootAncestor.getFocusTraversalPolicy();
            Component focusOn = direction > 0 ? policy.getComponentAfter(rootAncestor, splitPane) : policy.getComponentBefore(rootAncestor, splitPane);
            HashSet<Component> focusFrom = new HashSet<Component>();
            if (splitPane.isAncestorOf(focusOn)) {
                do {
                    focusFrom.add(focusOn);
                    rootAncestor = focusOn.getFocusCycleRootAncestor();
                    policy = rootAncestor.getFocusTraversalPolicy();
                    Component component = focusOn = direction > 0 ? policy.getComponentAfter(rootAncestor, focusOn) : policy.getComponentBefore(rootAncestor, focusOn);
                } while (splitPane.isAncestorOf(focusOn) && !focusFrom.contains(focusOn));
            }
            if (focusOn != null && !splitPane.isAncestorOf(focusOn)) {
                focusOn.requestFocus();
            }
        }

        private void toggleFocus(JSplitPane splitPane) {
            Component left = splitPane.getLeftComponent();
            Component right = splitPane.getRightComponent();
            KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            Component focus = manager.getFocusOwner();
            Component focusOn = this.getNextSide(splitPane, focus);
            if (focusOn != null) {
                if (focus != null && (SwingUtilities.isDescendingFrom(focus, left) && SwingUtilities.isDescendingFrom(focusOn, left) || SwingUtilities.isDescendingFrom(focus, right) && SwingUtilities.isDescendingFrom(focusOn, right))) {
                    return;
                }
                SwingUtilities2.compositeRequestFocus(focusOn);
            }
        }

        private Component getNextSide(JSplitPane splitPane, Component focus) {
            Component next;
            Component left = splitPane.getLeftComponent();
            Component right = splitPane.getRightComponent();
            if (focus != null && SwingUtilities.isDescendingFrom(focus, left) && right != null && (next = this.getFirstAvailableComponent(right)) != null) {
                return next;
            }
            JSplitPane parentSplitPane = (JSplitPane)SwingUtilities.getAncestorOfClass(JSplitPane.class, splitPane);
            if (parentSplitPane != null) {
                next = this.getNextSide(parentSplitPane, focus);
            } else {
                next = this.getFirstAvailableComponent(left);
                if (next == null) {
                    next = this.getFirstAvailableComponent(right);
                }
            }
            return next;
        }

        private Component getFirstAvailableComponent(Component c) {
            if (c != null && c instanceof JSplitPane) {
                JSplitPane sp = (JSplitPane)c;
                Component left = this.getFirstAvailableComponent(sp.getLeftComponent());
                c = left != null ? left : this.getFirstAvailableComponent(sp.getRightComponent());
            }
            return c;
        }
    }

    private class Handler
    implements FocusListener,
    PropertyChangeListener {
        private Handler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getSource() == BasicSplitPaneUI.this.splitPane) {
                String changeName = e.getPropertyName();
                if (changeName == "orientation") {
                    BasicSplitPaneUI.this.orientation = BasicSplitPaneUI.this.splitPane.getOrientation();
                    BasicSplitPaneUI.this.resetLayoutManager();
                } else if (changeName == "continuousLayout") {
                    BasicSplitPaneUI.this.setContinuousLayout(BasicSplitPaneUI.this.splitPane.isContinuousLayout());
                    if (!BasicSplitPaneUI.this.isContinuousLayout()) {
                        if (BasicSplitPaneUI.this.nonContinuousLayoutDivider == null) {
                            BasicSplitPaneUI.this.setNonContinuousLayoutDivider(BasicSplitPaneUI.this.createDefaultNonContinuousLayoutDivider(), true);
                        } else if (BasicSplitPaneUI.this.nonContinuousLayoutDivider.getParent() == null) {
                            BasicSplitPaneUI.this.setNonContinuousLayoutDivider(BasicSplitPaneUI.this.nonContinuousLayoutDivider, true);
                        }
                    }
                } else if (changeName == "dividerSize") {
                    BasicSplitPaneUI.this.divider.setDividerSize(BasicSplitPaneUI.this.splitPane.getDividerSize());
                    BasicSplitPaneUI.this.dividerSize = BasicSplitPaneUI.this.divider.getDividerSize();
                    BasicSplitPaneUI.this.splitPane.revalidate();
                    BasicSplitPaneUI.this.splitPane.repaint();
                }
            }
        }

        @Override
        public void focusGained(FocusEvent ev) {
            BasicSplitPaneUI.this.dividerKeyboardResize = true;
            BasicSplitPaneUI.this.splitPane.repaint();
        }

        @Override
        public void focusLost(FocusEvent ev) {
            BasicSplitPaneUI.this.dividerKeyboardResize = false;
            BasicSplitPaneUI.this.splitPane.repaint();
        }
    }

    public class BasicVerticalLayoutManager
    extends BasicHorizontalLayoutManager {
        public BasicVerticalLayoutManager() {
            super(1);
        }
    }

    public class BasicHorizontalLayoutManager
    implements LayoutManager2 {
        protected int[] sizes;
        protected Component[] components;
        private int lastSplitPaneSize;
        private boolean doReset;
        private int axis;

        BasicHorizontalLayoutManager() {
            this(0);
        }

        BasicHorizontalLayoutManager(int axis) {
            this.axis = axis;
            this.components = new Component[3];
            this.components[2] = null;
            this.components[1] = null;
            this.components[0] = null;
            this.sizes = new int[3];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container container) {
            int newLocation;
            Dimension dSize;
            Dimension containerSize = container.getSize();
            if (containerSize.height <= 0 || containerSize.width <= 0) {
                this.lastSplitPaneSize = 0;
                return;
            }
            int spDividerLocation = BasicSplitPaneUI.this.splitPane.getDividerLocation();
            Insets insets = BasicSplitPaneUI.this.splitPane.getInsets();
            int availableSize = this.getAvailableSize(containerSize, insets);
            int newSize = this.getSizeForPrimaryAxis(containerSize);
            int beginLocation = BasicSplitPaneUI.this.getDividerLocation(BasicSplitPaneUI.this.splitPane);
            int dOffset = this.getSizeForPrimaryAxis(insets, true);
            Dimension dimension = dSize = this.components[2] == null ? null : this.components[2].getPreferredSize();
            if (this.doReset && !BasicSplitPaneUI.this.dividerLocationIsSet || spDividerLocation < 0) {
                this.resetToPreferredSizes(availableSize);
            } else if (this.lastSplitPaneSize <= 0 || availableSize == this.lastSplitPaneSize || !BasicSplitPaneUI.this.painted || dSize != null && this.getSizeForPrimaryAxis(dSize) != this.sizes[2]) {
                this.sizes[2] = dSize != null ? this.getSizeForPrimaryAxis(dSize) : 0;
                this.setDividerLocation(spDividerLocation - dOffset, availableSize);
                BasicSplitPaneUI.this.dividerLocationIsSet = false;
            } else if (availableSize != this.lastSplitPaneSize) {
                this.distributeSpace(availableSize - this.lastSplitPaneSize, BasicSplitPaneUI.this.getKeepHidden());
            }
            this.doReset = false;
            BasicSplitPaneUI.this.dividerLocationIsSet = false;
            this.lastSplitPaneSize = availableSize;
            int nextLocation = this.getInitialLocation(insets);
            int counter = 0;
            while (counter < 3) {
                if (this.components[counter] != null && this.components[counter].isVisible()) {
                    this.setComponentToSize(this.components[counter], this.sizes[counter], nextLocation, insets, containerSize);
                    nextLocation += this.sizes[counter];
                }
                switch (counter) {
                    case 0: {
                        counter = 2;
                        break;
                    }
                    case 2: {
                        counter = 1;
                        break;
                    }
                    case 1: {
                        counter = 3;
                    }
                }
            }
            if (BasicSplitPaneUI.this.painted && (newLocation = BasicSplitPaneUI.this.getDividerLocation(BasicSplitPaneUI.this.splitPane)) != spDividerLocation - dOffset) {
                int lastLocation = BasicSplitPaneUI.this.splitPane.getLastDividerLocation();
                BasicSplitPaneUI.this.ignoreDividerLocationChange = true;
                try {
                    BasicSplitPaneUI.this.splitPane.setDividerLocation(newLocation);
                    BasicSplitPaneUI.this.splitPane.setLastDividerLocation(lastLocation);
                }
                finally {
                    BasicSplitPaneUI.this.ignoreDividerLocationChange = false;
                }
            }
        }

        @Override
        public void addLayoutComponent(String place, Component component) {
            boolean isValid = true;
            if (place != null) {
                if (place.equals("divider")) {
                    this.components[2] = component;
                    this.sizes[2] = this.getSizeForPrimaryAxis(component.getPreferredSize());
                } else if (place.equals("left") || place.equals("top")) {
                    this.components[0] = component;
                    this.sizes[0] = 0;
                } else if (place.equals("right") || place.equals("bottom")) {
                    this.components[1] = component;
                    this.sizes[1] = 0;
                } else if (!place.equals(BasicSplitPaneUI.NON_CONTINUOUS_DIVIDER)) {
                    isValid = false;
                }
            } else {
                isValid = false;
            }
            if (!isValid) {
                throw new IllegalArgumentException("cannot add to layout: unknown constraint: " + place);
            }
            this.doReset = true;
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            int minPrimary = 0;
            int minSecondary = 0;
            Insets insets = BasicSplitPaneUI.this.splitPane.getInsets();
            for (int counter = 0; counter < 3; ++counter) {
                if (this.components[counter] == null) continue;
                Dimension minSize = this.components[counter].getMinimumSize();
                int secSize = this.getSizeForSecondaryAxis(minSize);
                minPrimary += this.getSizeForPrimaryAxis(minSize);
                if (secSize <= minSecondary) continue;
                minSecondary = secSize;
            }
            if (insets != null) {
                minPrimary += this.getSizeForPrimaryAxis(insets, true) + this.getSizeForPrimaryAxis(insets, false);
                minSecondary += this.getSizeForSecondaryAxis(insets, true) + this.getSizeForSecondaryAxis(insets, false);
            }
            if (this.axis == 0) {
                return new Dimension(minPrimary, minSecondary);
            }
            return new Dimension(minSecondary, minPrimary);
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            int prePrimary = 0;
            int preSecondary = 0;
            Insets insets = BasicSplitPaneUI.this.splitPane.getInsets();
            for (int counter = 0; counter < 3; ++counter) {
                if (this.components[counter] == null) continue;
                Dimension preSize = this.components[counter].getPreferredSize();
                int secSize = this.getSizeForSecondaryAxis(preSize);
                prePrimary += this.getSizeForPrimaryAxis(preSize);
                if (secSize <= preSecondary) continue;
                preSecondary = secSize;
            }
            if (insets != null) {
                prePrimary += this.getSizeForPrimaryAxis(insets, true) + this.getSizeForPrimaryAxis(insets, false);
                preSecondary += this.getSizeForSecondaryAxis(insets, true) + this.getSizeForSecondaryAxis(insets, false);
            }
            if (this.axis == 0) {
                return new Dimension(prePrimary, preSecondary);
            }
            return new Dimension(preSecondary, prePrimary);
        }

        @Override
        public void removeLayoutComponent(Component component) {
            for (int counter = 0; counter < 3; ++counter) {
                if (this.components[counter] != component) continue;
                this.components[counter] = null;
                this.sizes[counter] = 0;
                this.doReset = true;
            }
        }

        @Override
        public void addLayoutComponent(Component comp, Object constraints) {
            if (constraints != null && !(constraints instanceof String)) {
                throw new IllegalArgumentException("cannot add to layout: constraint must be a string (or null)");
            }
            this.addLayoutComponent((String)constraints, comp);
        }

        @Override
        public float getLayoutAlignmentX(Container target) {
            return 0.0f;
        }

        @Override
        public float getLayoutAlignmentY(Container target) {
            return 0.0f;
        }

        @Override
        public void invalidateLayout(Container c) {
        }

        @Override
        public Dimension maximumLayoutSize(Container target) {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        public void resetToPreferredSizes() {
            this.doReset = true;
        }

        protected void resetSizeAt(int index) {
            this.sizes[index] = 0;
            this.doReset = true;
        }

        protected void setSizes(int[] newSizes) {
            System.arraycopy(newSizes, 0, this.sizes, 0, 3);
        }

        protected int[] getSizes() {
            int[] retSizes = new int[3];
            System.arraycopy(this.sizes, 0, retSizes, 0, 3);
            return retSizes;
        }

        protected int getPreferredSizeOfComponent(Component c) {
            return this.getSizeForPrimaryAxis(c.getPreferredSize());
        }

        int getMinimumSizeOfComponent(Component c) {
            return this.getSizeForPrimaryAxis(c.getMinimumSize());
        }

        protected int getSizeOfComponent(Component c) {
            return this.getSizeForPrimaryAxis(c.getSize());
        }

        protected int getAvailableSize(Dimension containerSize, Insets insets) {
            if (insets == null) {
                return this.getSizeForPrimaryAxis(containerSize);
            }
            return this.getSizeForPrimaryAxis(containerSize) - (this.getSizeForPrimaryAxis(insets, true) + this.getSizeForPrimaryAxis(insets, false));
        }

        protected int getInitialLocation(Insets insets) {
            if (insets != null) {
                return this.getSizeForPrimaryAxis(insets, true);
            }
            return 0;
        }

        protected void setComponentToSize(Component c, int size, int location, Insets insets, Dimension containerSize) {
            if (insets != null) {
                if (this.axis == 0) {
                    c.setBounds(location, insets.top, size, containerSize.height - (insets.top + insets.bottom));
                } else {
                    c.setBounds(insets.left, location, containerSize.width - (insets.left + insets.right), size);
                }
            } else if (this.axis == 0) {
                c.setBounds(location, 0, size, containerSize.height);
            } else {
                c.setBounds(0, location, containerSize.width, size);
            }
        }

        int getSizeForPrimaryAxis(Dimension size) {
            if (this.axis == 0) {
                return size.width;
            }
            return size.height;
        }

        int getSizeForSecondaryAxis(Dimension size) {
            if (this.axis == 0) {
                return size.height;
            }
            return size.width;
        }

        int getSizeForPrimaryAxis(Insets insets, boolean isTop) {
            if (this.axis == 0) {
                if (isTop) {
                    return insets.left;
                }
                return insets.right;
            }
            if (isTop) {
                return insets.top;
            }
            return insets.bottom;
        }

        int getSizeForSecondaryAxis(Insets insets, boolean isTop) {
            if (this.axis == 0) {
                if (isTop) {
                    return insets.top;
                }
                return insets.bottom;
            }
            if (isTop) {
                return insets.left;
            }
            return insets.right;
        }

        protected void updateComponents() {
            Component comp = BasicSplitPaneUI.this.splitPane.getLeftComponent();
            if (this.components[0] != comp) {
                this.components[0] = comp;
                this.sizes[0] = comp == null ? 0 : -1;
            }
            if (this.components[1] != (comp = BasicSplitPaneUI.this.splitPane.getRightComponent())) {
                this.components[1] = comp;
                this.sizes[1] = comp == null ? 0 : -1;
            }
            Component[] children = BasicSplitPaneUI.this.splitPane.getComponents();
            Component oldDivider = this.components[2];
            this.components[2] = null;
            for (int counter = children.length - 1; counter >= 0; --counter) {
                if (children[counter] == this.components[0] || children[counter] == this.components[1] || children[counter] == BasicSplitPaneUI.this.nonContinuousLayoutDivider) continue;
                if (oldDivider != children[counter]) {
                    this.components[2] = children[counter];
                    break;
                }
                this.components[2] = oldDivider;
                break;
            }
            this.sizes[2] = this.components[2] == null ? 0 : this.getSizeForPrimaryAxis(this.components[2].getPreferredSize());
        }

        void setDividerLocation(int leftSize, int availableSize) {
            boolean lValid = this.components[0] != null && this.components[0].isVisible();
            boolean rValid = this.components[1] != null && this.components[1].isVisible();
            boolean dValid = this.components[2] != null && this.components[2].isVisible();
            int max = availableSize;
            if (dValid) {
                max -= this.sizes[2];
            }
            leftSize = Math.max(0, Math.min(leftSize, max));
            if (lValid) {
                if (rValid) {
                    this.sizes[0] = leftSize;
                    this.sizes[1] = max - leftSize;
                } else {
                    this.sizes[0] = max;
                    this.sizes[1] = 0;
                }
            } else if (rValid) {
                this.sizes[1] = max;
                this.sizes[0] = 0;
            }
        }

        int[] getPreferredSizes() {
            int[] retValue = new int[3];
            for (int counter = 0; counter < 3; ++counter) {
                retValue[counter] = this.components[counter] != null && this.components[counter].isVisible() ? this.getPreferredSizeOfComponent(this.components[counter]) : -1;
            }
            return retValue;
        }

        int[] getMinimumSizes() {
            int[] retValue = new int[3];
            for (int counter = 0; counter < 2; ++counter) {
                retValue[counter] = this.components[counter] != null && this.components[counter].isVisible() ? this.getMinimumSizeOfComponent(this.components[counter]) : -1;
            }
            retValue[2] = this.components[2] != null ? this.getMinimumSizeOfComponent(this.components[2]) : -1;
            return retValue;
        }

        void resetToPreferredSizes(int availableSize) {
            int counter;
            int[] testSizes = this.getPreferredSizes();
            int totalSize = 0;
            for (counter = 0; counter < 3; ++counter) {
                if (testSizes[counter] == -1) continue;
                totalSize += testSizes[counter];
            }
            if (totalSize > availableSize) {
                testSizes = this.getMinimumSizes();
                totalSize = 0;
                for (counter = 0; counter < 3; ++counter) {
                    if (testSizes[counter] == -1) continue;
                    totalSize += testSizes[counter];
                }
            }
            this.setSizes(testSizes);
            this.distributeSpace(availableSize - totalSize, false);
        }

        void distributeSpace(int space, boolean keepHidden) {
            boolean rValid;
            boolean lValid = this.components[0] != null && this.components[0].isVisible();
            boolean bl = rValid = this.components[1] != null && this.components[1].isVisible();
            if (keepHidden) {
                if (lValid && this.getSizeForPrimaryAxis(this.components[0].getSize()) == 0) {
                    lValid = false;
                    if (rValid && this.getSizeForPrimaryAxis(this.components[1].getSize()) == 0) {
                        lValid = true;
                    }
                } else if (rValid && this.getSizeForPrimaryAxis(this.components[1].getSize()) == 0) {
                    rValid = false;
                }
            }
            if (lValid && rValid) {
                boolean rMinValid;
                double weight = BasicSplitPaneUI.this.splitPane.getResizeWeight();
                int lExtra = (int)(weight * (double)space);
                int rExtra = space - lExtra;
                this.sizes[0] = this.sizes[0] + lExtra;
                this.sizes[1] = this.sizes[1] + rExtra;
                int lMin = this.getMinimumSizeOfComponent(this.components[0]);
                int rMin = this.getMinimumSizeOfComponent(this.components[1]);
                boolean lMinValid = this.sizes[0] >= lMin;
                boolean bl2 = rMinValid = this.sizes[1] >= rMin;
                if (!lMinValid && !rMinValid) {
                    if (this.sizes[0] < 0) {
                        this.sizes[1] = this.sizes[1] + this.sizes[0];
                        this.sizes[0] = 0;
                    } else if (this.sizes[1] < 0) {
                        this.sizes[0] = this.sizes[0] + this.sizes[1];
                        this.sizes[1] = 0;
                    }
                } else if (!lMinValid) {
                    if (this.sizes[1] - (lMin - this.sizes[0]) < rMin) {
                        if (this.sizes[0] < 0) {
                            this.sizes[1] = this.sizes[1] + this.sizes[0];
                            this.sizes[0] = 0;
                        }
                    } else {
                        this.sizes[1] = this.sizes[1] - (lMin - this.sizes[0]);
                        this.sizes[0] = lMin;
                    }
                } else if (!rMinValid) {
                    if (this.sizes[0] - (rMin - this.sizes[1]) < lMin) {
                        if (this.sizes[1] < 0) {
                            this.sizes[0] = this.sizes[0] + this.sizes[1];
                            this.sizes[1] = 0;
                        }
                    } else {
                        this.sizes[0] = this.sizes[0] - (rMin - this.sizes[1]);
                        this.sizes[1] = rMin;
                    }
                }
                if (this.sizes[0] < 0) {
                    this.sizes[0] = 0;
                }
                if (this.sizes[1] < 0) {
                    this.sizes[1] = 0;
                }
            } else if (lValid) {
                this.sizes[0] = Math.max(0, this.sizes[0] + space);
            } else if (rValid) {
                this.sizes[1] = Math.max(0, this.sizes[1] + space);
            }
        }
    }

    public class KeyboardResizeToggleHandler
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent ev) {
            if (!BasicSplitPaneUI.this.dividerKeyboardResize) {
                BasicSplitPaneUI.this.splitPane.requestFocus();
            }
        }
    }

    public class KeyboardEndHandler
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent ev) {
            if (BasicSplitPaneUI.this.dividerKeyboardResize) {
                int rightI;
                Insets insets = BasicSplitPaneUI.this.splitPane.getInsets();
                int bottomI = insets != null ? insets.bottom : 0;
                int n = rightI = insets != null ? insets.right : 0;
                if (BasicSplitPaneUI.this.orientation == 0) {
                    BasicSplitPaneUI.this.splitPane.setDividerLocation(BasicSplitPaneUI.this.splitPane.getHeight() - bottomI);
                } else {
                    BasicSplitPaneUI.this.splitPane.setDividerLocation(BasicSplitPaneUI.this.splitPane.getWidth() - rightI);
                }
            }
        }
    }

    public class KeyboardHomeHandler
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent ev) {
            if (BasicSplitPaneUI.this.dividerKeyboardResize) {
                BasicSplitPaneUI.this.splitPane.setDividerLocation(0);
            }
        }
    }

    public class KeyboardDownRightHandler
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent ev) {
            if (BasicSplitPaneUI.this.dividerKeyboardResize) {
                BasicSplitPaneUI.this.splitPane.setDividerLocation(BasicSplitPaneUI.this.getDividerLocation(BasicSplitPaneUI.this.splitPane) + BasicSplitPaneUI.this.getKeyboardMoveIncrement());
            }
        }
    }

    public class KeyboardUpLeftHandler
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent ev) {
            if (BasicSplitPaneUI.this.dividerKeyboardResize) {
                BasicSplitPaneUI.this.splitPane.setDividerLocation(Math.max(0, BasicSplitPaneUI.this.getDividerLocation(BasicSplitPaneUI.this.splitPane) - BasicSplitPaneUI.this.getKeyboardMoveIncrement()));
            }
        }
    }

    public class FocusHandler
    extends FocusAdapter {
        @Override
        public void focusGained(FocusEvent ev) {
            BasicSplitPaneUI.this.getHandler().focusGained(ev);
        }

        @Override
        public void focusLost(FocusEvent ev) {
            BasicSplitPaneUI.this.getHandler().focusLost(ev);
        }
    }

    public class PropertyHandler
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent e) {
            BasicSplitPaneUI.this.getHandler().propertyChange(e);
        }
    }
}

