/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.pair.relation;

import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.conflict.ConflictColors;
import org.openstreetmap.josm.gui.conflict.pair.AbstractListMergeModel;
import org.openstreetmap.josm.tools.ImageProvider;

public class RelationMemberTableCellRenderer
extends JLabel
implements TableCellRenderer {
    private final transient Border rowNumberBorder;

    public RelationMemberTableCellRenderer() {
        this.setIcon(null);
        this.setOpaque(true);
        this.rowNumberBorder = BorderFactory.createEmptyBorder(0, 4, 0, 0);
    }

    protected void reset() {
        this.setBackground(ConflictColors.BGCOLOR.get());
        this.setForeground(ConflictColors.FGCOLOR.get());
        this.setBorder(null);
        this.setIcon(null);
        this.setToolTipText(null);
    }

    protected void renderBackground(AbstractListMergeModel.EntriesTableModel entriesTableModel, RelationMember relationMember, int n, int n2, boolean bl) {
        Color color = ConflictColors.BGCOLOR.get();
        if (n2 == 0) {
            if (entriesTableModel.getListMergeModel().isFrozen()) {
                color = ConflictColors.BGCOLOR_FROZEN.get();
            } else if (entriesTableModel.isParticipatingInCurrentComparePair()) {
                color = ConflictColors.BGCOLOR_PARTICIPATING_IN_COMPARISON.get();
            } else if (bl) {
                color = ConflictColors.BGCOLOR_SELECTED.get();
            }
        } else if (entriesTableModel.getListMergeModel().isFrozen()) {
            color = ConflictColors.BGCOLOR_FROZEN.get();
        } else if (relationMember == null) {
            color = ConflictColors.BGCOLOR_EMPTY_ROW.get();
        } else if (bl) {
            color = ConflictColors.BGCOLOR_SELECTED.get();
        } else if (entriesTableModel.isParticipatingInCurrentComparePair()) {
            color = entriesTableModel.isSamePositionInOppositeList(n) ? ConflictColors.BGCOLOR_SAME_POSITION_IN_OPPOSITE.get() : (entriesTableModel.isIncludedInOppositeList(n) ? ConflictColors.BGCOLOR_IN_OPPOSITE.get() : ConflictColors.BGCOLOR_NOT_IN_OPPOSITE.get());
        }
        this.setBackground(color);
    }

    protected void renderForeground(AbstractListMergeModel.EntriesTableModel entriesTableModel, RelationMember relationMember, int n, int n2, boolean bl) {
        Color color = ConflictColors.FGCOLOR.get();
        if (n2 == 0 && entriesTableModel.isParticipatingInCurrentComparePair() && !entriesTableModel.getListMergeModel().isFrozen()) {
            color = ConflictColors.FGCOLOR_PARTICIPATING_IN_COMPARISON.get();
        }
        this.setForeground(color);
    }

    protected void renderRole(RelationMember relationMember) {
        this.setText(relationMember.getRole());
        this.setToolTipText(relationMember.getRole());
    }

    protected void renderPrimitive(RelationMember relationMember) {
        String string = relationMember.getMember().getDisplayName(DefaultNameFormatter.getInstance());
        this.setText(string);
        this.setToolTipText(DefaultNameFormatter.getInstance().buildDefaultToolTip(relationMember.getMember()));
        this.setIcon(ImageProvider.get(relationMember.getDisplayType()));
    }

    protected void renderRowId(int n) {
        this.setBorder(this.rowNumberBorder);
        this.setText(Integer.toString(n + 1));
    }

    protected void renderEmptyRow() {
        this.setIcon(null);
        this.setBackground(ConflictColors.BGCOLOR_EMPTY_ROW.get());
        this.setText("");
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        RelationMember relationMember = (RelationMember)object;
        this.reset();
        if (relationMember == null) {
            this.renderEmptyRow();
        } else {
            this.renderBackground(this.getModel(jTable), relationMember, n, n2, bl);
            this.renderForeground(this.getModel(jTable), relationMember, n, n2, bl);
            switch (n2) {
                case 0: {
                    this.renderRowId(n);
                    break;
                }
                case 1: {
                    this.renderRole(relationMember);
                    break;
                }
                case 2: {
                    this.renderPrimitive(relationMember);
                    break;
                }
            }
        }
        return this;
    }

    protected AbstractListMergeModel.EntriesTableModel getModel(JTable jTable) {
        return (AbstractListMergeModel.EntriesTableModel)jTable.getModel();
    }
}

