/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.model;

import com.eteks.sweethome3d.model.CatalogPieceOfFurniture;
import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.Elevatable;
import com.eteks.sweethome3d.model.HomeMaterial;
import com.eteks.sweethome3d.model.HomeObject;
import com.eteks.sweethome3d.model.HomeTexture;
import com.eteks.sweethome3d.model.Level;
import com.eteks.sweethome3d.model.PieceOfFurniture;
import com.eteks.sweethome3d.model.Selectable;
import com.eteks.sweethome3d.model.TextStyle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HomePieceOfFurniture
extends HomeObject
implements PieceOfFurniture,
Selectable,
Elevatable {
    private static final long serialVersionUID = 1L;
    private static final double TWICE_PI = Math.PI * 2;
    private static final Map<SortableProperty, Comparator<HomePieceOfFurniture>> SORTABLE_PROPERTY_COMPARATORS;
    private static final float[][] IDENTITY;
    private String catalogId;
    private String name;
    private boolean nameVisible;
    private float nameXOffset;
    private float nameYOffset;
    private TextStyle nameStyle;
    private float nameAngle;
    private String description;
    private String information;
    private Content icon;
    private Content planIcon;
    private Content model;
    private float width;
    private float depth;
    private float height;
    private float elevation;
    private float dropOnTopElevation;
    private boolean movable;
    private boolean doorOrWindow;
    private HomeMaterial[] modelMaterials;
    private Integer color;
    private HomeTexture texture;
    private Float shininess;
    private float[][] modelRotation;
    private String staircaseCutOutShape;
    private String creator;
    private boolean backFaceShown;
    private boolean resizable;
    private boolean deformable;
    private boolean texturable;
    private BigDecimal price;
    private BigDecimal valueAddedTaxPercentage;
    private String currency;
    private boolean visible;
    private float x;
    private float y;
    private float angle;
    private boolean modelMirrored;
    private Level level;
    private transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private transient Shape shapeCache;

    private static int compare(float f, float f2) {
        return Float.compare(f, f2);
    }

    private static int compare(boolean bl, boolean bl2) {
        return bl == bl2 ? 0 : (bl ? -1 : 1);
    }

    private static int compare(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        if (bigDecimal == bigDecimal2) {
            return 0;
        }
        if (bigDecimal == null) {
            return -1;
        }
        if (bigDecimal2 == null) {
            return 1;
        }
        return bigDecimal.compareTo(bigDecimal2);
    }

    private static int compare(Level level, Level level2) {
        if (level == level2) {
            return 0;
        }
        if (level == null) {
            return -1;
        }
        if (level2 == null) {
            return 1;
        }
        return Float.compare(level.getElevation(), level2.getElevation());
    }

    public HomePieceOfFurniture(PieceOfFurniture pieceOfFurniture) {
        this.name = pieceOfFurniture.getName();
        this.description = pieceOfFurniture.getDescription();
        this.information = pieceOfFurniture.getInformation();
        this.icon = pieceOfFurniture.getIcon();
        this.planIcon = pieceOfFurniture.getPlanIcon();
        this.model = pieceOfFurniture.getModel();
        this.width = pieceOfFurniture.getWidth();
        this.depth = pieceOfFurniture.getDepth();
        this.height = pieceOfFurniture.getHeight();
        this.elevation = pieceOfFurniture.getElevation();
        this.dropOnTopElevation = pieceOfFurniture.getDropOnTopElevation();
        this.movable = pieceOfFurniture.isMovable();
        this.doorOrWindow = pieceOfFurniture.isDoorOrWindow();
        this.color = pieceOfFurniture.getColor();
        this.modelRotation = pieceOfFurniture.getModelRotation();
        this.staircaseCutOutShape = pieceOfFurniture.getStaircaseCutOutShape();
        this.creator = pieceOfFurniture.getCreator();
        this.backFaceShown = pieceOfFurniture.isBackFaceShown();
        this.resizable = pieceOfFurniture.isResizable();
        this.deformable = pieceOfFurniture.isDeformable();
        this.texturable = pieceOfFurniture.isTexturable();
        this.price = pieceOfFurniture.getPrice();
        this.valueAddedTaxPercentage = pieceOfFurniture.getValueAddedTaxPercentage();
        this.currency = pieceOfFurniture.getCurrency();
        if (pieceOfFurniture instanceof HomePieceOfFurniture) {
            HomePieceOfFurniture homePieceOfFurniture = (HomePieceOfFurniture)pieceOfFurniture;
            this.catalogId = homePieceOfFurniture.getCatalogId();
            this.nameVisible = homePieceOfFurniture.isNameVisible();
            this.nameXOffset = homePieceOfFurniture.getNameXOffset();
            this.nameYOffset = homePieceOfFurniture.getNameYOffset();
            this.nameAngle = homePieceOfFurniture.getNameAngle();
            this.nameStyle = homePieceOfFurniture.getNameStyle();
            this.visible = homePieceOfFurniture.isVisible();
            this.angle = homePieceOfFurniture.getAngle();
            this.x = homePieceOfFurniture.getX();
            this.y = homePieceOfFurniture.getY();
            this.modelMirrored = homePieceOfFurniture.isModelMirrored();
            this.texture = homePieceOfFurniture.getTexture();
            this.shininess = homePieceOfFurniture.getShininess();
            this.modelMaterials = homePieceOfFurniture.getModelMaterials();
        } else {
            if (pieceOfFurniture instanceof CatalogPieceOfFurniture) {
                this.catalogId = ((CatalogPieceOfFurniture)pieceOfFurniture).getId();
            }
            this.visible = true;
            this.x = this.width / 2.0f;
            this.y = this.depth / 2.0f;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.dropOnTopElevation = 1.0f;
        this.modelRotation = IDENTITY;
        this.resizable = true;
        this.deformable = true;
        this.texturable = true;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        objectInputStream.defaultReadObject();
        this.angle = (float)(((double)this.angle % (Math.PI * 2) + Math.PI * 2) % (Math.PI * 2));
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public String getCatalogId() {
        return this.catalogId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (!(string == this.name || string != null && string.equals(this.name))) {
            String string2 = this.name;
            this.name = string;
            this.propertyChangeSupport.firePropertyChange(Property.NAME.name(), string2, string);
        }
    }

    public boolean isNameVisible() {
        return this.nameVisible;
    }

    public void setNameVisible(boolean bl) {
        if (bl != this.nameVisible) {
            this.nameVisible = bl;
            this.propertyChangeSupport.firePropertyChange(Property.NAME_VISIBLE.name(), !bl, bl);
        }
    }

    public float getNameXOffset() {
        return this.nameXOffset;
    }

    public void setNameXOffset(float f) {
        if (f != this.nameXOffset) {
            float f2 = this.nameXOffset;
            this.nameXOffset = f;
            this.propertyChangeSupport.firePropertyChange(Property.NAME_X_OFFSET.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public float getNameYOffset() {
        return this.nameYOffset;
    }

    public void setNameYOffset(float f) {
        if (f != this.nameYOffset) {
            float f2 = this.nameYOffset;
            this.nameYOffset = f;
            this.propertyChangeSupport.firePropertyChange(Property.NAME_Y_OFFSET.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public TextStyle getNameStyle() {
        return this.nameStyle;
    }

    public void setNameStyle(TextStyle textStyle) {
        if (textStyle != this.nameStyle) {
            TextStyle textStyle2 = this.nameStyle;
            this.nameStyle = textStyle;
            this.propertyChangeSupport.firePropertyChange(Property.NAME_STYLE.name(), textStyle2, textStyle);
        }
    }

    public float getNameAngle() {
        return this.nameAngle;
    }

    public void setNameAngle(float f) {
        if ((f = (float)(((double)f % (Math.PI * 2) + Math.PI * 2) % (Math.PI * 2))) != this.nameAngle) {
            float f2 = this.nameAngle;
            this.nameAngle = f;
            this.propertyChangeSupport.firePropertyChange(Property.NAME_ANGLE.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        if (!(string == this.description || string != null && string.equals(this.description))) {
            String string2 = this.description;
            this.description = string;
            this.propertyChangeSupport.firePropertyChange(Property.DESCRIPTION.name(), string2, string);
        }
    }

    @Override
    public String getInformation() {
        return this.information;
    }

    @Override
    public float getDepth() {
        return this.depth;
    }

    public void setDepth(float f) {
        if (this.isResizable()) {
            if (f != this.depth) {
                float f2 = this.depth;
                this.depth = f;
                this.shapeCache = null;
                this.propertyChangeSupport.firePropertyChange(Property.DEPTH.name(), Float.valueOf(f2), Float.valueOf(f));
            }
        } else {
            throw new IllegalStateException("Piece isn't resizable");
        }
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    public void setHeight(float f) {
        if (this.isResizable()) {
            if (f != this.height) {
                float f2 = this.height;
                this.height = f;
                this.propertyChangeSupport.firePropertyChange(Property.HEIGHT.name(), Float.valueOf(f2), Float.valueOf(f));
            }
        } else {
            throw new IllegalStateException("Piece isn't resizable");
        }
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    public void setWidth(float f) {
        if (this.isResizable()) {
            if (f != this.width) {
                float f2 = this.width;
                this.width = f;
                this.shapeCache = null;
                this.propertyChangeSupport.firePropertyChange(Property.WIDTH.name(), Float.valueOf(f2), Float.valueOf(f));
            }
        } else {
            throw new IllegalStateException("Piece isn't resizable");
        }
    }

    @Override
    public float getElevation() {
        return this.elevation;
    }

    @Override
    public float getDropOnTopElevation() {
        return this.dropOnTopElevation;
    }

    public float getGroundElevation() {
        if (this.level != null) {
            return this.elevation + this.level.getElevation();
        }
        return this.elevation;
    }

    public void setElevation(float f) {
        if (f != this.elevation) {
            float f2 = this.elevation;
            this.elevation = f;
            this.propertyChangeSupport.firePropertyChange(Property.ELEVATION.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    @Override
    public boolean isMovable() {
        return this.movable;
    }

    public void setMovable(boolean bl) {
        if (bl != this.movable) {
            this.movable = bl;
            this.propertyChangeSupport.firePropertyChange(Property.MOVABLE.name(), !bl, bl);
        }
    }

    @Override
    public boolean isDoorOrWindow() {
        return this.doorOrWindow;
    }

    @Override
    public Content getIcon() {
        return this.icon;
    }

    @Override
    public Content getPlanIcon() {
        return this.planIcon;
    }

    @Override
    public Content getModel() {
        return this.model;
    }

    public void setModelMaterials(HomeMaterial[] homeMaterialArray) {
        if (this.isTexturable()) {
            if (!Arrays.equals(homeMaterialArray, this.modelMaterials)) {
                HomeMaterial[] homeMaterialArray2 = this.modelMaterials;
                this.modelMaterials = homeMaterialArray != null ? (HomeMaterial[])homeMaterialArray.clone() : null;
                this.propertyChangeSupport.firePropertyChange(Property.MODEL_MATERIALS.name(), homeMaterialArray2, homeMaterialArray);
            }
        } else {
            throw new IllegalStateException("Piece isn't texturable");
        }
    }

    public HomeMaterial[] getModelMaterials() {
        if (this.modelMaterials != null) {
            return (HomeMaterial[])this.modelMaterials.clone();
        }
        return null;
    }

    @Override
    public Integer getColor() {
        return this.color;
    }

    public void setColor(Integer n) {
        if (this.isTexturable()) {
            if (!(n == this.color || n != null && n.equals(this.color))) {
                Integer n2 = this.color;
                this.color = n;
                this.propertyChangeSupport.firePropertyChange(Property.COLOR.name(), n2, n);
            }
        } else {
            throw new IllegalStateException("Piece isn't texturable");
        }
    }

    public HomeTexture getTexture() {
        return this.texture;
    }

    public void setTexture(HomeTexture homeTexture) {
        if (this.isTexturable()) {
            if (!(homeTexture == this.texture || homeTexture != null && homeTexture.equals(this.texture))) {
                HomeTexture homeTexture2 = this.texture;
                this.texture = homeTexture;
                this.propertyChangeSupport.firePropertyChange(Property.TEXTURE.name(), homeTexture2, homeTexture);
            }
        } else {
            throw new IllegalStateException("Piece isn't texturable");
        }
    }

    public Float getShininess() {
        return this.shininess;
    }

    public void setShininess(Float f) {
        if (this.isTexturable()) {
            if (!(f == this.shininess || f != null && f.equals(this.shininess))) {
                Float f2 = this.shininess;
                this.shininess = f;
                this.propertyChangeSupport.firePropertyChange(Property.SHININESS.name(), f2, f);
            }
        } else {
            throw new IllegalStateException("Piece isn't texturable");
        }
    }

    @Override
    public boolean isResizable() {
        return this.resizable;
    }

    @Override
    public boolean isDeformable() {
        return this.deformable;
    }

    @Override
    public boolean isTexturable() {
        return this.texturable;
    }

    @Override
    public BigDecimal getPrice() {
        return this.price;
    }

    public void setPrice(BigDecimal bigDecimal) {
        if (!(bigDecimal == this.price || bigDecimal != null && bigDecimal.equals(this.price))) {
            BigDecimal bigDecimal2 = this.price;
            this.price = bigDecimal;
            this.propertyChangeSupport.firePropertyChange(Property.PRICE.name(), bigDecimal2, bigDecimal);
        }
    }

    @Override
    public BigDecimal getValueAddedTaxPercentage() {
        return this.valueAddedTaxPercentage;
    }

    public BigDecimal getValueAddedTax() {
        if (this.price != null && this.valueAddedTaxPercentage != null) {
            return this.price.multiply(this.valueAddedTaxPercentage).setScale(this.price.scale(), RoundingMode.HALF_UP);
        }
        return null;
    }

    public BigDecimal getPriceValueAddedTaxIncluded() {
        if (this.price != null && this.valueAddedTaxPercentage != null) {
            return this.price.add(this.getValueAddedTax());
        }
        return this.price;
    }

    @Override
    public String getCurrency() {
        return this.currency;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        if (bl != this.visible) {
            this.visible = bl;
            this.propertyChangeSupport.firePropertyChange(Property.VISIBLE.name(), !bl, bl);
        }
    }

    public float getX() {
        return this.x;
    }

    public void setX(float f) {
        if (f != this.x) {
            float f2 = this.x;
            this.x = f;
            this.shapeCache = null;
            this.propertyChangeSupport.firePropertyChange(Property.X.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public float getY() {
        return this.y;
    }

    public void setY(float f) {
        if (f != this.y) {
            float f2 = this.y;
            this.y = f;
            this.shapeCache = null;
            this.propertyChangeSupport.firePropertyChange(Property.Y.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public float getAngle() {
        return this.angle;
    }

    public void setAngle(float f) {
        if ((f = (float)(((double)f % (Math.PI * 2) + Math.PI * 2) % (Math.PI * 2))) != this.angle) {
            float f2 = this.angle;
            this.angle = f;
            this.shapeCache = null;
            this.propertyChangeSupport.firePropertyChange(Property.ANGLE.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public boolean isModelMirrored() {
        return this.modelMirrored;
    }

    public void setModelMirrored(boolean bl) {
        if (this.isResizable()) {
            if (bl != this.modelMirrored) {
                this.modelMirrored = bl;
                this.propertyChangeSupport.firePropertyChange(Property.MODEL_MIRRORED.name(), !bl, bl);
            }
        } else {
            throw new IllegalStateException("Piece isn't resizable");
        }
    }

    @Override
    public float[][] getModelRotation() {
        return new float[][]{{this.modelRotation[0][0], this.modelRotation[0][1], this.modelRotation[0][2]}, {this.modelRotation[1][0], this.modelRotation[1][1], this.modelRotation[1][2]}, {this.modelRotation[2][0], this.modelRotation[2][1], this.modelRotation[2][2]}};
    }

    @Override
    public String getStaircaseCutOutShape() {
        return this.staircaseCutOutShape;
    }

    @Override
    public String getCreator() {
        return this.creator;
    }

    @Override
    public boolean isBackFaceShown() {
        return this.backFaceShown;
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        if (level != this.level) {
            Level level2 = this.level;
            this.level = level;
            this.propertyChangeSupport.firePropertyChange(Property.LEVEL.name(), level2, level);
        }
    }

    @Override
    public boolean isAtLevel(Level level) {
        if (this.level == level) {
            return true;
        }
        if (this.level != null && level != null) {
            float f;
            float f2 = this.level.getElevation();
            return f2 == (f = level.getElevation()) && this.level.getElevationIndex() < level.getElevationIndex() || f2 < f && this.isTopAtLevel(level);
        }
        return false;
    }

    private boolean isTopAtLevel(Level level) {
        float f = this.level.getElevation() + this.elevation + this.height;
        if (this.staircaseCutOutShape != null) {
            return f >= level.getElevation();
        }
        return f > level.getElevation();
    }

    @Override
    public float[][] getPoints() {
        float[][] fArray = new float[4][2];
        PathIterator pathIterator = this.getShape().getPathIterator(null);
        for (int i = 0; i < fArray.length; ++i) {
            pathIterator.currentSegment(fArray[i]);
            pathIterator.next();
        }
        return fArray;
    }

    @Override
    public boolean intersectsRectangle(float f, float f2, float f3, float f4) {
        Rectangle2D.Float float_ = new Rectangle2D.Float(f, f2, 0.0f, 0.0f);
        float_.add(f3, f4);
        return this.getShape().intersects(float_);
    }

    @Override
    public boolean containsPoint(float f, float f2, float f3) {
        if (f3 == 0.0f) {
            return this.getShape().contains(f, f2);
        }
        return this.getShape().intersects(f - f3, f2 - f3, 2.0f * f3, 2.0f * f3);
    }

    public boolean isPointAt(float f, float f2, float f3) {
        for (float[] fArray : this.getPoints()) {
            if (!(Math.abs(f - fArray[0]) <= f3) || !(Math.abs(f2 - fArray[1]) <= f3)) continue;
            return true;
        }
        return false;
    }

    public boolean isTopLeftPointAt(float f, float f2, float f3) {
        float[][] fArray = this.getPoints();
        double d = Point2D.distanceSq(f, f2, fArray[0][0], fArray[0][1]);
        return d <= (double)(f3 * f3) && d < Point2D.distanceSq(f, f2, fArray[1][0], fArray[1][1]) && d < Point2D.distanceSq(f, f2, fArray[3][0], fArray[3][1]);
    }

    public boolean isTopRightPointAt(float f, float f2, float f3) {
        float[][] fArray = this.getPoints();
        double d = Point2D.distanceSq(f, f2, fArray[1][0], fArray[1][1]);
        return d <= (double)(f3 * f3) && d < Point2D.distanceSq(f, f2, fArray[0][0], fArray[0][1]) && d < Point2D.distanceSq(f, f2, fArray[2][0], fArray[2][1]);
    }

    public boolean isBottomLeftPointAt(float f, float f2, float f3) {
        float[][] fArray = this.getPoints();
        double d = Point2D.distanceSq(f, f2, fArray[3][0], fArray[3][1]);
        return d <= (double)(f3 * f3) && d < Point2D.distanceSq(f, f2, fArray[0][0], fArray[0][1]) && d < Point2D.distanceSq(f, f2, fArray[2][0], fArray[2][1]);
    }

    public boolean isBottomRightPointAt(float f, float f2, float f3) {
        float[][] fArray = this.getPoints();
        double d = Point2D.distanceSq(f, f2, fArray[2][0], fArray[2][1]);
        return d <= (double)(f3 * f3) && d < Point2D.distanceSq(f, f2, fArray[1][0], fArray[1][1]) && d < Point2D.distanceSq(f, f2, fArray[3][0], fArray[3][1]);
    }

    public boolean isNameCenterPointAt(float f, float f2, float f3) {
        return Math.abs(f - this.getX() - this.getNameXOffset()) <= f3 && Math.abs(f2 - this.getY() - this.getNameYOffset()) <= f3;
    }

    private Shape getShape() {
        if (this.shapeCache == null) {
            Rectangle2D.Float float_ = new Rectangle2D.Float(this.getX() - this.getWidth() / 2.0f, this.getY() - this.getDepth() / 2.0f, this.getWidth(), this.getDepth());
            AffineTransform affineTransform = AffineTransform.getRotateInstance(this.getAngle(), this.getX(), this.getY());
            PathIterator pathIterator = float_.getPathIterator(affineTransform);
            GeneralPath generalPath = new GeneralPath();
            generalPath.append(pathIterator, false);
            this.shapeCache = generalPath;
        }
        return this.shapeCache;
    }

    @Override
    public void move(float f, float f2) {
        this.setX(this.getX() + f);
        this.setY(this.getY() + f2);
    }

    @Override
    public HomePieceOfFurniture clone() {
        HomePieceOfFurniture homePieceOfFurniture = (HomePieceOfFurniture)super.clone();
        homePieceOfFurniture.propertyChangeSupport = new PropertyChangeSupport(homePieceOfFurniture);
        homePieceOfFurniture.level = null;
        return homePieceOfFurniture;
    }

    public static Comparator<HomePieceOfFurniture> getFurnitureComparator(SortableProperty sortableProperty) {
        return SORTABLE_PROPERTY_COMPARATORS.get((Object)sortableProperty);
    }

    static {
        IDENTITY = new float[][]{{1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 1.0f}};
        final Collator collator = Collator.getInstance();
        SORTABLE_PROPERTY_COMPARATORS = new HashMap<SortableProperty, Comparator<HomePieceOfFurniture>>();
        SORTABLE_PROPERTY_COMPARATORS.put(SortableProperty.CATALOG_ID, new Comparator<HomePieceOfFurniture>(){

            @Override
            public int compare(HomePieceOfFurniture homePieceOfFurniture, HomePieceOfFurniture homePieceOfFurniture2) {
                if (homePieceOfFurniture.catalogId == homePieceOfFurniture2.catalogId) {
                    return 0;
                }
                if (homePieceOfFurniture.catalogId == null) {
                    return -1;
                }
                if (homePieceOfFurniture2.catalogId == null) {
                    return 1;
                }
                return collator.compare(homePieceOfFurniture.catalogId, homePieceOfFurniture2.catalogId);
            }
        });
        SORTABLE_PROPERTY_COMPARATORS.put(SortableProperty.NAME, new Comparator<HomePieceOfFurniture>(){

            @Override
            public int compare(HomePieceOfFurniture homePieceOfFurniture, HomePieceOfFurniture homePieceOfFurniture2) {
                if (homePieceOfFurniture.name == homePieceOfFurniture2.name) {
                    return 0;
                }
                if (homePieceOfFurniture.name == null) {
                    return -1;
                }
                if (homePieceOfFurniture2.name == null) {
                    return 1;
                }
                return collator.compare(homePieceOfFurniture.name, homePieceOfFurniture2.name);
            }
        });
        SORTABLE_PROPERTY_COMPARATORS.put(SortableProperty.WIDTH, new Comparator<HomePieceOfFurniture>(){

            @Override
            public int compare(HomePieceOfFurniture homePieceOfFurniture, HomePieceOfFurniture homePieceOfFurniture2) {
                return HomePieceOfFurniture.compare(homePieceOfFurniture.width, homePieceOfFurniture2.width);
            }
        });
        SORTABLE_PROPERTY_COMPARATORS.put(SortableProperty.HEIGHT, new Comparator<HomePieceOfFurniture>(){

            @Override
            public int compare(HomePieceOfFurniture homePieceOfFurniture, HomePieceOfFurniture homePieceOfFurniture2) {
                return HomePieceOfFurniture.compare(homePieceOfFurniture.height, homePieceOfFurniture2.height);
            }
        });
        SORTABLE_PROPERTY_COMPARATORS.put(SortableProperty.DEPTH, new Comparator<HomePieceOfFurniture>(){

            @Override
            public int compare(HomePieceOfFurniture homePieceOfFurniture, HomePieceOfFurniture homePieceOfFurniture2) {
                return HomePieceOfFurniture.compare(homePieceOfFurniture.depth, homePieceOfFurniture2.depth);
            }
        });
        SORTABLE_PROPERTY_COMPARATORS.put(SortableProperty.MOVABLE, new Comparator<HomePieceOfFurniture>(){

            @Override
            public int compare(HomePieceOfFurniture homePieceOfFurniture, HomePieceOfFurniture homePieceOfFurniture2) {
                return HomePieceOfFurniture.compare(homePieceOfFurniture.movable, homePieceOfFurniture2.movable);
            }
        });
        SORTABLE_PROPERTY_COMPARATORS.put(SortableProperty.DOOR_OR_WINDOW, new Comparator<HomePieceOfFurniture>(){

            @Override
            public int compare(HomePieceOfFurniture homePieceOfFurniture, HomePieceOfFurniture homePieceOfFurniture2) {
                return HomePieceOfFurniture.compare(homePieceOfFurniture.doorOrWindow, homePieceOfFurniture2.doorOrWindow);
            }
        });
        SORTABLE_PROPERTY_COMPARATORS.put(SortableProperty.COLOR, new Comparator<HomePieceOfFurniture>(){

            @Override
            public int compare(HomePieceOfFurniture homePieceOfFurniture, HomePieceOfFurniture homePieceOfFurniture2) {
                if (homePieceOfFurniture.color == homePieceOfFurniture2.color) {
                    return 0;
                }
                if (homePieceOfFurniture.color == null) {
                    return -1;
                }
                if (homePieceOfFurniture2.color == null) {
                    return 1;
                }
                return homePieceOfFurniture.color - homePieceOfFurniture2.color;
            }
        });
        SORTABLE_PROPERTY_COMPARATORS.put(SortableProperty.TEXTURE, new Comparator<HomePieceOfFurniture>(){

            @Override
            public int compare(HomePieceOfFurniture homePieceOfFurniture, HomePieceOfFurniture homePieceOfFurniture2) {
                if (homePieceOfFurniture.texture == homePieceOfFurniture2.texture) {
                    return 0;
                }
                if (homePieceOfFurniture.texture == null) {
                    return -1;
                }
                if (homePieceOfFurniture2.texture == null) {
                    return 1;
                }
                return collator.compare(homePieceOfFurniture.texture.getName(), homePieceOfFurniture2.texture.getName());
            }
        });
        SORTABLE_PROPERTY_COMPARATORS.put(SortableProperty.VISIBLE, new Comparator<HomePieceOfFurniture>(){

            @Override
            public int compare(HomePieceOfFurniture homePieceOfFurniture, HomePieceOfFurniture homePieceOfFurniture2) {
                return HomePieceOfFurniture.compare(homePieceOfFurniture.visible, homePieceOfFurniture2.visible);
            }
        });
        SORTABLE_PROPERTY_COMPARATORS.put(SortableProperty.X, new Comparator<HomePieceOfFurniture>(){

            @Override
            public int compare(HomePieceOfFurniture homePieceOfFurniture, HomePieceOfFurniture homePieceOfFurniture2) {
                return HomePieceOfFurniture.compare(homePieceOfFurniture.x, homePieceOfFurniture2.x);
            }
        });
        SORTABLE_PROPERTY_COMPARATORS.put(SortableProperty.Y, new Comparator<HomePieceOfFurniture>(){

            @Override
            public int compare(HomePieceOfFurniture homePieceOfFurniture, HomePieceOfFurniture homePieceOfFurniture2) {
                return HomePieceOfFurniture.compare(homePieceOfFurniture.y, homePieceOfFurniture2.y);
            }
        });
        SORTABLE_PROPERTY_COMPARATORS.put(SortableProperty.ELEVATION, new Comparator<HomePieceOfFurniture>(){

            @Override
            public int compare(HomePieceOfFurniture homePieceOfFurniture, HomePieceOfFurniture homePieceOfFurniture2) {
                return HomePieceOfFurniture.compare(homePieceOfFurniture.elevation, homePieceOfFurniture2.elevation);
            }
        });
        SORTABLE_PROPERTY_COMPARATORS.put(SortableProperty.ANGLE, new Comparator<HomePieceOfFurniture>(){

            @Override
            public int compare(HomePieceOfFurniture homePieceOfFurniture, HomePieceOfFurniture homePieceOfFurniture2) {
                return HomePieceOfFurniture.compare(homePieceOfFurniture.angle, homePieceOfFurniture2.angle);
            }
        });
        SORTABLE_PROPERTY_COMPARATORS.put(SortableProperty.LEVEL, new Comparator<HomePieceOfFurniture>(){

            @Override
            public int compare(HomePieceOfFurniture homePieceOfFurniture, HomePieceOfFurniture homePieceOfFurniture2) {
                return HomePieceOfFurniture.compare(homePieceOfFurniture.getLevel(), homePieceOfFurniture2.getLevel());
            }
        });
        SORTABLE_PROPERTY_COMPARATORS.put(SortableProperty.PRICE, new Comparator<HomePieceOfFurniture>(){

            @Override
            public int compare(HomePieceOfFurniture homePieceOfFurniture, HomePieceOfFurniture homePieceOfFurniture2) {
                return HomePieceOfFurniture.compare(homePieceOfFurniture.price, homePieceOfFurniture2.price);
            }
        });
        SORTABLE_PROPERTY_COMPARATORS.put(SortableProperty.VALUE_ADDED_TAX_PERCENTAGE, new Comparator<HomePieceOfFurniture>(){

            @Override
            public int compare(HomePieceOfFurniture homePieceOfFurniture, HomePieceOfFurniture homePieceOfFurniture2) {
                return HomePieceOfFurniture.compare(homePieceOfFurniture.valueAddedTaxPercentage, homePieceOfFurniture2.valueAddedTaxPercentage);
            }
        });
        SORTABLE_PROPERTY_COMPARATORS.put(SortableProperty.VALUE_ADDED_TAX, new Comparator<HomePieceOfFurniture>(){

            @Override
            public int compare(HomePieceOfFurniture homePieceOfFurniture, HomePieceOfFurniture homePieceOfFurniture2) {
                return HomePieceOfFurniture.compare(homePieceOfFurniture.getValueAddedTax(), homePieceOfFurniture2.getValueAddedTax());
            }
        });
        SORTABLE_PROPERTY_COMPARATORS.put(SortableProperty.PRICE_VALUE_ADDED_TAX_INCLUDED, new Comparator<HomePieceOfFurniture>(){

            @Override
            public int compare(HomePieceOfFurniture homePieceOfFurniture, HomePieceOfFurniture homePieceOfFurniture2) {
                return HomePieceOfFurniture.compare(homePieceOfFurniture.getPriceValueAddedTaxIncluded(), homePieceOfFurniture2.getPriceValueAddedTaxIncluded());
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SortableProperty {
        CATALOG_ID,
        NAME,
        WIDTH,
        DEPTH,
        HEIGHT,
        MOVABLE,
        DOOR_OR_WINDOW,
        COLOR,
        TEXTURE,
        VISIBLE,
        X,
        Y,
        ELEVATION,
        ANGLE,
        PRICE,
        VALUE_ADDED_TAX,
        VALUE_ADDED_TAX_PERCENTAGE,
        PRICE_VALUE_ADDED_TAX_INCLUDED,
        LEVEL;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Property {
        NAME,
        NAME_VISIBLE,
        NAME_X_OFFSET,
        NAME_Y_OFFSET,
        NAME_STYLE,
        NAME_ANGLE,
        DESCRIPTION,
        PRICE,
        WIDTH,
        DEPTH,
        HEIGHT,
        COLOR,
        TEXTURE,
        MODEL_MATERIALS,
        SHININESS,
        VISIBLE,
        X,
        Y,
        ELEVATION,
        ANGLE,
        MODEL_MIRRORED,
        MOVABLE,
        LEVEL;

    }
}

