-- EFL LuaJIT bindings: elm_prefs.eo (class Elm.Prefs)
-- For use with Elua; automatically generated, do not modify

local cutil = require("cutil")
local util  = require("util")
local ffi   = require("ffi")
local eo    = require("eo")

local M, __lib = ...

local __class
local __body

local init = function()
    __class = __lib.elm_prefs_class_get()
    eo.class_register("Elm_Prefs", {"Elm_Widget"}, {"Efl_File"}, __body, __class)
end

cutil.init_module(init, function() end)

ffi.cdef [[
    const Eo_Class *elm_prefs_class_get(void);
    Eina_Bool elm_obj_prefs_data_set(Elm_Prefs_Data * data);
    Elm_Prefs_Data *elm_obj_prefs_data_get(void);
    void elm_obj_prefs_autosave_set(Eina_Bool autosave);
    Eina_Bool elm_obj_prefs_autosave_get(void);
    void elm_obj_prefs_reset(Elm_Prefs_Reset_Mode mode);
    Eina_Bool elm_obj_prefs_item_value_set(const char * name, const Eina_Value * value);
    Eina_Bool elm_obj_prefs_item_value_get(const char * name, Eina_Value *value);
    const Efl_Canvas_Object *elm_obj_prefs_item_object_get(const char * name);
    void elm_obj_prefs_item_disabled_set(const char * name, Eina_Bool disabled);
    Eina_Bool elm_obj_prefs_item_disabled_get(const char * name);
    Eina_Bool elm_obj_prefs_item_swallow(const char * name, Efl_Canvas_Object * child);
    void elm_obj_prefs_item_editable_set(const char * name, Eina_Bool editable);
    Eina_Bool elm_obj_prefs_item_editable_get(const char * name);
    Efl_Canvas_Object *elm_obj_prefs_item_unswallow(const char * name);
    void elm_obj_prefs_item_visible_set(const char * name, Eina_Bool visible);
    Eina_Bool elm_obj_prefs_item_visible_get(const char * name);
    extern const Eo_Event_Description _ELM_PREFS_EVENT_PAGE_CHANGED;
    extern const Eo_Event_Description _ELM_PREFS_EVENT_PAGE_SAVED;
    extern const Eo_Event_Description _ELM_PREFS_EVENT_PAGE_RESET;
    extern const Eo_Event_Description _ELM_PREFS_EVENT_PAGE_LOADED;
    extern const Eo_Event_Description _ELM_PREFS_EVENT_ITEM_CHANGED;
    extern const Eo_Event_Description _ELM_PREFS_EVENT_ACTION;
]]

__body = {
    __eo_ctor = function(self, __func)
        if __func then __func() end
    end,

    data_set = function(self, data)
        eo.__do_start(self, __class)
        local v = __lib.elm_obj_prefs_data_set(data)
        eo.__do_end()
    end,

    data_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.elm_obj_prefs_data_get()
        eo.__do_end()
        return v
    end,

    autosave_set = function(self, autosave)
        eo.__do_start(self, __class)
        __lib.elm_obj_prefs_autosave_set(autosave)
        eo.__do_end()
    end,

    autosave_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.elm_obj_prefs_autosave_get()
        eo.__do_end()
        return ((v) ~= 0)
    end,

    reset = function(self, mode)
        eo.__do_start(self, __class)
        __lib.elm_obj_prefs_reset(mode)
        eo.__do_end()
    end,

    item_value_set = function(self, name, value)
        eo.__do_start(self, __class)
        local v = __lib.elm_obj_prefs_item_value_set(name, value)
        eo.__do_end()
        return ((v) ~= 0)
    end,

    item_value_get = function(self, name)
        eo.__do_start(self, __class)
        local value = ffi.new("Eina_Value[1]")
        local v = __lib.elm_obj_prefs_item_value_get(name, value)
        eo.__do_end()
        return ((v) ~= 0), value[0]
    end,

    item_object_get = function(self, name)
        eo.__do_start(self, __class)
        local v = __lib.elm_obj_prefs_item_object_get(name)
        eo.__do_end()
        return v
    end,

    item_disabled_set = function(self, name, disabled)
        eo.__do_start(self, __class)
        __lib.elm_obj_prefs_item_disabled_set(name, disabled)
        eo.__do_end()
    end,

    item_disabled_get = function(self, name)
        eo.__do_start(self, __class)
        local v = __lib.elm_obj_prefs_item_disabled_get(name)
        eo.__do_end()
        return ((v) ~= 0)
    end,

    item_swallow = function(self, name, child)
        eo.__do_start(self, __class)
        local v = __lib.elm_obj_prefs_item_swallow(name, child)
        eo.__do_end()
        return ((v) ~= 0)
    end,

    item_editable_set = function(self, name, editable)
        eo.__do_start(self, __class)
        __lib.elm_obj_prefs_item_editable_set(name, editable)
        eo.__do_end()
    end,

    item_editable_get = function(self, name)
        eo.__do_start(self, __class)
        local v = __lib.elm_obj_prefs_item_editable_get(name)
        eo.__do_end()
        return ((v) ~= 0)
    end,

    item_unswallow = function(self, name)
        eo.__do_start(self, __class)
        local v = __lib.elm_obj_prefs_item_unswallow(name)
        eo.__do_end()
        return v
    end,

    item_visible_set = function(self, name, visible)
        eo.__do_start(self, __class)
        __lib.elm_obj_prefs_item_visible_set(name, visible)
        eo.__do_end()
    end,

    item_visible_get = function(self, name)
        eo.__do_start(self, __class)
        local v = __lib.elm_obj_prefs_item_visible_get(name)
        eo.__do_end()
        return ((v) ~= 0)
    end,

    __events = {
        ["page,changed"] = __lib._ELM_PREFS_EVENT_PAGE_CHANGED,
        ["page,saved"] = __lib._ELM_PREFS_EVENT_PAGE_SAVED,
        ["page,reset"] = __lib._ELM_PREFS_EVENT_PAGE_RESET,
        ["page,loaded"] = __lib._ELM_PREFS_EVENT_PAGE_LOADED,
        ["item,changed"] = __lib._ELM_PREFS_EVENT_ITEM_CHANGED,
        ["action"] = __lib._ELM_PREFS_EVENT_ACTION
    },

    __properties = {
        ["data"] = { 0, 0, 1, 1, true, true },
        ["autosave"] = { 0, 0, 1, 1, true, true }
    }
}

M.Prefs = function(parent, ...)
    return eo.__ctor_common(__class, parent, eo.class_get("Elm_Prefs").__eo_ctor,
                            1, ...)
end

return M
