/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.fieldcaps;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.fieldcaps.FieldCapabilities;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesIndexRequest;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesIndexResponse;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesRequest;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesResponse;
import org.elasticsearch.action.fieldcaps.TransportFieldCapabilitiesIndexAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportFieldCapabilitiesAction
extends HandledTransportAction<FieldCapabilitiesRequest, FieldCapabilitiesResponse> {
    private final ClusterService clusterService;
    private final TransportFieldCapabilitiesIndexAction shardAction;

    @Inject
    public TransportFieldCapabilitiesAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, TransportFieldCapabilitiesIndexAction shardAction, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "indices:data/read/field_caps", threadPool, transportService, actionFilters, indexNameExpressionResolver, FieldCapabilitiesRequest::new);
        this.clusterService = clusterService;
        this.shardAction = shardAction;
    }

    @Override
    protected void doExecute(FieldCapabilitiesRequest request, final ActionListener<FieldCapabilitiesResponse> listener) {
        ClusterState clusterState = this.clusterService.state();
        String[] concreteIndices = this.indexNameExpressionResolver.concreteIndexNames(clusterState, request);
        final AtomicInteger indexCounter = new AtomicInteger();
        final AtomicInteger completionCounter = new AtomicInteger(concreteIndices.length);
        final AtomicReferenceArray indexResponses = new AtomicReferenceArray(concreteIndices.length);
        if (concreteIndices.length == 0) {
            listener.onResponse(new FieldCapabilitiesResponse());
        } else {
            for (String index : concreteIndices) {
                FieldCapabilitiesIndexRequest indexRequest = new FieldCapabilitiesIndexRequest(request.fields(), index);
                this.shardAction.execute(indexRequest, new ActionListener<FieldCapabilitiesIndexResponse>(){

                    @Override
                    public void onResponse(FieldCapabilitiesIndexResponse result) {
                        indexResponses.set(indexCounter.getAndIncrement(), result);
                        if (completionCounter.decrementAndGet() == 0) {
                            listener.onResponse(TransportFieldCapabilitiesAction.this.merge(indexResponses));
                        }
                    }

                    @Override
                    public void onFailure(Exception e) {
                        indexResponses.set(indexCounter.getAndIncrement(), e);
                        if (completionCounter.decrementAndGet() == 0) {
                            listener.onResponse(TransportFieldCapabilitiesAction.this.merge(indexResponses));
                        }
                    }
                });
            }
        }
    }

    private FieldCapabilitiesResponse merge(AtomicReferenceArray<Object> indexResponses) {
        HashMap responseMapBuilder = new HashMap();
        for (int i = 0; i < indexResponses.length(); ++i) {
            Object element = indexResponses.get(i);
            if (!(element instanceof FieldCapabilitiesIndexResponse)) {
                assert (element instanceof Exception);
                continue;
            }
            FieldCapabilitiesIndexResponse response = (FieldCapabilitiesIndexResponse)element;
            for (String field : response.get().keySet()) {
                FieldCapabilities fieldCap;
                FieldCapabilities.Builder builder;
                HashMap<String, FieldCapabilities.Builder> typeMap = (HashMap<String, FieldCapabilities.Builder>)responseMapBuilder.get(field);
                if (typeMap == null) {
                    typeMap = new HashMap<String, FieldCapabilities.Builder>();
                    responseMapBuilder.put(field, typeMap);
                }
                if ((builder = (FieldCapabilities.Builder)typeMap.get((fieldCap = response.getField(field)).getType())) == null) {
                    builder = new FieldCapabilities.Builder(field, fieldCap.getType());
                    typeMap.put(fieldCap.getType(), builder);
                }
                builder.add(response.getIndexName(), fieldCap.isSearchable(), fieldCap.isAggregatable());
            }
        }
        HashMap<String, Map<String, FieldCapabilities>> responseMap = new HashMap<String, Map<String, FieldCapabilities>>();
        for (Map.Entry entry : responseMapBuilder.entrySet()) {
            HashMap typeMap = new HashMap();
            boolean multiTypes = ((Map)entry.getValue()).size() > 1;
            for (Map.Entry fieldEntry : ((Map)entry.getValue()).entrySet()) {
                typeMap.put(fieldEntry.getKey(), ((FieldCapabilities.Builder)fieldEntry.getValue()).build(multiTypes));
            }
            responseMap.put((String)entry.getKey(), typeMap);
        }
        return new FieldCapabilitiesResponse(responseMap);
    }
}

