/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest.completion.context;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.lucene.index.IndexableField;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.search.suggest.completion.context.CategoryQueryContext;
import org.elasticsearch.search.suggest.completion.context.ContextBuilder;
import org.elasticsearch.search.suggest.completion.context.ContextMapping;

public class CategoryContextMapping
extends ContextMapping<CategoryQueryContext> {
    private static final String FIELD_FIELDNAME = "path";
    static final String CONTEXT_VALUE = "context";
    static final String CONTEXT_BOOST = "boost";
    static final String CONTEXT_PREFIX = "prefix";
    private final String fieldName;

    private CategoryContextMapping(String name, String fieldName) {
        super(ContextMapping.Type.CATEGORY, name);
        this.fieldName = fieldName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    protected static CategoryContextMapping load(String name, Map<String, Object> config) throws ElasticsearchParseException {
        Builder mapping = new Builder(name);
        Object fieldName = config.get(FIELD_FIELDNAME);
        if (fieldName != null) {
            mapping.field(fieldName.toString());
            config.remove(FIELD_FIELDNAME);
        }
        return mapping.build();
    }

    @Override
    protected XContentBuilder toInnerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.fieldName != null) {
            builder.field(FIELD_FIELDNAME, this.fieldName);
        }
        return builder;
    }

    @Override
    public Set<CharSequence> parseContext(ParseContext parseContext, XContentParser parser) throws IOException, ElasticsearchParseException {
        HashSet<CharSequence> contexts = new HashSet<CharSequence>();
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.VALUE_STRING) {
            contexts.add(parser.text());
        } else if (token == XContentParser.Token.START_ARRAY) {
            while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                if (token == XContentParser.Token.VALUE_STRING) {
                    contexts.add(parser.text());
                    continue;
                }
                throw new ElasticsearchParseException("context array must have string values", new Object[0]);
            }
        } else {
            throw new ElasticsearchParseException("contexts must be a string or a list of strings", new Object[0]);
        }
        return contexts;
    }

    @Override
    public Set<CharSequence> parseContext(ParseContext.Document document) {
        HashSet<String> values = null;
        if (this.fieldName != null) {
            IndexableField[] fields = document.getFields(this.fieldName);
            values = new HashSet<String>(fields.length);
            for (IndexableField field : fields) {
                values.add(field.stringValue());
            }
        }
        return values == null ? Collections.emptySet() : values;
    }

    @Override
    protected CategoryQueryContext fromXContent(QueryParseContext context) throws IOException {
        return CategoryQueryContext.fromXContent(context);
    }

    @Override
    public List<ContextMapping.InternalQueryContext> toInternalQueryContexts(List<CategoryQueryContext> queryContexts) {
        ArrayList<ContextMapping.InternalQueryContext> internalInternalQueryContexts = new ArrayList<ContextMapping.InternalQueryContext>(queryContexts.size());
        internalInternalQueryContexts.addAll(queryContexts.stream().map(queryContext -> new ContextMapping.InternalQueryContext(queryContext.getCategory(), queryContext.getBoost(), queryContext.isPrefix())).collect(Collectors.toList()));
        return internalInternalQueryContexts;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CategoryContextMapping mapping = (CategoryContextMapping)o;
        return !(this.fieldName == null ? mapping.fieldName != null : !this.fieldName.equals(mapping.fieldName));
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.fieldName);
    }

    public static class Builder
    extends ContextBuilder<CategoryContextMapping> {
        private String fieldName;

        public Builder(String name) {
            super(name);
        }

        public Builder field(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        @Override
        public CategoryContextMapping build() {
            return new CategoryContextMapping(this.name, this.fieldName);
        }
    }
}

