/*
 * Decompiled with CFR 0.152.
 */
package org.openide.xml;

import java.io.CharConversionException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.openide.util.Lookup;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XMLUtil {
    private static final char[] DEC2HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static Class fastParserFactoryClass = null;
    private static final String IDENTITY_XSLT_WITH_INDENT = "<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform' xmlns:xalan='http://xml.apache.org/xslt' exclude-result-prefixes='xalan'><xsl:output method='xml' indent='yes' xalan:indent-amount='4'/><xsl:template match='@*|node()'><xsl:copy><xsl:apply-templates select='@*|node()'/></xsl:copy></xsl:template></xsl:stylesheet>";

    private XMLUtil() {
    }

    public static XMLReader createXMLReader() throws SAXException {
        return XMLUtil.createXMLReader(false, false);
    }

    public static XMLReader createXMLReader(boolean bl) throws SAXException {
        return XMLUtil.createXMLReader(bl, false);
    }

    public static XMLReader createXMLReader(boolean bl, boolean bl2) throws SAXException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(bl);
        sAXParserFactory.setNamespaceAware(bl2);
        try {
            return sAXParserFactory.newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SAXException("Cannot create parser satisfying configuration parameters", parserConfigurationException);
        }
    }

    public static Document createDocument(String string, String string2, String string3, String string4) throws DOMException {
        DOMImplementation dOMImplementation = XMLUtil.getDOMImplementation();
        if (string3 != null && string4 == null) {
            throw new IllegalArgumentException("System ID cannot be null if public ID specified. ");
        }
        DocumentType documentType = null;
        if (string4 != null) {
            documentType = dOMImplementation.createDocumentType(string, string3, string4);
        }
        return dOMImplementation.createDocument(string2, string, documentType);
    }

    private static DOMImplementation getDOMImplementation() throws DOMException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            return documentBuilderFactory.newDocumentBuilder().getDOMImplementation();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new DOMException(9, "Cannot create parser satisfying configuration parameters");
        }
        catch (RuntimeException runtimeException) {
            throw (DOMException)new DOMException(9, runtimeException.toString()).initCause(runtimeException);
        }
    }

    public static Document parse(InputSource inputSource, boolean bl, boolean bl2, ErrorHandler errorHandler, EntityResolver entityResolver) throws IOException, SAXException {
        DocumentBuilder documentBuilder = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(bl);
        documentBuilderFactory.setNamespaceAware(bl2);
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SAXException("Cannot create parser satisfying configuration parameters", parserConfigurationException);
        }
        if (errorHandler != null) {
            documentBuilder.setErrorHandler(errorHandler);
        }
        if (entityResolver != null) {
            documentBuilder.setEntityResolver(entityResolver);
        }
        return documentBuilder.parse(inputSource);
    }

    public static void write(Document document, OutputStream outputStream, String string) throws IOException {
        Object object;
        if (string == null) {
            throw new NullPointerException("You must set an encoding; use \"UTF-8\" unless you have a good reason not to!");
        }
        Document document2 = XMLUtil.normalize(document);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader classLoader2 = Lookup.getDefault().lookup(ClassLoader.class);
        ClassLoader classLoader3 = XMLUtil.class.getClassLoader();
        if (classLoader2 == null) {
            classLoader2 = classLoader3;
        }
        try {
            object = classLoader2.loadClass("org.netbeans.core.startup.SAXFactoryImpl");
            if (object != null) {
                classLoader3 = ((Class)object).getClassLoader();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Thread.currentThread().setContextClassLoader(classLoader3);
        try {
            Object object2;
            Object object3;
            Object object4;
            object = TransformerFactory.newInstance().newTransformer(new StreamSource(new StringReader(IDENTITY_XSLT_WITH_INDENT)));
            DocumentType documentType = document2.getDoctype();
            if (documentType != null) {
                object4 = documentType.getPublicId();
                if (object4 != null) {
                    ((Transformer)object).setOutputProperty("doctype-public", (String)object4);
                }
                ((Transformer)object).setOutputProperty("doctype-system", documentType.getSystemId());
            }
            ((Transformer)object).setOutputProperty("encoding", string);
            object4 = new HashSet();
            XMLUtil.collectCDATASections(document2, (Set<String>)object4);
            if (object4.size() > 0) {
                object3 = new StringBuilder();
                object2 = object4.iterator();
                while (object2.hasNext()) {
                    String string2 = (String)object2.next();
                    ((StringBuilder)object3).append(string2).append(' ');
                }
                ((Transformer)object).setOutputProperty("cdata-section-elements", ((StringBuilder)object3).toString());
            }
            object3 = new DOMSource(document2);
            object2 = new StreamResult(outputStream);
            ((Transformer)object).transform((Source)object3, (Result)object2);
        }
        catch (Exception exception) {
            throw (IOException)new IOException(exception.toString()).initCause(exception);
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    private static void collectCDATASections(Node node, Set<String> set) {
        Object object;
        if (node instanceof CDATASection && (object = node.getParentNode()) != null) {
            String string = object.getNamespaceURI();
            if (string != null) {
                set.add("{" + string + "}" + object.getNodeName());
            } else {
                set.add(object.getNodeName());
            }
        }
        object = node.getChildNodes();
        for (int i = 0; i < object.getLength(); ++i) {
            XMLUtil.collectCDATASections(object.item(i), set);
        }
    }

    public static String toAttributeValue(String string) throws CharConversionException {
        if (string == null) {
            throw new CharConversionException("null");
        }
        if (XMLUtil.checkAttributeCharacters(string)) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ('<' == c) {
                stringBuffer.append("&lt;");
                continue;
            }
            if ('&' == c) {
                stringBuffer.append("&amp;");
                continue;
            }
            if ('\'' == c) {
                stringBuffer.append("&apos;");
                continue;
            }
            if ('\"' == c) {
                stringBuffer.append("&quot;");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String toElementContent(String string) throws CharConversionException {
        if (string == null) {
            throw new CharConversionException("null");
        }
        if (XMLUtil.checkContentCharacters(string)) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ('<' == c) {
                stringBuilder.append("&lt;");
                continue;
            }
            if ('&' == c) {
                stringBuilder.append("&amp;");
                continue;
            }
            if ('>' == c && i > 1 && string.charAt(i - 2) == ']' && string.charAt(i - 1) == ']') {
                stringBuilder.append("&gt;");
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String toHex(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n2; ++i) {
            byte by = byArray[n + i];
            stringBuffer.append(DEC2HEX[(by & 0xF0) >> 4]);
            stringBuffer.append(DEC2HEX[by & 0xF]);
        }
        return stringBuffer.toString();
    }

    public static byte[] fromHex(char[] cArray, int n, int n2) throws IOException {
        if (cArray == null) {
            throw new IOException("null");
        }
        int n3 = cArray.length;
        if (n3 % 2 != 0) {
            throw new IOException("odd length");
        }
        byte[] byArray = new byte[n3 / 2];
        while (n3 > 0) {
            String string = new String(cArray, n3 - 2, 2);
            try {
                byArray[n3 / 2 - 1] = (byte)Integer.parseInt(string, 16);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException(numberFormatException.getLocalizedMessage());
            }
            n3 -= 2;
        }
        return byArray;
    }

    private static boolean checkAttributeCharacters(String string) throws CharConversionException {
        boolean bl = false;
        block4: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c > ']') continue;
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': {
                    continue block4;
                }
                case '\"': 
                case '&': 
                case '\'': 
                case '<': {
                    bl = true;
                    continue block4;
                }
                default: {
                    if (c >= ' ') continue block4;
                    throw new CharConversionException("Invalid XML character &#" + c + ";.");
                }
            }
        }
        return !bl;
    }

    private static boolean checkContentCharacters(String string) throws CharConversionException {
        boolean bl = false;
        block5: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c > ']') continue;
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': {
                    continue block5;
                }
                case '>': {
                    if (bl) continue block5;
                    bl = i > 0 && string.charAt(i - 1) == ']';
                    continue block5;
                }
                case '&': 
                case '<': {
                    bl = true;
                    continue block5;
                }
                default: {
                    if (c >= ' ') continue block5;
                    throw new CharConversionException("Invalid XML character &#" + c + ";.");
                }
            }
        }
        return !bl;
    }

    private static Document normalize(Document document) throws IOException {
        int n;
        Document document2;
        DocumentBuilder documentBuilder = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        documentBuilderFactory.setNamespaceAware(false);
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw (IOException)new IOException("Cannot create parser satisfying configuration parameters: " + parserConfigurationException).initCause(parserConfigurationException);
        }
        DocumentType documentType = null;
        NodeList nodeList = document.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!(nodeList.item(i) instanceof DocumentType)) continue;
            documentType = (DocumentType)nodeList.item(i);
        }
        if (documentType != null) {
            document2 = documentBuilder.getDOMImplementation().createDocument(document.getDocumentElement().getNamespaceURI(), document.getDocumentElement().getTagName(), documentBuilder.getDOMImplementation().createDocumentType(document.getDoctype().getName(), document.getDoctype().getPublicId(), document.getDoctype().getSystemId()));
            document2.removeChild(document2.getDocumentElement());
        } else {
            document2 = documentBuilder.newDocument();
        }
        for (n = 0; n < nodeList.getLength(); ++n) {
            if (nodeList.item(n) instanceof DocumentType) continue;
            document2.appendChild(document2.importNode(nodeList.item(n), true));
        }
        document2.normalize();
        nodeList = document2.getElementsByTagName("*");
        for (n = 0; n < nodeList.getLength(); ++n) {
            Element element = (Element)nodeList.item(n);
            NodeList nodeList2 = element.getChildNodes();
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Node node = nodeList2.item(i);
                if (!(node instanceof Text) || ((Text)node).getNodeValue().trim().length() != 0) continue;
                element.removeChild(node);
                --i;
            }
        }
        return document2;
    }
}

