/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.taskfactory;

import java.util.Collection;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.taskfactory.PropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.PropertyAnnotationUtils;
import org.gradle.api.internal.project.taskfactory.TaskPropertyActionContext;
import org.gradle.api.internal.project.taskfactory.UpdateAction;
import org.gradle.api.internal.project.taskfactory.ValidationAction;
import org.gradle.api.tasks.TaskOutputFilePropertyBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOutputPropertyAnnotationHandler
implements PropertyAnnotationHandler {
    @Override
    public void attachActions(final TaskPropertyActionContext context) {
        context.setValidationAction(new ValidationAction(){

            @Override
            public void validate(String propertyName, Object value, Collection<String> messages) {
                AbstractOutputPropertyAnnotationHandler.this.validate(propertyName, value, messages);
            }
        });
        context.setConfigureAction(new UpdateAction(){

            @Override
            public void update(TaskInternal task, final Callable<Object> futureValue) {
                AbstractOutputPropertyAnnotationHandler.this.createPropertyBuilder(context, task, futureValue).withPropertyName(context.getName()).withPathSensitivity(PropertyAnnotationUtils.getPathSensitivity(context)).optional(context.isOptional());
                task.prependParallelSafeAction((Action<? super Task>)new Action<Task>(){

                    public void execute(Task task) {
                        AbstractOutputPropertyAnnotationHandler.this.beforeTask(futureValue);
                    }
                });
            }
        });
    }

    protected abstract TaskOutputFilePropertyBuilder createPropertyBuilder(TaskPropertyActionContext var1, TaskInternal var2, Callable<Object> var3);

    protected abstract void beforeTask(Callable<Object> var1);

    protected abstract void validate(String var1, Object var2, Collection<String> var3);
}

