/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.internal.GradleInternal;
import org.gradle.configuration.InitScriptProcessor;
import org.gradle.groovy.scripts.UriScriptSource;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.progress.BuildOperationDetails;
import org.gradle.internal.progress.BuildOperationExecutor;

public class InitScriptHandler {
    private final InitScriptProcessor processor;
    private final BuildOperationExecutor buildOperationExecutor;

    public InitScriptHandler(InitScriptProcessor processor, BuildOperationExecutor buildOperationExecutor) {
        this.processor = processor;
        this.buildOperationExecutor = buildOperationExecutor;
    }

    public void executeScripts(final GradleInternal gradle) {
        final List<File> initScripts = gradle.getStartParameter().getAllInitScripts();
        if (initScripts.isEmpty()) {
            return;
        }
        BuildOperationDetails operationDetails = BuildOperationDetails.displayName("Run init scripts").progressDisplayName("init scripts").build();
        this.buildOperationExecutor.run(operationDetails, (Action<? super BuildOperationContext>)new Action<BuildOperationContext>(){

            public void execute(BuildOperationContext buildOperationContext) {
                for (File script : initScripts) {
                    InitScriptHandler.this.processor.process(new UriScriptSource("initialization script", script), gradle);
                }
            }
        });
    }
}

