/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.visualstudio.internal;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.gradle.nativeplatform.NativeBinarySpec;
import org.gradle.nativeplatform.NativeExecutableBinarySpec;
import org.gradle.nativeplatform.SharedLibraryBinarySpec;
import org.gradle.nativeplatform.StaticLibraryBinarySpec;
import org.gradle.nativeplatform.internal.NativeBinarySpecInternal;
import org.gradle.nativeplatform.test.NativeTestSuiteBinarySpec;

public class VisualStudioProjectMapper {
    public ProjectConfigurationNames mapToConfiguration(NativeBinarySpec nativeBinary) {
        String projectName = this.projectPrefix(nativeBinary) + this.componentName(nativeBinary) + this.projectSuffix(nativeBinary);
        String configurationName = this.getConfigurationName(nativeBinary);
        return new ProjectConfigurationNames(projectName, configurationName, "Win32");
    }

    private String getConfigurationName(NativeBinarySpec nativeBinary) {
        List dimensions = ((NativeBinarySpecInternal)nativeBinary).getNamingScheme().getVariantDimensions();
        if (dimensions.isEmpty()) {
            return nativeBinary.getBuildType().getName();
        }
        return VisualStudioProjectMapper.makeName(dimensions);
    }

    private String projectPrefix(NativeBinarySpec nativeBinary) {
        String projectPath = nativeBinary.getComponent().getProjectPath();
        if (":".equals(projectPath)) {
            return "";
        }
        return projectPath.substring(1).replace(":", "_") + "_";
    }

    private String componentName(NativeBinarySpec nativeBinary) {
        return nativeBinary.getComponent().getName();
    }

    private String projectSuffix(NativeBinarySpec nativeBinary) {
        return nativeBinary instanceof SharedLibraryBinarySpec ? "Dll" : (nativeBinary instanceof StaticLibraryBinarySpec ? "Lib" : (nativeBinary instanceof NativeExecutableBinarySpec ? "Exe" : (nativeBinary instanceof NativeTestSuiteBinarySpec ? "Exe" : "")));
    }

    private static String makeName(Iterable<String> components) {
        StringBuilder builder = new StringBuilder();
        for (String component : components) {
            if (component == null || component.length() <= 0) continue;
            if (builder.length() == 0) {
                builder.append(component);
                continue;
            }
            builder.append(StringUtils.capitalize((String)component));
        }
        return builder.toString();
    }

    static class ProjectConfigurationNames {
        public final String project;
        public final String configuration;
        public final String platform;

        ProjectConfigurationNames(String project, String configuration, String platform) {
            this.project = project;
            this.configuration = configuration;
            this.platform = platform;
        }
    }
}

