/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.bsh;

import java.io.Serializable;
import org.gjt.sp.jedit.bsh.LHS;
import org.gjt.sp.jedit.bsh.Modifiers;
import org.gjt.sp.jedit.bsh.Primitive;
import org.gjt.sp.jedit.bsh.Types;
import org.gjt.sp.jedit.bsh.UtilEvalError;

public class Variable
implements Serializable {
    static final int DECLARATION = 0;
    static final int ASSIGNMENT = 1;
    String name;
    Class type = null;
    String typeDescriptor;
    Object value;
    Modifiers modifiers;
    LHS lhs;

    Variable(String string, Class clazz, LHS lHS) {
        this.name = string;
        this.lhs = lHS;
        this.type = clazz;
    }

    Variable(String string, Object object, Modifiers modifiers) throws UtilEvalError {
        this(string, (Class)null, object, modifiers);
    }

    Variable(String string, String string2, Object object, Modifiers modifiers) throws UtilEvalError {
        this(string, (Class)null, object, modifiers);
        this.typeDescriptor = string2;
    }

    Variable(String string, Class clazz, Object object, Modifiers modifiers) throws UtilEvalError {
        this.name = string;
        this.type = clazz;
        this.modifiers = modifiers;
        this.setValue(object, 0);
    }

    public void setValue(Object object, int n) throws UtilEvalError {
        if (this.hasModifier("final") && this.value != null) {
            throw new UtilEvalError("Final variable, can't re-assign.");
        }
        if (object == null) {
            object = Primitive.getDefaultValue(this.type);
        }
        if (this.lhs != null) {
            this.lhs.assign(object, false);
            return;
        }
        if (this.type != null) {
            object = Types.castObject(object, this.type, n == 0 ? 0 : 1);
        }
        this.value = object;
    }

    Object getValue() throws UtilEvalError {
        if (this.lhs != null) {
            return this.lhs.getValue();
        }
        return this.value;
    }

    public Class getType() {
        return this.type;
    }

    public String getTypeDescriptor() {
        return this.typeDescriptor;
    }

    public Modifiers getModifiers() {
        return this.modifiers;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasModifier(String string) {
        return this.modifiers != null && this.modifiers.hasModifier(string);
    }

    public String toString() {
        return "Variable: " + super.toString() + " " + this.name + ", type:" + this.type + ", value:" + this.value + ", lhs = " + this.lhs;
    }
}

