/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import org.gradle.BuildResult;
import org.gradle.api.Action;
import org.gradle.api.artifacts.DependencySubstitutions;
import org.gradle.api.initialization.IncludedBuild;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DefaultDependencySubstitutions;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DependencySubstitutionsInternal;
import org.gradle.api.tasks.TaskReference;
import org.gradle.composite.internal.IncludedBuildInternal;
import org.gradle.composite.internal.IncludedBuildTaskReference;
import org.gradle.initialization.GradleLauncher;
import org.gradle.internal.Factory;

public class DefaultIncludedBuild
implements IncludedBuildInternal {
    private final File projectDir;
    private final Factory<GradleLauncher> gradleLauncherFactory;
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
    private final List<Action<? super DependencySubstitutions>> dependencySubstitutionActions = Lists.newArrayList();
    private DefaultDependencySubstitutions dependencySubstitutions;
    private GradleLauncher gradleLauncher;
    private SettingsInternal settings;
    private GradleInternal gradle;

    public DefaultIncludedBuild(File projectDir, Factory<GradleLauncher> launcherFactory, ImmutableModuleIdentifierFactory moduleIdentifierFactory) {
        this.projectDir = projectDir;
        this.gradleLauncherFactory = launcherFactory;
        this.moduleIdentifierFactory = moduleIdentifierFactory;
    }

    public File getProjectDir() {
        return this.projectDir;
    }

    public TaskReference task(String path) {
        Preconditions.checkArgument((boolean)path.startsWith(":"), (String)"Task path '%s' is not a qualified task path (e.g. ':task' or ':project:task').", (Object[])new Object[]{path});
        return new IncludedBuildTaskReference(this.getName(), path);
    }

    public synchronized String getName() {
        return this.getLoadedSettings().getRootProject().getName();
    }

    public void dependencySubstitution(Action<? super DependencySubstitutions> action) {
        if (this.dependencySubstitutions != null) {
            throw new IllegalStateException("Cannot configure included build after dependency substitutions are resolved.");
        }
        this.dependencySubstitutionActions.add(action);
    }

    @Override
    public DependencySubstitutionsInternal resolveDependencySubstitutions() {
        if (this.dependencySubstitutions == null) {
            this.dependencySubstitutions = DefaultDependencySubstitutions.forIncludedBuild((IncludedBuild)this, (ImmutableModuleIdentifierFactory)this.moduleIdentifierFactory);
            for (Action<? super DependencySubstitutions> action : this.dependencySubstitutionActions) {
                action.execute((Object)this.dependencySubstitutions);
            }
        }
        return this.dependencySubstitutions;
    }

    @Override
    public SettingsInternal getLoadedSettings() {
        if (this.settings == null) {
            GradleLauncher gradleLauncher = this.getGradleLauncher();
            gradleLauncher.load();
            this.settings = gradleLauncher.getSettings();
        }
        return this.settings;
    }

    @Override
    public GradleInternal getConfiguredBuild() {
        if (this.gradle == null) {
            GradleLauncher gradleLauncher = this.getGradleLauncher();
            gradleLauncher.getBuildAnalysis();
            this.settings = gradleLauncher.getSettings();
            this.gradle = gradleLauncher.getGradle();
        }
        return this.gradle;
    }

    private GradleLauncher getGradleLauncher() {
        if (this.gradleLauncher == null) {
            this.gradleLauncher = (GradleLauncher)this.gradleLauncherFactory.create();
            this.reset();
        }
        return this.gradleLauncher;
    }

    private void reset() {
        this.gradle = null;
        this.settings = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BuildResult execute(Iterable<String> tasks) {
        GradleLauncher launcher = this.getGradleLauncher();
        launcher.getGradle().getStartParameter().setTaskNames(tasks);
        try {
            BuildResult buildResult = launcher.run();
            return buildResult;
        }
        finally {
            this.markAsNotReusable();
        }
    }

    private void markAsNotReusable() {
        this.gradleLauncher = null;
    }

    public String toString() {
        return String.format("includedBuild[%s]", this.projectDir.getPath());
    }
}

