/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.io;

import java.io.DataInput;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.util.io.AbstractStringEnumerator;
import org.jetbrains.kotlin.com.intellij.util.io.DataInputOutputUtil;

public class StringRef {
    public static final StringRef[] EMPTY_ARRAY = new StringRef[0];
    private int id;
    private String name;
    private final AbstractStringEnumerator store;

    private StringRef(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/util/io/StringRef", "<init>"));
        }
        this.name = name2;
        this.id = -1;
        this.store = null;
    }

    private StringRef(int id, @NotNull AbstractStringEnumerator store2) {
        if (store2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "store", "org/jetbrains/kotlin/com/intellij/util/io/StringRef", "<init>"));
        }
        this.id = id;
        this.store = store2;
        this.name = null;
    }

    public String getString() {
        String name2 = this.name;
        if (name2 == null) {
            try {
                this.name = name2 = (String)this.store.valueOf(this.id);
            }
            catch (IOException e) {
                this.store.markCorrupted();
                throw new RuntimeException(e);
            }
        }
        return name2;
    }

    public String toString() {
        return this.getString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object that) {
        return that == this || that instanceof StringRef && this.toString().equals(that.toString());
    }

    @Nullable
    public static String toString(@Nullable StringRef ref) {
        return ref != null ? ref.getString() : null;
    }

    @Nullable
    public static StringRef fromString(@Nullable String source) {
        return source == null ? null : new StringRef(source);
    }

    @Nullable
    public static StringRef fromStream(@NotNull DataInput in, @NotNull AbstractStringEnumerator store2) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "org/jetbrains/kotlin/com/intellij/util/io/StringRef", "fromStream"));
        }
        if (store2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "store", "org/jetbrains/kotlin/com/intellij/util/io/StringRef", "fromStream"));
        }
        int nameId = DataInputOutputUtil.readINT(in);
        return nameId != 0 ? new StringRef(nameId, store2) : null;
    }

    @NotNull
    public static StringRef[] createArray(int count) {
        StringRef[] stringRefArray = count == 0 ? EMPTY_ARRAY : new StringRef[count];
        if (stringRefArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/io/StringRef", "createArray"));
        }
        return stringRefArray;
    }
}

