/*
 * Copyright 2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gradle.script.lang.kotlin

import org.gradle.api.artifacts.Configuration
import org.gradle.api.artifacts.ConfigurationContainer
import org.gradle.api.artifacts.Dependency
import org.gradle.api.artifacts.ExternalModuleDependency
import org.gradle.api.artifacts.ModuleDependency

import org.gradle.api.artifacts.dsl.DependencyHandler


/**
 * The 'apiElements' configuration.
 */
val ConfigurationContainer.apiElements: Configuration
    get() = getByName("apiElements")

/**
* Adds a dependency to the 'apiElements' configuration.
*
* @param dependencyNotation notation for the dependency to be added.
* @return The dependency.
*
* @see DependencyHandler.add
*/
fun DependencyHandler.apiElements(dependencyNotation: Any): Dependency =
    add("apiElements", dependencyNotation)

/**
* Adds a dependency to the 'apiElements' configuration.
*
* @param dependencyNotation notation for the dependency to be added.
* @param dependencyConfiguration expression to use to configure the dependency.
* @return The dependency.
*
* @see DependencyHandler.add
*/
inline fun DependencyHandler.apiElements(
    dependencyNotation: String,
    dependencyConfiguration: ExternalModuleDependency.() -> Unit): ExternalModuleDependency =
    add("apiElements", dependencyNotation, dependencyConfiguration)

/**
* Adds a dependency to the 'apiElements' configuration.
*
* @param group the group of the module to be added as a dependency.
* @param name the name of the module to be added as a dependency.
* @param version the optional version of the module to be added as a dependency.
* @param configuration the optional configuration of the module to be added as a dependency.
* @param classifier the optional classifier of the module artifact to be added as a dependency.
* @param ext the optional extension of the module artifact to be added as a dependency.
* @return The dependency.
*
* @see DependencyHandler.add
*/
fun DependencyHandler.apiElements(
    group: String,
    name: String,
    version: String? = null,
    configuration: String? = null,
    classifier: String? = null,
    ext: String? = null): ExternalModuleDependency =
    create(group, name, version, configuration, classifier, ext).apply { add("apiElements", this) }

/**
* Adds a dependency to the 'apiElements' configuration.
*
* @param group the group of the module to be added as a dependency.
* @param name the name of the module to be added as a dependency.
* @param version the optional version of the module to be added as a dependency.
* @param configuration the optional configuration of the module to be added as a dependency.
* @param classifier the optional classifier of the module artifact to be added as a dependency.
* @param ext the optional extension of the module artifact to be added as a dependency.
* @param dependencyConfiguration expression to use to configure the dependency.
* @return The dependency.
*
* @see DependencyHandler.create
* @see DependencyHandler.add
*/
inline fun DependencyHandler.apiElements(
    group: String,
    name: String,
    version: String? = null,
    configuration: String? = null,
    classifier: String? = null,
    ext: String? = null,
    dependencyConfiguration: ExternalModuleDependency.() -> Unit): ExternalModuleDependency =
    add("apiElements", create(group, name, version, configuration, classifier, ext), dependencyConfiguration)

/**
* Adds a dependency to the 'apiElements' configuration.
*
* @param dependency dependency to be added.
* @param dependencyConfiguration expression to use to configure the dependency.
* @return The dependency.
*
* @see DependencyHandler.add
*/
inline fun <T : ModuleDependency> DependencyHandler.apiElements(dependency: T, dependencyConfiguration: T.() -> Unit): T =
    add("apiElements", dependency, dependencyConfiguration)
    


/**
 * The 'archives' configuration.
 */
val ConfigurationContainer.archives: Configuration
    get() = getByName("archives")

/**
* Adds a dependency to the 'archives' configuration.
*
* @param dependencyNotation notation for the dependency to be added.
* @return The dependency.
*
* @see DependencyHandler.add
*/
fun DependencyHandler.archives(dependencyNotation: Any): Dependency =
    add("archives", dependencyNotation)

/**
* Adds a dependency to the 'archives' configuration.
*
* @param dependencyNotation notation for the dependency to be added.
* @param dependencyConfiguration expression to use to configure the dependency.
* @return The dependency.
*
* @see DependencyHandler.add
*/
inline fun DependencyHandler.archives(
    dependencyNotation: String,
    dependencyConfiguration: ExternalModuleDependency.() -> Unit): ExternalModuleDependency =
    add("archives", dependencyNotation, dependencyConfiguration)

/**
* Adds a dependency to the 'archives' configuration.
*
* @param group the group of the module to be added as a dependency.
* @param name the name of the module to be added as a dependency.
* @param version the optional version of the module to be added as a dependency.
* @param configuration the optional configuration of the module to be added as a dependency.
* @param classifier the optional classifier of the module artifact to be added as a dependency.
* @param ext the optional extension of the module artifact to be added as a dependency.
* @return The dependency.
*
* @see DependencyHandler.add
*/
fun DependencyHandler.archives(
    group: String,
    name: String,
    version: String? = null,
    configuration: String? = null,
    classifier: String? = null,
    ext: String? = null): ExternalModuleDependency =
    create(group, name, version, configuration, classifier, ext).apply { add("archives", this) }

/**
* Adds a dependency to the 'archives' configuration.
*
* @param group the group of the module to be added as a dependency.
* @param name the name of the module to be added as a dependency.
* @param version the optional version of the module to be added as a dependency.
* @param configuration the optional configuration of the module to be added as a dependency.
* @param classifier the optional classifier of the module artifact to be added as a dependency.
* @param ext the optional extension of the module artifact to be added as a dependency.
* @param dependencyConfiguration expression to use to configure the dependency.
* @return The dependency.
*
* @see DependencyHandler.create
* @see DependencyHandler.add
*/
inline fun DependencyHandler.archives(
    group: String,
    name: String,
    version: String? = null,
    configuration: String? = null,
    classifier: String? = null,
    ext: String? = null,
    dependencyConfiguration: ExternalModuleDependency.() -> Unit): ExternalModuleDependency =
    add("archives", create(group, name, version, configuration, classifier, ext), dependencyConfiguration)

/**
* Adds a dependency to the 'archives' configuration.
*
* @param dependency dependency to be added.
* @param dependencyConfiguration expression to use to configure the dependency.
* @return The dependency.
*
* @see DependencyHandler.add
*/
inline fun <T : ModuleDependency> DependencyHandler.archives(dependency: T, dependencyConfiguration: T.() -> Unit): T =
    add("archives", dependency, dependencyConfiguration)
    


/**
 * The 'compile' configuration.
 */
val ConfigurationContainer.compile: Configuration
    get() = getByName("compile")

/**
* Adds a dependency to the 'compile' configuration.
*
* @param dependencyNotation notation for the dependency to be added.
* @return The dependency.
*
* @see DependencyHandler.add
*/
fun DependencyHandler.compile(dependencyNotation: Any): Dependency =
    add("compile", dependencyNotation)

/**
* Adds a dependency to the 'compile' configuration.
*
* @param dependencyNotation notation for the dependency to be added.
* @param dependencyConfiguration expression to use to configure the dependency.
* @return The dependency.
*
* @see DependencyHandler.add
*/
inline fun DependencyHandler.compile(
    dependencyNotation: String,
    dependencyConfiguration: ExternalModuleDependency.() -> Unit): ExternalModuleDependency =
    add("compile", dependencyNotation, dependencyConfiguration)

/**
* Adds a dependency to the 'compile' configuration.
*
* @param group the group of the module to be added as a dependency.
* @param name the name of the module to be added as a dependency.
* @param version the optional version of the module to be added as a dependency.
* @param configuration the optional configuration of the module to be added as a dependency.
* @param classifier the optional classifier of the module artifact to be added as a dependency.
* @param ext the optional extension of the module artifact to be added as a dependency.
* @return The dependency.
*
* @see DependencyHandler.add
*/
fun DependencyHandler.compile(
    group: String,
    name: String,
    version: String? = null,
    configuration: String? = null,
    classifier: String? = null,
    ext: String? = null): ExternalModuleDependency =
    create(group, name, version, configuration, classifier, ext).apply { add("compile", this) }

/**
* Adds a dependency to the 'compile' configuration.
*
* @param group the group of the module to be added as a dependency.
* @param name the name of the module to be added as a dependency.
* @param version the optional version of the module to be added as a dependency.
* @param configuration the optional configuration of the module to be added as a dependency.
* @param classifier the optional classifier of the module artifact to be added as a dependency.
* @param ext the optional extension of the module artifact to be added as a dependency.
* @param dependencyConfiguration expression to use to configure the dependency.
* @return The dependency.
*
* @see DependencyHandler.create
* @see DependencyHandler.add
*/
inline fun DependencyHandler.compile(
    group: String,
    name: String,
    version: String? = null,
    configuration: String? = null,
    classifier: String? = null,
    ext: String? = null,
    dependencyConfiguration: ExternalModuleDependency.() -> Unit): ExternalModuleDependency =
    add("compile", create(group, name, version, configuration, classifier, ext), dependencyConfiguration)

/**
* Adds a dependency to the 'compile' configuration.
*
* @param dependency dependency to be added.
* @param dependencyConfiguration expression to use to configure the dependency.
* @return The dependency.
*
* @see DependencyHandler.add
*/
inline fun <T : ModuleDependency> DependencyHandler.compile(dependency: T, dependencyConfiguration: T.() -> Unit): T =
    add("compile", dependency, dependencyConfiguration)
    


/**
 * The 'compileClasspath' configuration.
 */
val ConfigurationContainer.compileClasspath: Configuration
    get() = getByName("compileClasspath")

/**
* Adds a dependency to the 'compileClasspath' configuration.
*
* @param dependencyNotation notation for the dependency to be added.
* @return The dependency.
*
* @see DependencyHandler.add
*/
fun DependencyHandler.compileClasspath(dependencyNotation: Any): Dependency =
    add("compileClasspath", dependencyNotation)

/**
* Adds a dependency to the 'compileClasspath' configuration.
*
* @param dependencyNotation notation for the dependency to be added.
* @param dependencyConfiguration expression to use to configure the dependency.
* @return The dependency.
*
* @see DependencyHandler.add
*/
inline fun DependencyHandler.compileClasspath(
    dependencyNotation: String,
    dependencyConfiguration: ExternalModuleDependency.() -> Unit): ExternalModuleDependency =
    add("compileClasspath", dependencyNotation, dependencyConfiguration)

/**
* Adds a dependency to the 'compileClasspath' configuration.
*
* @param group the group of the module to be added as a dependency.
* @param name the name of the module to be added as a dependency.
* @param version the optional version of the module to be added as a dependency.
* @param configuration the optional configuration of the module to be added as a dependency.
* @param classifier the optional classifier of the module artifact to be added as a dependency.
* @param ext the optional extension of the module artifact to be added as a dependency.
* @return The dependency.
*
* @see DependencyHandler.add
*/
fun DependencyHandler.compileClasspath(
    group: String,
    name: String,
    version: String? = null,
    configuration: String? = null,
    classifier: String? = null,
    ext: String? = null): ExternalModuleDependency =
    create(group, name, version, configuration, classifier, ext).apply { add("compileClasspath", this) }

/**
* Adds a dependency to the 'compileClasspath' configuration.
*
* @param group the group of the module to be added as a dependency.
* @param name the name of the module to be added as a dependency.
* @param version the optional version of the module to be added as a dependency.
* @param configuration the optional configuration of the module to be added as a dependency.
* @param classifier the optional classifier of the module artifact to be added as a dependency.
* @param ext the optional extension of the module artifact to be added as a dependency.
* @param dependencyConfiguration expression to use to configure the dependency.
* @return The dependency.
*
* @see DependencyHandler.create
* @see DependencyHandler.add
*/
inline fun DependencyHandler.compileClasspath(
    group: String,
    name: String,
    version: String? = null,
    configuration: String? = null,
    classifier: String? = null,
    ext: String? = null,
    dependencyConfiguration: ExternalModuleDependency.() -> Unit): ExternalModuleDependency =
    add("compileClasspath", create(group, name, version, configuration, classifier, ext), dependencyConfiguration)

/**
* Adds a dependency to the 'compileClasspath' configuration.
*
* @param dependency dependency to be added.
* @param dependencyConfiguration expression to use to configure the dependency.
* @return The dependency.
*
* @see DependencyHandler.add
*/
inline fun <T : ModuleDependency> DependencyHandler.compileClasspath(dependency: T, dependencyConfiguration: T.() -> Unit): T =
    add("compileClasspath", dependency, dependencyConfiguration)
    


/**
 * The 'compileOnly' configuration.
 */
val ConfigurationContainer.compileOnly: Configuration
    get() = getByName("compileOnly")

/**
* Adds a dependency to the 'compileOnly' configuration.
*
* @param dependencyNotation notation for the dependency to be added.
* @return The dependency.
*
* @see DependencyHandler.add
*/
fun DependencyHandler.compileOnly(dependencyNotation: Any): Dependency =
    add("compileOnly", dependencyNotation)

/**
* Adds a dependency to the 'compileOnly' configuration.
*
* @param dependencyNotation notation for the dependency to be added.
* @param dependencyConfiguration expression to use to configure the dependency.
* @return The dependency.
*
* @see DependencyHandler.add
*/
inline fun DependencyHandler.compileOnly(
    dependencyNotation: String,
    dependencyConfiguration: ExternalModuleDependency.() -> Unit): ExternalModuleDependency =
    add("compileOnly", dependencyNotation, dependencyConfiguration)

/**
* Adds a dependency to the 'compileOnly' configuration.
*
* @param group the group of the module to be added as a dependency.
* @param name the name of the module to be added as a dependency.
* @param version the optional version of the module to be added as a dependency.
* @param configuration the optional configuration of the module to be added as a dependency.
* @param classifier the optional classifier of the module artifact to be added as a dependency.
* @param ext the optional extension of the module artifact to be added as a dependency.
* @return The dependency.
*
* @see DependencyHandler.add
*/
fun DependencyHandler.compileOnly(
    group: String,
    name: String,
    version: String? = null,
    configuration: String? = null,
    classifier: String? = null,
    ext: String? = null): ExternalModuleDependency =
    create(group, name, version, configuration, classifier, ext).apply { add("compileOnly", this) }

/**
* Adds a dependency to the 'compileOnly' configuration.
*
* @param group the group of the module to be added as a dependency.
* @param name the name of the module to be added as a dependency.
* @param version the optional version of the module to be added as a dependency.
* @param configuration the optional configuration of the module to be added as a dependency.
* @param classifier the optional classifier of the module artifact to be added as a dependency.
* @param ext the optional extension of the module artifact to be added as a dependency.
* @param dependencyConfiguration expression to use to configure the dependency.
* @return The dependency.
*
* @see DependencyHandler.create
* @see DependencyHandler.add
*/
inline fun DependencyHandler.compileOnly(
    group: String,
    name: String,
    version: String? = null,
    configuration: String? = null,
    classifier: String? = null,
    ext: String? = null,
    dependencyConfiguration: ExternalModuleDependency.() -> Unit): ExternalModuleDependency =
    add("compileOnly", create(group, name, version, configuration, classifier, ext), dependencyConfiguration)

/**
* Adds a dependency to the 'compileOnly' configuration.
*
* @param dependency dependency to be added.
* @param dependencyConfiguration expression to use to configure the dependency.
* @return The dependency.
*
* @see DependencyHandler.add
*/
inline fun <T : ModuleDependency> DependencyHandler.compileOnly(dependency: T, dependencyConfiguration: T.() -> Unit): T =
    add("compileOnly", dependency, dependencyConfiguration)
    


/**
 * The 'default' configuration.
 */
val ConfigurationContainer.default: Configuration
    get() = getByName("default")

/**
* Adds a dependency to the 'default' configuration.
*
* @param dependencyNotation notation for the dependency to be added.
* @return The dependency.
*
* @see DependencyHandler.add
*/
fun DependencyHandler.default(dependencyNotation: Any): Dependency =
    add("default", dependencyNotation)

/**
* Adds a dependency to the 'default' configuration.
*
* @param dependencyNotation notation for the dependency to be added.
* @param dependencyConfiguration expression to use to configure the dependency.
* @return The dependency.
*
* @see DependencyHandler.add
*/
inline fun DependencyHandler.default(
    dependencyNotation: String,
    dependencyConfiguration: ExternalModuleDependency.() -> Unit): ExternalModuleDependency =
    add("default", dependencyNotation, dependencyConfiguration)

/**
* Adds a dependency to the 'default' configuration.
*
* @param group the group of the module to be added as a dependency.
* @param name the name of the module to be added as a dependency.
* @param version the optional version of the module to be added as a dependency.
* @param configuration the optional configuration of the module to be added as a dependency.
* @param classifier the optional classifier of the module artifact to be added as a dependency.
* @param ext the optional extension of the module artifact to be added as a dependency.
* @return The dependency.
*
* @see DependencyHandler.add
*/
fun DependencyHandler.default(
    group: String,
    name: String,
    version: String? = null,
    configuration: String? = null,
    classifier: String? = null,
    ext: String? = null): ExternalModuleDependency =
    create(group, name, version, configuration, classifier, ext).apply { add("default", this) }

/**
* Adds a dependency to the 'default' configuration.
*
* @param group the group of the module to be added as a dependency.
* @param name the name of the module to be added as a dependency.
* @param version the optional version of the module to be added as a dependency.
* @param configuration the optional configuration of the module to be added as a dependency.
* @param classifier the optional classifier of the module artifact to be added as a dependency.
* @param ext the optional extension of the module artifact to be added as a dependency.
* @param dependencyConfiguration expression to use to configure the dependency.
* @return The dependency.
*
* @see DependencyHandler.create
* @see DependencyHandler.add
*/
inline fun DependencyHandler.default(
    group: String,
    name: String,
    version: String? = null,
    configuration: String? = null,
    classifier: String? = null,
    ext: String? = null,
    dependencyConfiguration: ExternalModuleDependency.() -> Unit): ExternalModuleDependency =
    add("default", create(group, name, version, configuration, classifier, ext), dependencyConfiguration)

/**
* Adds a dependency to the 'default' configuration.
*
* @param dependency dependency to be added.
* @param dependencyConfiguration expression to use to configure the dependency.
* @return The dependency.
*
* @see DependencyHandler.add
*/
inline fun <T : ModuleDependency> DependencyHandler.default(dependency: T, dependencyConfiguration: T.() -> Unit): T =
    add("default", dependency, dependencyConfiguration)
    


/**
 * The 'implementation' configuration.
 */
val ConfigurationContainer.implementation: Configuration
    get() = getByName("implementation")

/**
* Adds a dependency to the 'implementation' configuration.
*
* @param dependencyNotation notation for the dependency to be added.
* @return The dependency.
*
* @see DependencyHandler.add
*/
fun DependencyHandler.implementation(dependencyNotation: Any): Dependency =
    add("implementation", dependencyNotation)

/**
* Adds a dependency to the 'implementation' configuration.
*
* @param dependencyNotation notation for the dependency to be added.
* @param dependencyConfiguration expression to use to configure the dependency.
* @return The dependency.
*
* @see DependencyHandler.add
*/
inline fun DependencyHandler.implementation(
    dependencyNotation: String,
    dependencyConfiguration: ExternalModuleDependency.() -> Unit): ExternalModuleDependency =
    add("implementation", dependencyNotation, dependencyConfiguration)

/**
* Adds a dependency to the 'implementation' configuration.
*
* @param group the group of the module to be added as a dependency.
* @param name the name of the module to be added as a dependency.
* @param version the optional version of the module to be added as a dependency.
* @param configuration the optional configuration of the module to be added as a dependency.
* @param classifier the optional classifier of the module artifact to be added as a dependency.
* @param ext the optional extension of the module artifact to be added as a dependency.
* @return The dependency.
*
* @see DependencyHandler.add
*/
fun DependencyHandler.implementation(
    group: String,
    name: String,
    version: String? = null,
    configuration: String? = null,
    classifier: String? = null,
    ext: String? = null): ExternalModuleDependency =
    create(group, name, version, configuration, classifier, ext).apply { add("implementation", this) }

/**
* Adds a dependency to the 'implementation' configuration.
*
* @param group the group of the module to be added as a dependency.
* @param name the name of the module to be added as a dependency.
* @param version the optional version of the module to be added as a dependency.
* @param configuration the optional configuration of the module to be added as a dependency.
* @param classifier the optional classifier of the module artifact to be added as a dependency.
* @param ext the optional extension of the module artifact to be added as a dependency.
* @param dependencyConfiguration expression to use to configure the dependency.
* @return The dependency.
*
* @see DependencyHandler.create
* @see DependencyHandler.add
*/
inline fun DependencyHandler.implementation(
    group: String,
    name: String,
    version: String? = null,
    configuration: String? = null,
    classifier: String? = null,
    ext: String? = null,
    dependencyConfiguration: ExternalModuleDependency.() -> Unit): ExternalModuleDependency =
    add("implementation", create(group, name, version, configuration, classifier, ext), dependencyConfiguration)

/**
* Adds a dependency to the 'implementation' configuration.
*
* @param dependency dependency to be added.
* @param dependencyConfiguration expression to use to configure the dependency.
* @return The dependency.
*
* @see DependencyHandler.add
*/
inline fun <T : ModuleDependency> DependencyHandler.implementation(dependency: T, dependencyConfiguration: T.() -> Unit): T =
    add("implementation", dependency, dependencyConfiguration)
    


/**
 * The 'kapt' configuration.
 */
val ConfigurationContainer.kapt: Configuration
    get() = getByName("kapt")

/**
* Adds a dependency to the 'kapt' configuration.
*
* @param dependencyNotation notation for the dependency to be added.
* @return The dependency.
*
* @see DependencyHandler.add
*/
fun DependencyHandler.kapt(dependencyNotation: Any): Dependency =
    add("kapt", dependencyNotation)

/**
* Adds a dependency to the 'kapt' configuration.
*
* @param dependencyNotation notation for the dependency to be added.
* @param dependencyConfiguration expression to use to configure the dependency.
* @return The dependency.
*
* @see DependencyHandler.add
*/
inline fun DependencyHandler.kapt(
    dependencyNotation: String,
    dependencyConfiguration: ExternalModuleDependency.() -> Unit): ExternalModuleDependency =
    add("kapt", dependencyNotation, dependencyConfiguration)

/**
* Adds a dependency to the 'kapt' configuration.
*
* @param group the group of the module to be added as a dependency.
* @param name the name of the module to be added as a dependency.
* @param version the optional version of the module to be added as a dependency.
* @param configuration the optional configuration of the module to be added as a dependency.
* @param classifier the optional classifier of the module artifact to be added as a dependency.
* @param ext the optional extension of the module artifact to be added as a dependency.
* @return The dependency.
*
* @see DependencyHandler.add
*/
fun DependencyHandler.kapt(
    group: String,
    name: String,
    version: String? = null,
    configuration: String? = null,
    classifier: String? = null,
    ext: String? = null): ExternalModuleDependency =
    create(group, name, version, configuration, classifier, ext).apply { add("kapt", this) }

/**
* Adds a dependency to the 'kapt' configuration.
*
* @param group the group of the module to be added as a dependency.
* @param name the name of the module to be added as a dependency.
* @param version the optional version of the module to be added as a dependency.
* @param configuration the optional configuration of the module to be added as a dependency.
* @param classifier the optional classifier of the module artifact to be added as a dependency.
* @param ext the optional extension of the module artifact to be added as a dependency.
* @param dependencyConfiguration expression to use to configure the dependency.
* @return The dependency.
*
* @see DependencyHandler.create
* @see DependencyHandler.add
*/
inline fun DependencyHandler.kapt(
    group: String,
    name: String,
    version: String? = null,
    configuration: String? = null,
    classifier: String? = null,
    ext: String? = null,
    dependencyConfiguration: ExternalModuleDependency.() -> Unit): ExternalModuleDependency =
    add("kapt", create(group, name, version, configuration, classifier, ext), dependencyConfiguration)

/**
* Adds a dependency to the 'kapt' configuration.
*
* @param dependency dependency to be added.
* @param dependencyConfiguration expression to use to configure the dependency.
* @return The dependency.
*
* @see DependencyHandler.add
*/
inline fun <T : ModuleDependency> DependencyHandler.kapt(dependency: T, dependencyConfiguration: T.() -> Unit): T =
    add("kapt", dependency, dependencyConfiguration)
    


/**
 * The 'kaptTest' configuration.
 */
val ConfigurationContainer.kaptTest: Configuration
    get() = getByName("kaptTest")

/**
* Adds a dependency to the 'kaptTest' configuration.
*
* @param dependencyNotation notation for the dependency to be added.
* @return The dependency.
*
* @see DependencyHandler.add
*/
fun DependencyHandler.kaptTest(dependencyNotation: Any): Dependency =
    add("kaptTest", dependencyNotation)

/**
* Adds a dependency to the 'kaptTest' configuration.
*
* @param dependencyNotation notation for the dependency to be added.
* @param dependencyConfiguration expression to use to configure the dependency.
* @return The dependency.
*
* @see DependencyHandler.add
*/
inline fun DependencyHandler.kaptTest(
    dependencyNotation: String,
    dependencyConfiguration: ExternalModuleDependency.() -> Unit): ExternalModuleDependency =
    add("kaptTest", dependencyNotation, dependencyConfiguration)

/**
* Adds a dependency to the 'kaptTest' configuration.
*
* @param group the group of the module to be added as a dependency.
* @param name the name of the module to be added as a dependency.
* @param version the optional version of the module to be added as a dependency.
* @param configuration the optional configuration of the module to be added as a dependency.
* @param classifier the optional classifier of the module artifact to be added as a dependency.
* @param ext the optional extension of the module artifact to be added as a dependency.
* @return The dependency.
*
* @see DependencyHandler.add
*/
fun DependencyHandler.kaptTest(
    group: String,
    name: String,
    version: String? = null,
    configuration: String? = null,
    classifier: String? = null,
    ext: String? = null): ExternalModuleDependency =
    create(group, name, version, configuration, classifier, ext).apply { add("kaptTest", this) }

/**
* Adds a dependency to the 'kaptTest' configuration.
*
* @param group the group of the module to be added as a dependency.
* @param name the name of the module to be added as a dependency.
* @param version the optional version of the module to be added as a dependency.
* @param configuration the optional configuration of the module to be added as a dependency.
* @param classifier the optional classifier of the module artifact to be added as a dependency.
* @param ext the optional extension of the module artifact to be added as a dependency.
* @param dependencyConfiguration expression to use to configure the dependency.
* @return The dependency.
*
* @see DependencyHandler.create
* @see DependencyHandler.add
*/
inline fun DependencyHandler.kaptTest(
    group: String,
    name: String,
    version: String? = null,
    configuration: String? = null,
    classifier: String? = null,
    ext: String? = null,
    dependencyConfiguration: ExternalModuleDependency.() -> Unit): ExternalModuleDependency =
    add("kaptTest", create(group, name, version, configuration, classifier, ext), dependencyConfiguration)

/**
* Adds a dependency to the 'kaptTest' configuration.
*
* @param dependency dependency to be added.
* @param dependencyConfiguration expression to use to configure the dependency.
* @return The dependency.
*
* @see DependencyHandler.add
*/
inline fun <T : ModuleDependency> DependencyHandler.kaptTest(dependency: T, dependencyConfiguration: T.() -> Unit): T =
    add("kaptTest", dependency, dependencyConfiguration)
    


/**
 * The 'runtime' configuration.
 */
val ConfigurationContainer.runtime: Configuration
    get() = getByName("runtime")

/**
* Adds a dependency to the 'runtime' configuration.
*
* @param dependencyNotation notation for the dependency to be added.
* @return The dependency.
*
* @see DependencyHandler.add
*/
fun DependencyHandler.runtime(dependencyNotation: Any): Dependency =
    add("runtime", dependencyNotation)

/**
* Adds a dependency to the 'runtime' configuration.
*
* @param dependencyNotation notation for the dependency to be added.
* @param dependencyConfiguration expression to use to configure the dependency.
* @return The dependency.
*
* @see DependencyHandler.add
*/
inline fun DependencyHandler.runtime(
    dependencyNotation: String,
    dependencyConfiguration: ExternalModuleDependency.() -> Unit): ExternalModuleDependency =
    add("runtime", dependencyNotation, dependencyConfiguration)

/**
* Adds a dependency to the 'runtime' configuration.
*
* @param group the group of the module to be added as a dependency.
* @param name the name of the module to be added as a dependency.
* @param version the optional version of the module to be added as a dependency.
* @param configuration the optional configuration of the module to be added as a dependency.
* @param classifier the optional classifier of the module artifact to be added as a dependency.
* @param ext the optional extension of the module artifact to be added as a dependency.
* @return The dependency.
*
* @see DependencyHandler.add
*/
fun DependencyHandler.runtime(
    group: String,
    name: String,
    version: String? = null,
    configuration: String? = null,
    classifier: String? = null,
    ext: String? = null): ExternalModuleDependency =
    create(group, name, version, configuration, classifier, ext).apply { add("runtime", this) }

/**
* Adds a dependency to the 'runtime' configuration.
*
* @param group the group of the module to be added as a dependency.
* @param name the name of the module to be added as a dependency.
* @param version the optional version of the module to be added as a dependency.
* @param configuration the optional configuration of the module to be added as a dependency.
* @param classifier the optional classifier of the module artifact to be added as a dependency.
* @param ext the optional extension of the module artifact to be added as a dependency.
* @param dependencyConfiguration expression to use to configure the dependency.
* @return The dependency.
*
* @see DependencyHandler.create
* @see DependencyHandler.add
*/
inline fun DependencyHandler.runtime(
    group: String,
    name: String,
    version: String? = null,
    configuration: String? = null,
    classifier: String? = null,
    ext: String? = null,
    dependencyConfiguration: ExternalModuleDependency.() -> Unit): ExternalModuleDependency =
    add("runtime", create(group, name, version, configuration, classifier, ext), dependencyConfiguration)

/**
* Adds a dependency to the 'runtime' configuration.
*
* @param dependency dependency to be added.
* @param dependencyConfiguration expression to use to configure the dependency.
* @return The dependency.
*
* @see DependencyHandler.add
*/
inline fun <T : ModuleDependency> DependencyHandler.runtime(dependency: T, dependencyConfiguration: T.() -> Unit): T =
    add("runtime", dependency, dependencyConfiguration)
    


/**
 * The 'runtimeClasspath' configuration.
 */
val ConfigurationContainer.runtimeClasspath: Configuration
    get() = getByName("runtimeClasspath")

/**
* Adds a dependency to the 'runtimeClasspath' configuration.
*
* @param dependencyNotation notation for the dependency to be added.
* @return The dependency.
*
* @see DependencyHandler.add
*/
fun DependencyHandler.runtimeClasspath(dependencyNotation: Any): Dependency =
    add("runtimeClasspath", dependencyNotation)

/**
* Adds a dependency to the 'runtimeClasspath' configuration.
*
* @param dependencyNotation notation for the dependency to be added.
* @param dependencyConfiguration expression to use to configure the dependency.
* @return The dependency.
*
* @see DependencyHandler.add
*/
inline fun DependencyHandler.runtimeClasspath(
    dependencyNotation: String,
    dependencyConfiguration: ExternalModuleDependency.() -> Unit): ExternalModuleDependency =
    add("runtimeClasspath", dependencyNotation, dependencyConfiguration)

/**
* Adds a dependency to the 'runtimeClasspath' configuration.
*
* @param group the group of the module to be added as a dependency.
* @param name the name of the module to be added as a dependency.
* @param version the optional version of the module to be added as a dependency.
* @param configuration the optional configuration of the module to be added as a dependency.
* @param classifier the optional classifier of the module artifact to be added as a dependency.
* @param ext the optional extension of the module artifact to be added as a dependency.
* @return The dependency.
*
* @see DependencyHandler.add
*/
fun DependencyHandler.runtimeClasspath(
    group: String,
    name: String,
    version: String? = null,
    configuration: String? = null,
    classifier: String? = null,
    ext: String? = null): ExternalModuleDependency =
    create(group, name, version, configuration, classifier, ext).apply { add("runtimeClasspath", this) }

/**
* Adds a dependency to the 'runtimeClasspath' configuration.
*
* @param group the group of the module to be added as a dependency.
* @param name the name of the module to be added as a dependency.
* @param version the optional version of the module to be added as a dependency.
* @param configuration the optional configuration of the module to be added as a dependency.
* @param classifier the optional classifier of the module artifact to be added as a dependency.
* @param ext the optional extension of the module artifact to be added as a dependency.
* @param dependencyConfiguration expression to use to configure the dependency.
* @return The dependency.
*
* @see DependencyHandler.create
* @see DependencyHandler.add
*/
inline fun DependencyHandler.runtimeClasspath(
    group: String,
    name: String,
    version: String? = null,
    configuration: String? = null,
    classifier: String? = null,
    ext: String? = null,
    dependencyConfiguration: ExternalModuleDependency.() -> Unit): ExternalModuleDependency =
    add("runtimeClasspath", create(group, name, version, configuration, classifier, ext), dependencyConfiguration)

/**
* Adds a dependency to the 'runtimeClasspath' configuration.
*
* @param dependency dependency to be added.
* @param dependencyConfiguration expression to use to configure the dependency.
* @return The dependency.
*
* @see DependencyHandler.add
*/
inline fun <T : ModuleDependency> DependencyHandler.runtimeClasspath(dependency: T, dependencyConfiguration: T.() -> Unit): T =
    add("runtimeClasspath", dependency, dependencyConfiguration)
    


/**
 * The 'runtimeElements' configuration.
 */
val ConfigurationContainer.runtimeElements: Configuration
    get() = getByName("runtimeElements")

/**
* Adds a dependency to the 'runtimeElements' configuration.
*
* @param dependencyNotation notation for the dependency to be added.
* @return The dependency.
*
* @see DependencyHandler.add
*/
fun DependencyHandler.runtimeElements(dependencyNotation: Any): Dependency =
    add("runtimeElements", dependencyNotation)

/**
* Adds a dependency to the 'runtimeElements' configuration.
*
* @param dependencyNotation notation for the dependency to be added.
* @param dependencyConfiguration expression to use to configure the dependency.
* @return The dependency.
*
* @see DependencyHandler.add
*/
inline fun DependencyHandler.runtimeElements(
    dependencyNotation: String,
    dependencyConfiguration: ExternalModuleDependency.() -> Unit): ExternalModuleDependency =
    add("runtimeElements", dependencyNotation, dependencyConfiguration)

/**
* Adds a dependency to the 'runtimeElements' configuration.
*
* @param group the group of the module to be added as a dependency.
* @param name the name of the module to be added as a dependency.
* @param version the optional version of the module to be added as a dependency.
* @param configuration the optional configuration of the module to be added as a dependency.
* @param classifier the optional classifier of the module artifact to be added as a dependency.
* @param ext the optional extension of the module artifact to be added as a dependency.
* @return The dependency.
*
* @see DependencyHandler.add
*/
fun DependencyHandler.runtimeElements(
    group: String,
    name: String,
    version: String? = null,
    configuration: String? = null,
    classifier: String? = null,
    ext: String? = null): ExternalModuleDependency =
    create(group, name, version, configuration, classifier, ext).apply { add("runtimeElements", this) }

/**
* Adds a dependency to the 'runtimeElements' configuration.
*
* @param group the group of the module to be added as a dependency.
* @param name the name of the module to be added as a dependency.
* @param version the optional version of the module to be added as a dependency.
* @param configuration the optional configuration of the module to be added as a dependency.
* @param classifier the optional classifier of the module artifact to be added as a dependency.
* @param ext the optional extension of the module artifact to be added as a dependency.
* @param dependencyConfiguration expression to use to configure the dependency.
* @return The dependency.
*
* @see DependencyHandler.create
* @see DependencyHandler.add
*/
inline fun DependencyHandler.runtimeElements(
    group: String,
    name: String,
    version: String? = null,
    configuration: String? = null,
    classifier: String? = null,
    ext: String? = null,
    dependencyConfiguration: ExternalModuleDependency.() -> Unit): ExternalModuleDependency =
    add("runtimeElements", create(group, name, version, configuration, classifier, ext), dependencyConfiguration)

/**
* Adds a dependency to the 'runtimeElements' configuration.
*
* @param dependency dependency to be added.
* @param dependencyConfiguration expression to use to configure the dependency.
* @return The dependency.
*
* @see DependencyHandler.add
*/
inline fun <T : ModuleDependency> DependencyHandler.runtimeElements(dependency: T, dependencyConfiguration: T.() -> Unit): T =
    add("runtimeElements", dependency, dependencyConfiguration)
    


/**
 * The 'runtimeOnly' configuration.
 */
val ConfigurationContainer.runtimeOnly: Configuration
    get() = getByName("runtimeOnly")

/**
* Adds a dependency to the 'runtimeOnly' configuration.
*
* @param dependencyNotation notation for the dependency to be added.
* @return The dependency.
*
* @see DependencyHandler.add
*/
fun DependencyHandler.runtimeOnly(dependencyNotation: Any): Dependency =
    add("runtimeOnly", dependencyNotation)

/**
* Adds a dependency to the 'runtimeOnly' configuration.
*
* @param dependencyNotation notation for the dependency to be added.
* @param dependencyConfiguration expression to use to configure the dependency.
* @return The dependency.
*
* @see DependencyHandler.add
*/
inline fun DependencyHandler.runtimeOnly(
    dependencyNotation: String,
    dependencyConfiguration: ExternalModuleDependency.() -> Unit): ExternalModuleDependency =
    add("runtimeOnly", dependencyNotation, dependencyConfiguration)

/**
* Adds a dependency to the 'runtimeOnly' configuration.
*
* @param group the group of the module to be added as a dependency.
* @param name the name of the module to be added as a dependency.
* @param version the optional version of the module to be added as a dependency.
* @param configuration the optional configuration of the module to be added as a dependency.
* @param classifier the optional classifier of the module artifact to be added as a dependency.
* @param ext the optional extension of the module artifact to be added as a dependency.
* @return The dependency.
*
* @see DependencyHandler.add
*/
fun DependencyHandler.runtimeOnly(
    group: String,
    name: String,
    version: String? = null,
    configuration: String? = null,
    classifier: String? = null,
    ext: String? = null): ExternalModuleDependency =
    create(group, name, version, configuration, classifier, ext).apply { add("runtimeOnly", this) }

/**
* Adds a dependency to the 'runtimeOnly' configuration.
*
* @param group the group of the module to be added as a dependency.
* @param name the name of the module to be added as a dependency.
* @param version the optional version of the module to be added as a dependency.
* @param configuration the optional configuration of the module to be added as a dependency.
* @param classifier the optional classifier of the module artifact to be added as a dependency.
* @param ext the optional extension of the module artifact to be added as a dependency.
* @param dependencyConfiguration expression to use to configure the dependency.
* @return The dependency.
*
* @see DependencyHandler.create
* @see DependencyHandler.add
*/
inline fun DependencyHandler.runtimeOnly(
    group: String,
    name: String,
    version: String? = null,
    configuration: String? = null,
    classifier: String? = null,
    ext: String? = null,
    dependencyConfiguration: ExternalModuleDependency.() -> Unit): ExternalModuleDependency =
    add("runtimeOnly", create(group, name, version, configuration, classifier, ext), dependencyConfiguration)

/**
* Adds a dependency to the 'runtimeOnly' configuration.
*
* @param dependency dependency to be added.
* @param dependencyConfiguration expression to use to configure the dependency.
* @return The dependency.
*
* @see DependencyHandler.add
*/
inline fun <T : ModuleDependency> DependencyHandler.runtimeOnly(dependency: T, dependencyConfiguration: T.() -> Unit): T =
    add("runtimeOnly", dependency, dependencyConfiguration)
    


/**
 * The 'testCompile' configuration.
 */
val ConfigurationContainer.testCompile: Configuration
    get() = getByName("testCompile")

/**
* Adds a dependency to the 'testCompile' configuration.
*
* @param dependencyNotation notation for the dependency to be added.
* @return The dependency.
*
* @see DependencyHandler.add
*/
fun DependencyHandler.testCompile(dependencyNotation: Any): Dependency =
    add("testCompile", dependencyNotation)

/**
* Adds a dependency to the 'testCompile' configuration.
*
* @param dependencyNotation notation for the dependency to be added.
* @param dependencyConfiguration expression to use to configure the dependency.
* @return The dependency.
*
* @see DependencyHandler.add
*/
inline fun DependencyHandler.testCompile(
    dependencyNotation: String,
    dependencyConfiguration: ExternalModuleDependency.() -> Unit): ExternalModuleDependency =
    add("testCompile", dependencyNotation, dependencyConfiguration)

/**
* Adds a dependency to the 'testCompile' configuration.
*
* @param group the group of the module to be added as a dependency.
* @param name the name of the module to be added as a dependency.
* @param version the optional version of the module to be added as a dependency.
* @param configuration the optional configuration of the module to be added as a dependency.
* @param classifier the optional classifier of the module artifact to be added as a dependency.
* @param ext the optional extension of the module artifact to be added as a dependency.
* @return The dependency.
*
* @see DependencyHandler.add
*/
fun DependencyHandler.testCompile(
    group: String,
    name: String,
    version: String? = null,
    configuration: String? = null,
    classifier: String? = null,
    ext: String? = null): ExternalModuleDependency =
    create(group, name, version, configuration, classifier, ext).apply { add("testCompile", this) }

/**
* Adds a dependency to the 'testCompile' configuration.
*
* @param group the group of the module to be added as a dependency.
* @param name the name of the module to be added as a dependency.
* @param version the optional version of the module to be added as a dependency.
* @param configuration the optional configuration of the module to be added as a dependency.
* @param classifier the optional classifier of the module artifact to be added as a dependency.
* @param ext the optional extension of the module artifact to be added as a dependency.
* @param dependencyConfiguration expression to use to configure the dependency.
* @return The dependency.
*
* @see DependencyHandler.create
* @see DependencyHandler.add
*/
inline fun DependencyHandler.testCompile(
    group: String,
    name: String,
    version: String? = null,
    configuration: String? = null,
    classifier: String? = null,
    ext: String? = null,
    dependencyConfiguration: ExternalModuleDependency.() -> Unit): ExternalModuleDependency =
    add("testCompile", create(group, name, version, configuration, classifier, ext), dependencyConfiguration)

/**
* Adds a dependency to the 'testCompile' configuration.
*
* @param dependency dependency to be added.
* @param dependencyConfiguration expression to use to configure the dependency.
* @return The dependency.
*
* @see DependencyHandler.add
*/
inline fun <T : ModuleDependency> DependencyHandler.testCompile(dependency: T, dependencyConfiguration: T.() -> Unit): T =
    add("testCompile", dependency, dependencyConfiguration)
    


/**
 * The 'testCompileClasspath' configuration.
 */
val ConfigurationContainer.testCompileClasspath: Configuration
    get() = getByName("testCompileClasspath")

/**
* Adds a dependency to the 'testCompileClasspath' configuration.
*
* @param dependencyNotation notation for the dependency to be added.
* @return The dependency.
*
* @see DependencyHandler.add
*/
fun DependencyHandler.testCompileClasspath(dependencyNotation: Any): Dependency =
    add("testCompileClasspath", dependencyNotation)

/**
* Adds a dependency to the 'testCompileClasspath' configuration.
*
* @param dependencyNotation notation for the dependency to be added.
* @param dependencyConfiguration expression to use to configure the dependency.
* @return The dependency.
*
* @see DependencyHandler.add
*/
inline fun DependencyHandler.testCompileClasspath(
    dependencyNotation: String,
    dependencyConfiguration: ExternalModuleDependency.() -> Unit): ExternalModuleDependency =
    add("testCompileClasspath", dependencyNotation, dependencyConfiguration)

/**
* Adds a dependency to the 'testCompileClasspath' configuration.
*
* @param group the group of the module to be added as a dependency.
* @param name the name of the module to be added as a dependency.
* @param version the optional version of the module to be added as a dependency.
* @param configuration the optional configuration of the module to be added as a dependency.
* @param classifier the optional classifier of the module artifact to be added as a dependency.
* @param ext the optional extension of the module artifact to be added as a dependency.
* @return The dependency.
*
* @see DependencyHandler.add
*/
fun DependencyHandler.testCompileClasspath(
    group: String,
    name: String,
    version: String? = null,
    configuration: String? = null,
    classifier: String? = null,
    ext: String? = null): ExternalModuleDependency =
    create(group, name, version, configuration, classifier, ext).apply { add("testCompileClasspath", this) }

/**
* Adds a dependency to the 'testCompileClasspath' configuration.
*
* @param group the group of the module to be added as a dependency.
* @param name the name of the module to be added as a dependency.
* @param version the optional version of the module to be added as a dependency.
* @param configuration the optional configuration of the module to be added as a dependency.
* @param classifier the optional classifier of the module artifact to be added as a dependency.
* @param ext the optional extension of the module artifact to be added as a dependency.
* @param dependencyConfiguration expression to use to configure the dependency.
* @return The dependency.
*
* @see DependencyHandler.create
* @see DependencyHandler.add
*/
inline fun DependencyHandler.testCompileClasspath(
    group: String,
    name: String,
    version: String? = null,
    configuration: String? = null,
    classifier: String? = null,
    ext: String? = null,
    dependencyConfiguration: ExternalModuleDependency.() -> Unit): ExternalModuleDependency =
    add("testCompileClasspath", create(group, name, version, configuration, classifier, ext), dependencyConfiguration)

/**
* Adds a dependency to the 'testCompileClasspath' configuration.
*
* @param dependency dependency to be added.
* @param dependencyConfiguration expression to use to configure the dependency.
* @return The dependency.
*
* @see DependencyHandler.add
*/
inline fun <T : ModuleDependency> DependencyHandler.testCompileClasspath(dependency: T, dependencyConfiguration: T.() -> Unit): T =
    add("testCompileClasspath", dependency, dependencyConfiguration)
    


/**
 * The 'testCompileOnly' configuration.
 */
val ConfigurationContainer.testCompileOnly: Configuration
    get() = getByName("testCompileOnly")

/**
* Adds a dependency to the 'testCompileOnly' configuration.
*
* @param dependencyNotation notation for the dependency to be added.
* @return The dependency.
*
* @see DependencyHandler.add
*/
fun DependencyHandler.testCompileOnly(dependencyNotation: Any): Dependency =
    add("testCompileOnly", dependencyNotation)

/**
* Adds a dependency to the 'testCompileOnly' configuration.
*
* @param dependencyNotation notation for the dependency to be added.
* @param dependencyConfiguration expression to use to configure the dependency.
* @return The dependency.
*
* @see DependencyHandler.add
*/
inline fun DependencyHandler.testCompileOnly(
    dependencyNotation: String,
    dependencyConfiguration: ExternalModuleDependency.() -> Unit): ExternalModuleDependency =
    add("testCompileOnly", dependencyNotation, dependencyConfiguration)

/**
* Adds a dependency to the 'testCompileOnly' configuration.
*
* @param group the group of the module to be added as a dependency.
* @param name the name of the module to be added as a dependency.
* @param version the optional version of the module to be added as a dependency.
* @param configuration the optional configuration of the module to be added as a dependency.
* @param classifier the optional classifier of the module artifact to be added as a dependency.
* @param ext the optional extension of the module artifact to be added as a dependency.
* @return The dependency.
*
* @see DependencyHandler.add
*/
fun DependencyHandler.testCompileOnly(
    group: String,
    name: String,
    version: String? = null,
    configuration: String? = null,
    classifier: String? = null,
    ext: String? = null): ExternalModuleDependency =
    create(group, name, version, configuration, classifier, ext).apply { add("testCompileOnly", this) }

/**
* Adds a dependency to the 'testCompileOnly' configuration.
*
* @param group the group of the module to be added as a dependency.
* @param name the name of the module to be added as a dependency.
* @param version the optional version of the module to be added as a dependency.
* @param configuration the optional configuration of the module to be added as a dependency.
* @param classifier the optional classifier of the module artifact to be added as a dependency.
* @param ext the optional extension of the module artifact to be added as a dependency.
* @param dependencyConfiguration expression to use to configure the dependency.
* @return The dependency.
*
* @see DependencyHandler.create
* @see DependencyHandler.add
*/
inline fun DependencyHandler.testCompileOnly(
    group: String,
    name: String,
    version: String? = null,
    configuration: String? = null,
    classifier: String? = null,
    ext: String? = null,
    dependencyConfiguration: ExternalModuleDependency.() -> Unit): ExternalModuleDependency =
    add("testCompileOnly", create(group, name, version, configuration, classifier, ext), dependencyConfiguration)

/**
* Adds a dependency to the 'testCompileOnly' configuration.
*
* @param dependency dependency to be added.
* @param dependencyConfiguration expression to use to configure the dependency.
* @return The dependency.
*
* @see DependencyHandler.add
*/
inline fun <T : ModuleDependency> DependencyHandler.testCompileOnly(dependency: T, dependencyConfiguration: T.() -> Unit): T =
    add("testCompileOnly", dependency, dependencyConfiguration)
    


/**
 * The 'testImplementation' configuration.
 */
val ConfigurationContainer.testImplementation: Configuration
    get() = getByName("testImplementation")

/**
* Adds a dependency to the 'testImplementation' configuration.
*
* @param dependencyNotation notation for the dependency to be added.
* @return The dependency.
*
* @see DependencyHandler.add
*/
fun DependencyHandler.testImplementation(dependencyNotation: Any): Dependency =
    add("testImplementation", dependencyNotation)

/**
* Adds a dependency to the 'testImplementation' configuration.
*
* @param dependencyNotation notation for the dependency to be added.
* @param dependencyConfiguration expression to use to configure the dependency.
* @return The dependency.
*
* @see DependencyHandler.add
*/
inline fun DependencyHandler.testImplementation(
    dependencyNotation: String,
    dependencyConfiguration: ExternalModuleDependency.() -> Unit): ExternalModuleDependency =
    add("testImplementation", dependencyNotation, dependencyConfiguration)

/**
* Adds a dependency to the 'testImplementation' configuration.
*
* @param group the group of the module to be added as a dependency.
* @param name the name of the module to be added as a dependency.
* @param version the optional version of the module to be added as a dependency.
* @param configuration the optional configuration of the module to be added as a dependency.
* @param classifier the optional classifier of the module artifact to be added as a dependency.
* @param ext the optional extension of the module artifact to be added as a dependency.
* @return The dependency.
*
* @see DependencyHandler.add
*/
fun DependencyHandler.testImplementation(
    group: String,
    name: String,
    version: String? = null,
    configuration: String? = null,
    classifier: String? = null,
    ext: String? = null): ExternalModuleDependency =
    create(group, name, version, configuration, classifier, ext).apply { add("testImplementation", this) }

/**
* Adds a dependency to the 'testImplementation' configuration.
*
* @param group the group of the module to be added as a dependency.
* @param name the name of the module to be added as a dependency.
* @param version the optional version of the module to be added as a dependency.
* @param configuration the optional configuration of the module to be added as a dependency.
* @param classifier the optional classifier of the module artifact to be added as a dependency.
* @param ext the optional extension of the module artifact to be added as a dependency.
* @param dependencyConfiguration expression to use to configure the dependency.
* @return The dependency.
*
* @see DependencyHandler.create
* @see DependencyHandler.add
*/
inline fun DependencyHandler.testImplementation(
    group: String,
    name: String,
    version: String? = null,
    configuration: String? = null,
    classifier: String? = null,
    ext: String? = null,
    dependencyConfiguration: ExternalModuleDependency.() -> Unit): ExternalModuleDependency =
    add("testImplementation", create(group, name, version, configuration, classifier, ext), dependencyConfiguration)

/**
* Adds a dependency to the 'testImplementation' configuration.
*
* @param dependency dependency to be added.
* @param dependencyConfiguration expression to use to configure the dependency.
* @return The dependency.
*
* @see DependencyHandler.add
*/
inline fun <T : ModuleDependency> DependencyHandler.testImplementation(dependency: T, dependencyConfiguration: T.() -> Unit): T =
    add("testImplementation", dependency, dependencyConfiguration)
    


/**
 * The 'testRuntime' configuration.
 */
val ConfigurationContainer.testRuntime: Configuration
    get() = getByName("testRuntime")

/**
* Adds a dependency to the 'testRuntime' configuration.
*
* @param dependencyNotation notation for the dependency to be added.
* @return The dependency.
*
* @see DependencyHandler.add
*/
fun DependencyHandler.testRuntime(dependencyNotation: Any): Dependency =
    add("testRuntime", dependencyNotation)

/**
* Adds a dependency to the 'testRuntime' configuration.
*
* @param dependencyNotation notation for the dependency to be added.
* @param dependencyConfiguration expression to use to configure the dependency.
* @return The dependency.
*
* @see DependencyHandler.add
*/
inline fun DependencyHandler.testRuntime(
    dependencyNotation: String,
    dependencyConfiguration: ExternalModuleDependency.() -> Unit): ExternalModuleDependency =
    add("testRuntime", dependencyNotation, dependencyConfiguration)

/**
* Adds a dependency to the 'testRuntime' configuration.
*
* @param group the group of the module to be added as a dependency.
* @param name the name of the module to be added as a dependency.
* @param version the optional version of the module to be added as a dependency.
* @param configuration the optional configuration of the module to be added as a dependency.
* @param classifier the optional classifier of the module artifact to be added as a dependency.
* @param ext the optional extension of the module artifact to be added as a dependency.
* @return The dependency.
*
* @see DependencyHandler.add
*/
fun DependencyHandler.testRuntime(
    group: String,
    name: String,
    version: String? = null,
    configuration: String? = null,
    classifier: String? = null,
    ext: String? = null): ExternalModuleDependency =
    create(group, name, version, configuration, classifier, ext).apply { add("testRuntime", this) }

/**
* Adds a dependency to the 'testRuntime' configuration.
*
* @param group the group of the module to be added as a dependency.
* @param name the name of the module to be added as a dependency.
* @param version the optional version of the module to be added as a dependency.
* @param configuration the optional configuration of the module to be added as a dependency.
* @param classifier the optional classifier of the module artifact to be added as a dependency.
* @param ext the optional extension of the module artifact to be added as a dependency.
* @param dependencyConfiguration expression to use to configure the dependency.
* @return The dependency.
*
* @see DependencyHandler.create
* @see DependencyHandler.add
*/
inline fun DependencyHandler.testRuntime(
    group: String,
    name: String,
    version: String? = null,
    configuration: String? = null,
    classifier: String? = null,
    ext: String? = null,
    dependencyConfiguration: ExternalModuleDependency.() -> Unit): ExternalModuleDependency =
    add("testRuntime", create(group, name, version, configuration, classifier, ext), dependencyConfiguration)

/**
* Adds a dependency to the 'testRuntime' configuration.
*
* @param dependency dependency to be added.
* @param dependencyConfiguration expression to use to configure the dependency.
* @return The dependency.
*
* @see DependencyHandler.add
*/
inline fun <T : ModuleDependency> DependencyHandler.testRuntime(dependency: T, dependencyConfiguration: T.() -> Unit): T =
    add("testRuntime", dependency, dependencyConfiguration)
    


/**
 * The 'testRuntimeClasspath' configuration.
 */
val ConfigurationContainer.testRuntimeClasspath: Configuration
    get() = getByName("testRuntimeClasspath")

/**
* Adds a dependency to the 'testRuntimeClasspath' configuration.
*
* @param dependencyNotation notation for the dependency to be added.
* @return The dependency.
*
* @see DependencyHandler.add
*/
fun DependencyHandler.testRuntimeClasspath(dependencyNotation: Any): Dependency =
    add("testRuntimeClasspath", dependencyNotation)

/**
* Adds a dependency to the 'testRuntimeClasspath' configuration.
*
* @param dependencyNotation notation for the dependency to be added.
* @param dependencyConfiguration expression to use to configure the dependency.
* @return The dependency.
*
* @see DependencyHandler.add
*/
inline fun DependencyHandler.testRuntimeClasspath(
    dependencyNotation: String,
    dependencyConfiguration: ExternalModuleDependency.() -> Unit): ExternalModuleDependency =
    add("testRuntimeClasspath", dependencyNotation, dependencyConfiguration)

/**
* Adds a dependency to the 'testRuntimeClasspath' configuration.
*
* @param group the group of the module to be added as a dependency.
* @param name the name of the module to be added as a dependency.
* @param version the optional version of the module to be added as a dependency.
* @param configuration the optional configuration of the module to be added as a dependency.
* @param classifier the optional classifier of the module artifact to be added as a dependency.
* @param ext the optional extension of the module artifact to be added as a dependency.
* @return The dependency.
*
* @see DependencyHandler.add
*/
fun DependencyHandler.testRuntimeClasspath(
    group: String,
    name: String,
    version: String? = null,
    configuration: String? = null,
    classifier: String? = null,
    ext: String? = null): ExternalModuleDependency =
    create(group, name, version, configuration, classifier, ext).apply { add("testRuntimeClasspath", this) }

/**
* Adds a dependency to the 'testRuntimeClasspath' configuration.
*
* @param group the group of the module to be added as a dependency.
* @param name the name of the module to be added as a dependency.
* @param version the optional version of the module to be added as a dependency.
* @param configuration the optional configuration of the module to be added as a dependency.
* @param classifier the optional classifier of the module artifact to be added as a dependency.
* @param ext the optional extension of the module artifact to be added as a dependency.
* @param dependencyConfiguration expression to use to configure the dependency.
* @return The dependency.
*
* @see DependencyHandler.create
* @see DependencyHandler.add
*/
inline fun DependencyHandler.testRuntimeClasspath(
    group: String,
    name: String,
    version: String? = null,
    configuration: String? = null,
    classifier: String? = null,
    ext: String? = null,
    dependencyConfiguration: ExternalModuleDependency.() -> Unit): ExternalModuleDependency =
    add("testRuntimeClasspath", create(group, name, version, configuration, classifier, ext), dependencyConfiguration)

/**
* Adds a dependency to the 'testRuntimeClasspath' configuration.
*
* @param dependency dependency to be added.
* @param dependencyConfiguration expression to use to configure the dependency.
* @return The dependency.
*
* @see DependencyHandler.add
*/
inline fun <T : ModuleDependency> DependencyHandler.testRuntimeClasspath(dependency: T, dependencyConfiguration: T.() -> Unit): T =
    add("testRuntimeClasspath", dependency, dependencyConfiguration)
    


/**
 * The 'testRuntimeOnly' configuration.
 */
val ConfigurationContainer.testRuntimeOnly: Configuration
    get() = getByName("testRuntimeOnly")

/**
* Adds a dependency to the 'testRuntimeOnly' configuration.
*
* @param dependencyNotation notation for the dependency to be added.
* @return The dependency.
*
* @see DependencyHandler.add
*/
fun DependencyHandler.testRuntimeOnly(dependencyNotation: Any): Dependency =
    add("testRuntimeOnly", dependencyNotation)

/**
* Adds a dependency to the 'testRuntimeOnly' configuration.
*
* @param dependencyNotation notation for the dependency to be added.
* @param dependencyConfiguration expression to use to configure the dependency.
* @return The dependency.
*
* @see DependencyHandler.add
*/
inline fun DependencyHandler.testRuntimeOnly(
    dependencyNotation: String,
    dependencyConfiguration: ExternalModuleDependency.() -> Unit): ExternalModuleDependency =
    add("testRuntimeOnly", dependencyNotation, dependencyConfiguration)

/**
* Adds a dependency to the 'testRuntimeOnly' configuration.
*
* @param group the group of the module to be added as a dependency.
* @param name the name of the module to be added as a dependency.
* @param version the optional version of the module to be added as a dependency.
* @param configuration the optional configuration of the module to be added as a dependency.
* @param classifier the optional classifier of the module artifact to be added as a dependency.
* @param ext the optional extension of the module artifact to be added as a dependency.
* @return The dependency.
*
* @see DependencyHandler.add
*/
fun DependencyHandler.testRuntimeOnly(
    group: String,
    name: String,
    version: String? = null,
    configuration: String? = null,
    classifier: String? = null,
    ext: String? = null): ExternalModuleDependency =
    create(group, name, version, configuration, classifier, ext).apply { add("testRuntimeOnly", this) }

/**
* Adds a dependency to the 'testRuntimeOnly' configuration.
*
* @param group the group of the module to be added as a dependency.
* @param name the name of the module to be added as a dependency.
* @param version the optional version of the module to be added as a dependency.
* @param configuration the optional configuration of the module to be added as a dependency.
* @param classifier the optional classifier of the module artifact to be added as a dependency.
* @param ext the optional extension of the module artifact to be added as a dependency.
* @param dependencyConfiguration expression to use to configure the dependency.
* @return The dependency.
*
* @see DependencyHandler.create
* @see DependencyHandler.add
*/
inline fun DependencyHandler.testRuntimeOnly(
    group: String,
    name: String,
    version: String? = null,
    configuration: String? = null,
    classifier: String? = null,
    ext: String? = null,
    dependencyConfiguration: ExternalModuleDependency.() -> Unit): ExternalModuleDependency =
    add("testRuntimeOnly", create(group, name, version, configuration, classifier, ext), dependencyConfiguration)

/**
* Adds a dependency to the 'testRuntimeOnly' configuration.
*
* @param dependency dependency to be added.
* @param dependencyConfiguration expression to use to configure the dependency.
* @return The dependency.
*
* @see DependencyHandler.add
*/
inline fun <T : ModuleDependency> DependencyHandler.testRuntimeOnly(dependency: T, dependencyConfiguration: T.() -> Unit): T =
    add("testRuntimeOnly", dependency, dependencyConfiguration)
    