/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ToggleUploadDiscouragedLayerAction
extends AbstractAction
implements Layer.LayerAction {
    private final transient OsmDataLayer layer;

    public ToggleUploadDiscouragedLayerAction(OsmDataLayer osmDataLayer) {
        super(I18n.tr("Discourage upload", new Object[0]), ImageProvider.get("no_upload"));
        this.layer = osmDataLayer;
        this.setEnabled(osmDataLayer.isUploadable());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.layer.setUploadDiscouraged(!this.layer.isUploadDiscouraged());
        LayerListDialog.getInstance().repaint();
    }

    @Override
    public Component createMenuComponent() {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(this);
        jCheckBoxMenuItem.setSelected(this.layer.isUploadDiscouraged() || !this.layer.isUploadable());
        return jCheckBoxMenuItem;
    }

    @Override
    public boolean supportLayers(List<Layer> list) {
        return list.size() == 1 && list.get(0) instanceof OsmDataLayer;
    }
}

