/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.flow;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.SwitchFlowContext;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;

public class LabelFlowContext
extends SwitchFlowContext {
    public char[] labelName;

    public LabelFlowContext(FlowContext flowContext, ASTNode aSTNode, char[] cArray, BranchLabel branchLabel, BlockScope blockScope) {
        super(flowContext, aSTNode, branchLabel, false);
        this.labelName = cArray;
        this.checkLabelValidity(blockScope);
    }

    void checkLabelValidity(BlockScope blockScope) {
        for (FlowContext flowContext = this.getLocalParent(); flowContext != null; flowContext = flowContext.getLocalParent()) {
            char[] cArray = flowContext.labelName();
            if (cArray == null || !CharOperation.equals(cArray, this.labelName)) continue;
            blockScope.problemReporter().alreadyDefinedLabel(this.labelName, this.associatedNode);
        }
    }

    @Override
    public String individualToString() {
        return "Label flow context [label:" + String.valueOf(this.labelName) + "]";
    }

    @Override
    public char[] labelName() {
        return this.labelName;
    }
}

