/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.geopoint.search;

import org.apache.lucene.geo.GeoUtils;
import org.apache.lucene.geo.Rectangle;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.spatial.geopoint.document.GeoPointField;
import org.apache.lucene.spatial.geopoint.search.GeoPointDistanceQueryImpl;
import org.apache.lucene.spatial.geopoint.search.GeoPointInBBoxQuery;

@Deprecated
public class GeoPointDistanceQuery
extends GeoPointInBBoxQuery {
    protected final double centerLat;
    protected final double centerLon;
    protected final double radiusMeters;
    protected final double sortKey;

    private static double checkRadius(double radiusMeters) {
        if (!Double.isFinite(radiusMeters) || radiusMeters < 0.0) {
            throw new IllegalArgumentException("invalid radiusMeters " + radiusMeters);
        }
        return radiusMeters;
    }

    private static double checkLatitude(double centerLat) {
        GeoUtils.checkLatitude((double)centerLat);
        return centerLat;
    }

    private static double checkLongitude(double centerLon) {
        GeoUtils.checkLongitude((double)centerLon);
        return centerLon;
    }

    public GeoPointDistanceQuery(String field, double centerLat, double centerLon, double radiusMeters) {
        this(field, GeoPointField.TermEncoding.PREFIX, GeoPointDistanceQuery.checkLatitude(centerLat), GeoPointDistanceQuery.checkLongitude(centerLon), GeoPointDistanceQuery.checkRadius(radiusMeters));
    }

    public GeoPointDistanceQuery(String field, GeoPointField.TermEncoding termEncoding, double centerLat, double centerLon, double radiusMeters) {
        this(field, termEncoding, Rectangle.fromPointDistance((double)centerLat, (double)centerLon, (double)GeoPointDistanceQuery.checkRadius(radiusMeters)), centerLat, centerLon, radiusMeters);
    }

    private GeoPointDistanceQuery(String field, GeoPointField.TermEncoding termEncoding, Rectangle bbox, double centerLat, double centerLon, double radiusMeters) {
        super(field, termEncoding, bbox.minLat, bbox.maxLat, bbox.minLon, bbox.maxLon);
        this.centerLat = centerLat;
        this.centerLon = centerLon;
        this.radiusMeters = radiusMeters;
        this.sortKey = GeoUtils.distanceQuerySortKey((double)radiusMeters);
    }

    @Override
    public Query rewrite(IndexReader reader) {
        if (this.maxLon < this.minLon) {
            BooleanQuery.Builder bqb = new BooleanQuery.Builder();
            double unwrappedLon = this.centerLon;
            if (unwrappedLon > this.maxLon) {
                unwrappedLon += -360.0;
            }
            GeoPointDistanceQueryImpl left = new GeoPointDistanceQueryImpl(this.field, this.termEncoding, this, unwrappedLon, new Rectangle(this.minLat, this.maxLat, -180.0, this.maxLon));
            bqb.add(new BooleanClause((Query)left, BooleanClause.Occur.SHOULD));
            if (unwrappedLon < this.maxLon) {
                unwrappedLon += 360.0;
            }
            GeoPointDistanceQueryImpl right = new GeoPointDistanceQueryImpl(this.field, this.termEncoding, this, unwrappedLon, new Rectangle(this.minLat, this.maxLat, this.minLon, 180.0));
            bqb.add(new BooleanClause((Query)right, BooleanClause.Occur.SHOULD));
            return bqb.build();
        }
        return new GeoPointDistanceQueryImpl(this.field, this.termEncoding, this, this.centerLon, new Rectangle(this.minLat, this.maxLat, this.minLon, this.maxLon));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GeoPointDistanceQuery)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GeoPointDistanceQuery that = (GeoPointDistanceQuery)((Object)o);
        if (Double.compare(that.centerLat, this.centerLat) != 0) {
            return false;
        }
        if (Double.compare(that.centerLon, this.centerLon) != 0) {
            return false;
        }
        return Double.compare(that.radiusMeters, this.radiusMeters) == 0;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.centerLon);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.centerLat);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.radiusMeters);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append(((Object)((Object)this)).getClass().getSimpleName());
        sb.append(':');
        if (!this.field.equals(field)) {
            sb.append(" field=");
            sb.append(this.field);
            sb.append(':');
        }
        return sb.append(" Center: [").append(this.centerLat).append(',').append(this.centerLon).append(']').append(" Distance: ").append(this.radiusMeters).append(" meters").append("]").toString();
    }

    public double getCenterLon() {
        return this.centerLon;
    }

    public double getCenterLat() {
        return this.centerLat;
    }

    public double getRadiusMeters() {
        return this.radiusMeters;
    }
}

