/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Optional;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.ImmutableGpxTrack;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.date.DateUtils;

public class NmeaReader {
    public GpxData data;
    private final SimpleDateFormat rmcTimeFmt = new SimpleDateFormat("ddMMyyHHmmss.SSS");
    private final SimpleDateFormat rmcTimeFmtStd = new SimpleDateFormat("ddMMyyHHmmss");
    public NMEAParserState ps;

    private Date readTime(String string) {
        Date date = Optional.ofNullable(this.rmcTimeFmt.parse(string, new ParsePosition(0))).orElseGet(() -> this.rmcTimeFmtStd.parse(string, new ParsePosition(0)));
        if (date == null) {
            throw new JosmRuntimeException("Date is malformed");
        }
        return date;
    }

    public int getParserUnknown() {
        return this.ps.unknown;
    }

    public int getParserZeroCoordinates() {
        return this.ps.zeroCoord;
    }

    public int getParserChecksumErrors() {
        return this.ps.checksumErrors + this.ps.noChecksum;
    }

    public int getParserMalformed() {
        return this.ps.malformed;
    }

    public int getNumberOfCoordinates() {
        return this.ps.success;
    }

    public NmeaReader(InputStream inputStream) throws IOException {
        this.rmcTimeFmt.setTimeZone(DateUtils.UTC);
        this.rmcTimeFmtStd.setTimeZone(DateUtils.UTC);
        this.data = new GpxData();
        ArrayList<Collection<WayPoint>> arrayList = new ArrayList<Collection<WayPoint>>();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            StringBuilder stringBuilder = new StringBuilder(1024);
            int n = bufferedReader.read();
            this.ps = new NMEAParserState();
            if (n == -1) {
                return;
            }
            stringBuilder.append((char)n);
            this.ps.pDate = "010100";
            while (true) {
                int n2;
                if (stringBuilder.length() >= 1020) {
                    stringBuilder.delete(0, stringBuilder.length() - 1);
                }
                if ((n2 = bufferedReader.read()) == 36) {
                    this.parseNMEASentence(stringBuilder.toString(), this.ps);
                    stringBuilder.delete(0, stringBuilder.length());
                    stringBuilder.append('$');
                    continue;
                }
                if (n2 == -1) break;
                stringBuilder.append((char)n2);
            }
            this.parseNMEASentence(stringBuilder.toString(), this.ps);
            arrayList.add(this.ps.waypoints);
            this.data.tracks.add(new ImmutableGpxTrack(arrayList, Collections.emptyMap()));
        }
        catch (IllegalDataException illegalDataException) {
            Main.warn(illegalDataException);
        }
    }

    private boolean parseNMEASentence(String string, NMEAParserState nMEAParserState) throws IllegalDataException {
        try {
            Object[] objectArray;
            if (string.isEmpty()) {
                throw new IllegalArgumentException("s is empty");
            }
            String[] stringArray = string.split("\\*");
            if (stringArray.length > 1) {
                objectArray = stringArray[0].getBytes(StandardCharsets.UTF_8);
                int n = 0;
                for (int i = 1; i < objectArray.length; ++i) {
                    n ^= objectArray[i];
                }
                if (Integer.parseInt(stringArray[1].substring(0, 2), 16) != n) {
                    ++nMEAParserState.checksumErrors;
                    nMEAParserState.pWp = null;
                    return false;
                }
            } else {
                ++nMEAParserState.noChecksum;
            }
            objectArray = stringArray[0].split(",");
            WayPoint wayPoint = nMEAParserState.pWp;
            Object object = nMEAParserState.pDate;
            if ("$GPGGA".equals(objectArray[0]) || "$GNGGA".equals(objectArray[0])) {
                LatLon latLon = NmeaReader.parseLatLon((String)objectArray[GPGGA.LATITUDE_NAME.position], (String)objectArray[GPGGA.LONGITUDE_NAME.position], (String)objectArray[GPGGA.LATITUDE.position], (String)objectArray[GPGGA.LONGITUDE.position]);
                if (latLon == null) {
                    throw new IllegalDataException("Malformed lat/lon");
                }
                if (LatLon.ZERO.equals(latLon)) {
                    ++nMEAParserState.zeroCoord;
                    return false;
                }
                byte by = objectArray[GPGGA.TIME.position];
                Date date = this.readTime(object + (String)by);
                if (nMEAParserState.pTime == null || wayPoint == null || !nMEAParserState.pTime.equals(by)) {
                    nMEAParserState.pTime = (String)by;
                    wayPoint = new WayPoint(latLon);
                }
                if (!wayPoint.attr.containsKey("time")) {
                    wayPoint.setTime(date);
                }
                if ("M".equals(by = objectArray[GPGGA.HEIGHT_UNTIS.position]) && !(by = objectArray[GPGGA.HEIGHT.position]).isEmpty()) {
                    Double.parseDouble((String)by);
                    if (!by.isEmpty()) {
                        wayPoint.put("ele", by);
                    }
                }
                by = objectArray[GPGGA.SATELLITE_COUNT.position];
                int n = 0;
                if (!by.isEmpty()) {
                    n = Integer.parseInt((String)by);
                    wayPoint.put("sat", by);
                }
                if (!(by = objectArray[GPGGA.HDOP.position]).isEmpty()) {
                    wayPoint.put("hdop", Float.valueOf((String)by));
                }
                if (!(by = objectArray[GPGGA.QUALITY.position]).isEmpty()) {
                    int n2 = Integer.parseInt((String)by);
                    switch (n2) {
                        case 0: {
                            wayPoint.put("fix", "none");
                            break;
                        }
                        case 1: {
                            if (n < 4) {
                                wayPoint.put("fix", "2d");
                                break;
                            }
                            wayPoint.put("fix", "3d");
                            break;
                        }
                        case 2: {
                            wayPoint.put("fix", "dgps");
                            break;
                        }
                    }
                }
            } else if ("$GPVTG".equals(objectArray[0]) || "$GNVTG".equals(objectArray[0])) {
                byte by = objectArray[GPVTG.COURSE_REF.position];
                if ("T".equals(by) && !(by = objectArray[GPVTG.COURSE.position]).isEmpty()) {
                    Double.parseDouble((String)by);
                    wayPoint.put("course", by);
                }
                if ((by = objectArray[GPVTG.SPEED_KMH_UNIT.position]).startsWith("K") && !(by = objectArray[GPVTG.SPEED_KMH.position]).isEmpty()) {
                    double d = Double.parseDouble((String)by);
                    wayPoint.put("speed", Double.toString(d /= 3.6));
                }
            } else if ("$GPGSA".equals(objectArray[0]) || "$GNGSA".equals(objectArray[0])) {
                byte by = objectArray[GPGSA.VDOP.position];
                if (!by.isEmpty()) {
                    wayPoint.put("vdop", Float.valueOf((String)by));
                }
                if (!(by = objectArray[GPGSA.HDOP.position]).isEmpty()) {
                    wayPoint.put("hdop", Float.valueOf((String)by));
                }
                if (!(by = objectArray[GPGSA.PDOP.position]).isEmpty()) {
                    wayPoint.put("pdop", Float.valueOf((String)by));
                }
            } else if ("$GPRMC".equals(objectArray[0]) || "$GNRMC".equals(objectArray[0])) {
                LatLon latLon = NmeaReader.parseLatLon((String)objectArray[GPRMC.WIDTH_NORTH_NAME.position], (String)objectArray[GPRMC.LENGTH_EAST_NAME.position], (String)objectArray[GPRMC.WIDTH_NORTH.position], (String)objectArray[GPRMC.LENGTH_EAST.position]);
                if (LatLon.ZERO.equals(latLon)) {
                    ++nMEAParserState.zeroCoord;
                    return false;
                }
                object = objectArray[GPRMC.DATE.position];
                byte by = objectArray[GPRMC.TIME.position];
                Date date = this.readTime(object + (String)by);
                if (nMEAParserState.pTime == null || wayPoint == null || !nMEAParserState.pTime.equals(by)) {
                    nMEAParserState.pTime = (String)by;
                    wayPoint = new WayPoint(latLon);
                }
                wayPoint.setTime(date);
                byte by2 = objectArray[GPRMC.SPEED.position];
                if (!by2.isEmpty() && !wayPoint.attr.containsKey("speed")) {
                    double d = Double.parseDouble((String)by2);
                    wayPoint.put("speed", Double.toString(d *= 0.514444444));
                }
                if (!(by2 = objectArray[GPRMC.COURSE.position]).isEmpty() && !wayPoint.attr.containsKey("course")) {
                    Double.parseDouble((String)by2);
                    wayPoint.put("course", by2);
                }
            } else {
                ++nMEAParserState.unknown;
                return false;
            }
            nMEAParserState.pDate = object;
            if (nMEAParserState.pWp != wayPoint) {
                if (nMEAParserState.pWp != null) {
                    nMEAParserState.pWp.setTime();
                }
                nMEAParserState.pWp = wayPoint;
                nMEAParserState.waypoints.add(wayPoint);
                ++nMEAParserState.success;
                return true;
            }
            return true;
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException | IllegalDataException exception) {
            Main.debug(exception);
            ++nMEAParserState.malformed;
            nMEAParserState.pWp = null;
            return false;
        }
    }

    private static LatLon parseLatLon(String string, String string2, String string3, String string4) {
        int n;
        String string5 = string3.trim();
        String string6 = string4.trim();
        if (string5.isEmpty() && string6.isEmpty()) {
            return LatLon.ZERO;
        }
        int n2 = string5.indexOf(46) - 2;
        if (n2 < 0) {
            return null;
        }
        int n3 = Integer.parseInt(string5.substring(0, n2));
        double d = Double.parseDouble(string5.substring(n2));
        if (n3 < 0) {
            d *= -1.0;
        }
        double d2 = (double)n3 + d / 60.0;
        if ("S".equals(string)) {
            d2 = -d2;
        }
        if ((n = string6.indexOf(46) - 2) < 0) {
            return null;
        }
        int n4 = Integer.parseInt(string6.substring(0, n));
        double d3 = Double.parseDouble(string6.substring(n));
        if (n4 < 0) {
            d3 *= -1.0;
        }
        double d4 = (double)n4 + d3 / 60.0;
        if ("W".equals(string2)) {
            d4 = -d4;
        }
        return new LatLon(d2, d4);
    }

    private static class NMEAParserState {
        protected Collection<WayPoint> waypoints = new ArrayList<WayPoint>();
        protected String pTime;
        protected String pDate;
        protected WayPoint pWp;
        protected int success;
        protected int malformed;
        protected int checksumErrors;
        protected int noChecksum;
        protected int unknown;
        protected int zeroCoord;

        private NMEAParserState() {
        }
    }

    public static enum GPGSA {
        AUTOMATIC(1),
        FIX_TYPE(2),
        PRN_1(3),
        PRN_2(4),
        PRN_3(5),
        PRN_4(6),
        PRN_5(7),
        PRN_6(8),
        PRN_7(9),
        PRN_8(10),
        PRN_9(11),
        PRN_10(12),
        PRN_11(13),
        PRN_12(14),
        PDOP(15),
        HDOP(16),
        VDOP(17);

        public final int position;

        private GPGSA(int n2) {
            this.position = n2;
        }
    }

    public static enum GPGGA {
        TIME(1),
        LATITUDE(2),
        LATITUDE_NAME(3),
        LONGITUDE(4),
        LONGITUDE_NAME(5),
        QUALITY(6),
        SATELLITE_COUNT(7),
        HDOP(8),
        HEIGHT(9),
        HEIGHT_UNTIS(10),
        HEIGHT_2(11),
        HEIGHT_2_UNTIS(12),
        GPS_AGE(13),
        REF(14);

        public final int position;

        private GPGGA(int n2) {
            this.position = n2;
        }
    }

    public static enum GPRMC {
        TIME(1),
        RECEIVER_WARNING(2),
        WIDTH_NORTH(3),
        WIDTH_NORTH_NAME(4),
        LENGTH_EAST(5),
        LENGTH_EAST_NAME(6),
        SPEED(7),
        COURSE(8),
        DATE(9),
        MAGNETIC_DECLINATION(10),
        UNKNOWN(11),
        MODE(12);

        public final int position;

        private GPRMC(int n2) {
            this.position = n2;
        }
    }

    public static enum GPVTG {
        COURSE(1),
        COURSE_REF(2),
        COURSE_M(3),
        COURSE_M_REF(4),
        SPEED_KN(5),
        SPEED_KN_UNIT(6),
        SPEED_KMH(7),
        SPEED_KMH_UNIT(8),
        REST(9);

        public final int position;

        private GPVTG(int n2) {
            this.position = n2;
        }
    }
}

