/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common;

import java.io.PrintStream;
import java.lang.reflect.Field;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.ValueDescription;
import org.jetbrains.kotlin.cli.common.parser.com.sampullara.cli.Argument;

class Usage {
    Usage() {
    }

    public static void print(@NotNull PrintStream target, @NotNull CommonCompilerArguments arguments2, boolean extraHelp) {
        if (target == null) {
            Usage.$$$reportNull$$$0(0);
        }
        if (arguments2 == null) {
            Usage.$$$reportNull$$$0(1);
        }
        target.println("Usage: " + arguments2.executableScriptFileName() + " <options> <source files>");
        target.println("where " + (extraHelp ? "advanced" : "possible") + " options include:");
        boolean coroutinesUsagePrinted = false;
        for (Class<?> clazz = arguments2.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                String usage = Usage.fieldUsage(field, extraHelp);
                if (usage == null) continue;
                if (usage.contains("Xcoroutines")) {
                    if (coroutinesUsagePrinted) continue;
                    coroutinesUsagePrinted = true;
                }
                target.println(usage);
            }
        }
        if (extraHelp) {
            target.println();
            target.println("Advanced options are non-standard and may be changed or removed without any notice.");
        }
    }

    @Nullable
    private static String fieldUsage(@NotNull Field field, boolean extraHelp) {
        boolean extraOption;
        Argument argument;
        if (field == null) {
            Usage.$$$reportNull$$$0(2);
        }
        if ((argument = field.getAnnotation(Argument.class)) == null) {
            return null;
        }
        ValueDescription description = field.getAnnotation(ValueDescription.class);
        String argumentValue = argument.value();
        boolean isXCoroutinesKey = argumentValue.contains("Xcoroutines");
        String value = isXCoroutinesKey ? "Xcoroutines={enable|warn|error}" : argument.value();
        boolean bl = extraOption = value.startsWith("X") && value.length() > 1;
        if (extraHelp != extraOption) {
            return null;
        }
        String prefix = argument.prefix();
        StringBuilder sb = new StringBuilder("  ");
        sb.append(prefix);
        sb.append(value);
        if (!argument.alias().isEmpty()) {
            sb.append(" (");
            sb.append(prefix);
            sb.append(argument.alias());
            sb.append(")");
        }
        if (description != null) {
            sb.append(" ");
            sb.append(description.value());
        }
        if (isXCoroutinesKey) {
            sb.append(" ");
            sb.append("Enable coroutines or report warnings or errors on declarations and use sites of 'suspend' modifier");
            return sb.toString();
        }
        int width = 28;
        if (sb.length() >= width + 5) {
            sb.append("\n");
            width += sb.length();
        }
        while (sb.length() < width) {
            sb.append(" ");
        }
        sb.append(" ");
        sb.append(argument.description());
        return sb.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/cli/common/Usage";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "print";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "fieldUsage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

